/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl$HMACMD5;
import org.apache.http.impl.auth.NTLMEngineImpl$MD4;
import org.apache.http.impl.auth.NTLMEngineImpl$Type1Message;
import org.apache.http.impl.auth.NTLMEngineImpl$Type2Message;
import org.apache.http.impl.auth.NTLMEngineImpl$Type3Message;
import org.apache.http.util.EncodingUtils;

@NotThreadSafe
final class NTLMEngineImpl
implements NTLMEngine {
    protected static final int FLAG_REQUEST_UNICODE_ENCODING = 1;
    protected static final int FLAG_REQUEST_TARGET = 4;
    protected static final int FLAG_REQUEST_SIGN = 16;
    protected static final int FLAG_REQUEST_SEAL = 32;
    protected static final int FLAG_REQUEST_LAN_MANAGER_KEY = 128;
    protected static final int FLAG_REQUEST_NTLMv1 = 512;
    protected static final int FLAG_DOMAIN_PRESENT = 4096;
    protected static final int FLAG_WORKSTATION_PRESENT = 8192;
    protected static final int FLAG_REQUEST_ALWAYS_SIGN = 32768;
    protected static final int FLAG_REQUEST_NTLM2_SESSION = 524288;
    protected static final int FLAG_REQUEST_VERSION = 0x2000000;
    protected static final int FLAG_TARGETINFO_PRESENT = 0x800000;
    protected static final int FLAG_REQUEST_128BIT_KEY_EXCH = 0x20000000;
    protected static final int FLAG_REQUEST_EXPLICIT_KEY_EXCH = 0x40000000;
    protected static final int FLAG_REQUEST_56BIT_ENCRYPTION = Integer.MIN_VALUE;
    private static final SecureRandom RND_GEN;
    static final String DEFAULT_CHARSET = "ASCII";
    private String credentialCharset = "ASCII";
    private static final byte[] SIGNATURE;

    NTLMEngineImpl() {
    }

    final String getResponseFor(String string, String string2, String string3, String string4, String string5) {
        String string6;
        if (string == null || string.trim().equals("")) {
            string6 = this.getType1Message(string4, string5);
        } else {
            NTLMEngineImpl$Type2Message nTLMEngineImpl$Type2Message = new NTLMEngineImpl$Type2Message(string);
            string6 = this.getType3Message(string2, string3, string4, string5, nTLMEngineImpl$Type2Message.getChallenge(), nTLMEngineImpl$Type2Message.getFlags(), nTLMEngineImpl$Type2Message.getTarget(), nTLMEngineImpl$Type2Message.getTargetInfo());
        }
        return string6;
    }

    String getType1Message(String string, String string2) {
        return new NTLMEngineImpl$Type1Message(string2, string).getResponse();
    }

    String getType3Message(String string, String string2, String string3, String string4, byte[] byArray, int n2, String string5, byte[] byArray2) {
        return new NTLMEngineImpl$Type3Message(string4, string3, string, string2, byArray, n2, string5, byArray2).getResponse();
    }

    String getCredentialCharset() {
        return this.credentialCharset;
    }

    void setCredentialCharset(String string) {
        this.credentialCharset = string;
    }

    private static String stripDotSuffix(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(".");
        if (n2 != -1) {
            return string.substring(0, n2);
        }
        return string;
    }

    private static String convertHost(String string) {
        return NTLMEngineImpl.stripDotSuffix(string);
    }

    private static String convertDomain(String string) {
        return NTLMEngineImpl.stripDotSuffix(string);
    }

    private static int readULong(byte[] byArray, int n2) {
        if (byArray.length < n2 + 4) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for DWORD");
        }
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    private static int readUShort(byte[] byArray, int n2) {
        if (byArray.length < n2 + 2) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for WORD");
        }
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    private static byte[] readSecurityBuffer(byte[] byArray, int n2) {
        int n3 = NTLMEngineImpl.readUShort(byArray, n2);
        int n4 = NTLMEngineImpl.readULong(byArray, n2 + 4);
        if (byArray.length < n4 + n3) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for data item");
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n4, byArray2, 0, n3);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeRandomChallenge() {
        if (RND_GEN == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        byte[] byArray = new byte[8];
        SecureRandom secureRandom = RND_GEN;
        synchronized (secureRandom) {
            RND_GEN.nextBytes(byArray);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeSecondaryKey() {
        if (RND_GEN == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        byte[] byArray = new byte[16];
        SecureRandom secureRandom = RND_GEN;
        synchronized (secureRandom) {
            RND_GEN.nextBytes(byArray);
        }
        return byArray;
    }

    static byte[] hmacMD5(byte[] byArray, byte[] byArray2) {
        NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5(byArray2);
        nTLMEngineImpl$HMACMD5.update(byArray);
        return nTLMEngineImpl$HMACMD5.getOutput();
    }

    static byte[] RC4(byte[] byArray, byte[] byArray2) {
        try {
            Cipher cipher = Cipher.getInstance("RC4");
            cipher.init(1, new SecretKeySpec(byArray2, "RC4"));
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    static byte[] ntlm2SessionResponse(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            byte[] byArray4 = messageDigest.digest();
            byte[] byArray5 = new byte[8];
            System.arraycopy(byArray4, 0, byArray5, 0, 8);
            return NTLMEngineImpl.lmResponse(byArray, byArray5);
        }
        catch (Exception exception) {
            if (exception instanceof NTLMEngineException) {
                throw (NTLMEngineException)exception;
            }
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] lmHash(String string) {
        try {
            byte[] byArray = string.toUpperCase(Locale.US).getBytes("US-ASCII");
            int n2 = Math.min(byArray.length, 14);
            byte[] byArray2 = new byte[14];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            Key key = NTLMEngineImpl.createDESKey(byArray2, 0);
            Key key2 = NTLMEngineImpl.createDESKey(byArray2, 7);
            byte[] byArray3 = "KGS!@#$%".getBytes("US-ASCII");
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] byArray4 = cipher.doFinal(byArray3);
            cipher.init(1, key2);
            byte[] byArray5 = cipher.doFinal(byArray3);
            byte[] byArray6 = new byte[16];
            System.arraycopy(byArray4, 0, byArray6, 0, 8);
            System.arraycopy(byArray5, 0, byArray6, 8, 8);
            return byArray6;
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] ntlmHash(String string) {
        try {
            byte[] byArray = string.getBytes("UnicodeLittleUnmarked");
            NTLMEngineImpl$MD4 nTLMEngineImpl$MD4 = new NTLMEngineImpl$MD4();
            nTLMEngineImpl$MD4.update(byArray);
            return nTLMEngineImpl$MD4.getOutput();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NTLMEngineException("Unicode not supported: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private static byte[] lmv2Hash(String string, String string2, byte[] byArray) {
        try {
            NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5(byArray);
            nTLMEngineImpl$HMACMD5.update(string2.toUpperCase(Locale.US).getBytes("UnicodeLittleUnmarked"));
            if (string != null) {
                nTLMEngineImpl$HMACMD5.update(string.toUpperCase(Locale.US).getBytes("UnicodeLittleUnmarked"));
            }
            return nTLMEngineImpl$HMACMD5.getOutput();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NTLMEngineException("Unicode not supported! " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private static byte[] ntlmv2Hash(String string, String string2, byte[] byArray) {
        try {
            NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5(byArray);
            nTLMEngineImpl$HMACMD5.update(string2.toUpperCase(Locale.US).getBytes("UnicodeLittleUnmarked"));
            if (string != null) {
                nTLMEngineImpl$HMACMD5.update(string.getBytes("UnicodeLittleUnmarked"));
            }
            return nTLMEngineImpl$HMACMD5.getOutput();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NTLMEngineException("Unicode not supported! " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private static byte[] lmResponse(byte[] byArray, byte[] byArray2) {
        try {
            byte[] byArray3 = new byte[21];
            System.arraycopy(byArray, 0, byArray3, 0, 16);
            Key key = NTLMEngineImpl.createDESKey(byArray3, 0);
            Key key2 = NTLMEngineImpl.createDESKey(byArray3, 7);
            Key key3 = NTLMEngineImpl.createDESKey(byArray3, 14);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] byArray4 = cipher.doFinal(byArray2);
            cipher.init(1, key2);
            byte[] byArray5 = cipher.doFinal(byArray2);
            cipher.init(1, key3);
            byte[] byArray6 = cipher.doFinal(byArray2);
            byte[] byArray7 = new byte[24];
            System.arraycopy(byArray4, 0, byArray7, 0, 8);
            System.arraycopy(byArray5, 0, byArray7, 8, 8);
            System.arraycopy(byArray6, 0, byArray7, 16, 8);
            return byArray7;
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] lmv2Response(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        NTLMEngineImpl$HMACMD5 nTLMEngineImpl$HMACMD5 = new NTLMEngineImpl$HMACMD5(byArray);
        nTLMEngineImpl$HMACMD5.update(byArray2);
        nTLMEngineImpl$HMACMD5.update(byArray3);
        byte[] byArray4 = nTLMEngineImpl$HMACMD5.getOutput();
        byte[] byArray5 = new byte[byArray4.length + byArray3.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray5, byArray4.length, byArray3.length);
        return byArray5;
    }

    private static byte[] createBlob(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[]{1, 1, 0, 0};
        byte[] byArray5 = new byte[]{0, 0, 0, 0};
        byte[] byArray6 = new byte[]{0, 0, 0, 0};
        byte[] byArray7 = new byte[]{0, 0, 0, 0};
        byte[] byArray8 = new byte[byArray4.length + byArray5.length + byArray3.length + 8 + byArray6.length + byArray2.length + byArray7.length];
        int n2 = 0;
        System.arraycopy(byArray4, 0, byArray8, n2, byArray4.length);
        System.arraycopy(byArray5, 0, byArray8, n2 += byArray4.length, byArray5.length);
        System.arraycopy(byArray3, 0, byArray8, n2 += byArray5.length, byArray3.length);
        System.arraycopy(byArray, 0, byArray8, n2 += byArray3.length, 8);
        System.arraycopy(byArray6, 0, byArray8, n2 += 8, byArray6.length);
        System.arraycopy(byArray2, 0, byArray8, n2 += byArray6.length, byArray2.length);
        System.arraycopy(byArray7, 0, byArray8, n2 += byArray2.length, byArray7.length);
        n2 += byArray7.length;
        return byArray8;
    }

    private static Key createDESKey(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[7];
        System.arraycopy(byArray, n2, byArray2, 0, 7);
        byte[] byArray3 = new byte[]{byArray2[0], (byte)(byArray2[0] << 7 | (byArray2[1] & 0xFF) >>> 1), (byte)(byArray2[1] << 6 | (byArray2[2] & 0xFF) >>> 2), (byte)(byArray2[2] << 5 | (byArray2[3] & 0xFF) >>> 3), (byte)(byArray2[3] << 4 | (byArray2[4] & 0xFF) >>> 4), (byte)(byArray2[4] << 3 | (byArray2[5] & 0xFF) >>> 5), (byte)(byArray2[5] << 2 | (byArray2[6] & 0xFF) >>> 6), (byte)(byArray2[6] << 1)};
        NTLMEngineImpl.oddParity(byArray3);
        return new SecretKeySpec(byArray3, "DES");
    }

    private static void oddParity(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            boolean bl2;
            byte by2 = byArray[i2];
            boolean bl3 = bl2 = ((by2 >>> 7 ^ by2 >>> 6 ^ by2 >>> 5 ^ by2 >>> 4 ^ by2 >>> 3 ^ by2 >>> 2 ^ by2 >>> 1) & 1) == 0;
            if (bl2) {
                int n2 = i2;
                byArray[n2] = (byte)(byArray[n2] | 1);
                continue;
            }
            int n3 = i2;
            byArray[n3] = (byte)(byArray[n3] & 0xFFFFFFFE);
        }
    }

    static void writeULong(byte[] byArray, int n2, int n3) {
        byArray[n3] = (byte)(n2 & 0xFF);
        byArray[n3 + 1] = (byte)(n2 >> 8 & 0xFF);
        byArray[n3 + 2] = (byte)(n2 >> 16 & 0xFF);
        byArray[n3 + 3] = (byte)(n2 >> 24 & 0xFF);
    }

    static int F(int n2, int n3, int n4) {
        return n2 & n3 | ~n2 & n4;
    }

    static int G(int n2, int n3, int n4) {
        return n2 & n3 | n2 & n4 | n3 & n4;
    }

    static int H(int n2, int n3, int n4) {
        return n2 ^ n3 ^ n4;
    }

    static int rotintlft(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    public String generateType1Msg(String string, String string2) {
        return this.getType1Message(string2, string);
    }

    public String generateType3Msg(String string, String string2, String string3, String string4, String string5) {
        NTLMEngineImpl$Type2Message nTLMEngineImpl$Type2Message = new NTLMEngineImpl$Type2Message(string5);
        return this.getType3Message(string, string2, string4, string3, nTLMEngineImpl$Type2Message.getChallenge(), nTLMEngineImpl$Type2Message.getFlags(), nTLMEngineImpl$Type2Message.getTarget(), nTLMEngineImpl$Type2Message.getTargetInfo());
    }

    static /* synthetic */ byte[] access$000() {
        return NTLMEngineImpl.makeRandomChallenge();
    }

    static /* synthetic */ byte[] access$100() {
        return NTLMEngineImpl.makeSecondaryKey();
    }

    static /* synthetic */ byte[] access$200(String string) {
        return NTLMEngineImpl.lmHash(string);
    }

    static /* synthetic */ byte[] access$300(byte[] byArray, byte[] byArray2) {
        return NTLMEngineImpl.lmResponse(byArray, byArray2);
    }

    static /* synthetic */ byte[] access$400(String string) {
        return NTLMEngineImpl.ntlmHash(string);
    }

    static /* synthetic */ byte[] access$500(String string, String string2, byte[] byArray) {
        return NTLMEngineImpl.lmv2Hash(string, string2, byArray);
    }

    static /* synthetic */ byte[] access$600(String string, String string2, byte[] byArray) {
        return NTLMEngineImpl.ntlmv2Hash(string, string2, byArray);
    }

    static /* synthetic */ byte[] access$700(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return NTLMEngineImpl.createBlob(byArray, byArray2, byArray3);
    }

    static /* synthetic */ byte[] access$800(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return NTLMEngineImpl.lmv2Response(byArray, byArray2, byArray3);
    }

    static /* synthetic */ Key access$900(byte[] byArray, int n2) {
        return NTLMEngineImpl.createDESKey(byArray, n2);
    }

    static /* synthetic */ byte[] access$1000() {
        return SIGNATURE;
    }

    static /* synthetic */ int access$1100(byte[] byArray, int n2) {
        return NTLMEngineImpl.readUShort(byArray, n2);
    }

    static /* synthetic */ int access$1200(byte[] byArray, int n2) {
        return NTLMEngineImpl.readULong(byArray, n2);
    }

    static /* synthetic */ byte[] access$1300(byte[] byArray, int n2) {
        return NTLMEngineImpl.readSecurityBuffer(byArray, n2);
    }

    static /* synthetic */ String access$1400(String string) {
        return NTLMEngineImpl.convertHost(string);
    }

    static /* synthetic */ String access$1500(String string) {
        return NTLMEngineImpl.convertDomain(string);
    }

    static {
        Object object = null;
        try {
            object = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RND_GEN = object;
        object = EncodingUtils.getBytes("NTLMSSP", DEFAULT_CHARSET);
        SIGNATURE = new byte[((Object)object).length + 1];
        System.arraycopy(object, 0, SIGNATURE, 0, ((Object)object).length);
        NTLMEngineImpl.SIGNATURE[((Object)object).length] = 0;
    }
}

