/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.io.UnsupportedEncodingException;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl$NTLMMessage;

class NTLMEngineImpl$Type2Message
extends NTLMEngineImpl$NTLMMessage {
    protected byte[] challenge = new byte[8];
    protected String target;
    protected byte[] targetInfo;
    protected int flags;

    NTLMEngineImpl$Type2Message(String string) {
        super(string, 2);
        byte[] byArray;
        this.readBytes(this.challenge, 24);
        this.flags = this.readULong(20);
        if ((this.flags & 1) == 0) {
            throw new NTLMEngineException("NTLM type 2 message has flags that make no sense: " + Integer.toString(this.flags));
        }
        this.target = null;
        if (this.getMessageLength() >= 20 && (byArray = this.readSecurityBuffer(12)).length != 0) {
            try {
                this.target = new String(byArray, "UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new NTLMEngineException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        this.targetInfo = null;
        if (this.getMessageLength() >= 48 && (byArray = this.readSecurityBuffer(40)).length != 0) {
            this.targetInfo = byArray;
        }
    }

    byte[] getChallenge() {
        return this.challenge;
    }

    String getTarget() {
        return this.target;
    }

    byte[] getTargetInfo() {
        return this.targetInfo;
    }

    int getFlags() {
        return this.flags;
    }
}

