/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.impl.auth.NTLMEngineImpl;
import org.apache.http.impl.auth.NTLMEngineImpl$MD4;

public class NTLMEngineImpl$CipherGen {
    protected final String domain;
    protected final String user;
    protected final String password;
    protected final byte[] challenge;
    protected final String target;
    protected final byte[] targetInformation;
    protected byte[] clientChallenge;
    protected byte[] clientChallenge2;
    protected byte[] secondaryKey;
    protected byte[] timestamp;
    protected byte[] lmHash = null;
    protected byte[] lmResponse = null;
    protected byte[] ntlmHash = null;
    protected byte[] ntlmResponse = null;
    protected byte[] ntlmv2Hash = null;
    protected byte[] lmv2Hash = null;
    protected byte[] lmv2Response = null;
    protected byte[] ntlmv2Blob = null;
    protected byte[] ntlmv2Response = null;
    protected byte[] ntlm2SessionResponse = null;
    protected byte[] lm2SessionResponse = null;
    protected byte[] lmUserSessionKey = null;
    protected byte[] ntlmUserSessionKey = null;
    protected byte[] ntlmv2UserSessionKey = null;
    protected byte[] ntlm2SessionResponseUserSessionKey = null;
    protected byte[] lanManagerSessionKey = null;

    public NTLMEngineImpl$CipherGen(String string, String string2, String string3, byte[] byArray, String string4, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        this.domain = string;
        this.target = string4;
        this.user = string2;
        this.password = string3;
        this.challenge = byArray;
        this.targetInformation = byArray2;
        this.clientChallenge = byArray3;
        this.clientChallenge2 = byArray4;
        this.secondaryKey = byArray5;
        this.timestamp = byArray6;
    }

    public NTLMEngineImpl$CipherGen(String string, String string2, String string3, byte[] byArray, String string4, byte[] byArray2) {
        this(string, string2, string3, byArray, string4, byArray2, null, null, null, null);
    }

    public byte[] getClientChallenge() {
        if (this.clientChallenge == null) {
            this.clientChallenge = NTLMEngineImpl.access$000();
        }
        return this.clientChallenge;
    }

    public byte[] getClientChallenge2() {
        if (this.clientChallenge2 == null) {
            this.clientChallenge2 = NTLMEngineImpl.access$000();
        }
        return this.clientChallenge2;
    }

    public byte[] getSecondaryKey() {
        if (this.secondaryKey == null) {
            this.secondaryKey = NTLMEngineImpl.access$100();
        }
        return this.secondaryKey;
    }

    public byte[] getLMHash() {
        if (this.lmHash == null) {
            this.lmHash = NTLMEngineImpl.access$200(this.password);
        }
        return this.lmHash;
    }

    public byte[] getLMResponse() {
        if (this.lmResponse == null) {
            this.lmResponse = NTLMEngineImpl.access$300(this.getLMHash(), this.challenge);
        }
        return this.lmResponse;
    }

    public byte[] getNTLMHash() {
        if (this.ntlmHash == null) {
            this.ntlmHash = NTLMEngineImpl.access$400(this.password);
        }
        return this.ntlmHash;
    }

    public byte[] getNTLMResponse() {
        if (this.ntlmResponse == null) {
            this.ntlmResponse = NTLMEngineImpl.access$300(this.getNTLMHash(), this.challenge);
        }
        return this.ntlmResponse;
    }

    public byte[] getLMv2Hash() {
        if (this.lmv2Hash == null) {
            this.lmv2Hash = NTLMEngineImpl.access$500(this.domain, this.user, this.getNTLMHash());
        }
        return this.lmv2Hash;
    }

    public byte[] getNTLMv2Hash() {
        if (this.ntlmv2Hash == null) {
            this.ntlmv2Hash = NTLMEngineImpl.access$600(this.domain, this.user, this.getNTLMHash());
        }
        return this.ntlmv2Hash;
    }

    public byte[] getTimestamp() {
        if (this.timestamp == null) {
            long l2 = System.currentTimeMillis();
            l2 += 11644473600000L;
            l2 *= 10000L;
            this.timestamp = new byte[8];
            for (int i2 = 0; i2 < 8; ++i2) {
                this.timestamp[i2] = (byte)l2;
                l2 >>>= 8;
            }
        }
        return this.timestamp;
    }

    public byte[] getNTLMv2Blob() {
        if (this.ntlmv2Blob == null) {
            this.ntlmv2Blob = NTLMEngineImpl.access$700(this.getClientChallenge2(), this.targetInformation, this.getTimestamp());
        }
        return this.ntlmv2Blob;
    }

    public byte[] getNTLMv2Response() {
        if (this.ntlmv2Response == null) {
            this.ntlmv2Response = NTLMEngineImpl.access$800(this.getNTLMv2Hash(), this.challenge, this.getNTLMv2Blob());
        }
        return this.ntlmv2Response;
    }

    public byte[] getLMv2Response() {
        if (this.lmv2Response == null) {
            this.lmv2Response = NTLMEngineImpl.access$800(this.getLMv2Hash(), this.challenge, this.getClientChallenge());
        }
        return this.lmv2Response;
    }

    public byte[] getNTLM2SessionResponse() {
        if (this.ntlm2SessionResponse == null) {
            this.ntlm2SessionResponse = NTLMEngineImpl.ntlm2SessionResponse(this.getNTLMHash(), this.challenge, this.getClientChallenge());
        }
        return this.ntlm2SessionResponse;
    }

    public byte[] getLM2SessionResponse() {
        if (this.lm2SessionResponse == null) {
            byte[] byArray = this.getClientChallenge();
            this.lm2SessionResponse = new byte[24];
            System.arraycopy(byArray, 0, this.lm2SessionResponse, 0, byArray.length);
            Arrays.fill(this.lm2SessionResponse, byArray.length, this.lm2SessionResponse.length, (byte)0);
        }
        return this.lm2SessionResponse;
    }

    public byte[] getLMUserSessionKey() {
        if (this.lmUserSessionKey == null) {
            byte[] byArray = this.getLMHash();
            this.lmUserSessionKey = new byte[16];
            System.arraycopy(byArray, 0, this.lmUserSessionKey, 0, 8);
            Arrays.fill(this.lmUserSessionKey, 8, 16, (byte)0);
        }
        return this.lmUserSessionKey;
    }

    public byte[] getNTLMUserSessionKey() {
        if (this.ntlmUserSessionKey == null) {
            byte[] byArray = this.getNTLMHash();
            NTLMEngineImpl$MD4 nTLMEngineImpl$MD4 = new NTLMEngineImpl$MD4();
            nTLMEngineImpl$MD4.update(byArray);
            this.ntlmUserSessionKey = nTLMEngineImpl$MD4.getOutput();
        }
        return this.ntlmUserSessionKey;
    }

    public byte[] getNTLMv2UserSessionKey() {
        if (this.ntlmv2UserSessionKey == null) {
            byte[] byArray = this.getNTLMv2Hash();
            byte[] byArray2 = new byte[16];
            System.arraycopy(this.getNTLMv2Response(), 0, byArray2, 0, 16);
            this.ntlmv2UserSessionKey = NTLMEngineImpl.hmacMD5(byArray2, byArray);
        }
        return this.ntlmv2UserSessionKey;
    }

    public byte[] getNTLM2SessionResponseUserSessionKey() {
        if (this.ntlm2SessionResponseUserSessionKey == null) {
            byte[] byArray = this.getNTLMUserSessionKey();
            byte[] byArray2 = this.getLM2SessionResponse();
            byte[] byArray3 = new byte[this.challenge.length + byArray2.length];
            System.arraycopy(this.challenge, 0, byArray3, 0, this.challenge.length);
            System.arraycopy(byArray2, 0, byArray3, this.challenge.length, byArray2.length);
            this.ntlm2SessionResponseUserSessionKey = NTLMEngineImpl.hmacMD5(byArray3, byArray);
        }
        return this.ntlm2SessionResponseUserSessionKey;
    }

    public byte[] getLanManagerSessionKey() {
        if (this.lanManagerSessionKey == null) {
            byte[] byArray = this.getLMHash();
            byte[] byArray2 = this.getLMResponse();
            try {
                byte[] byArray3 = new byte[14];
                System.arraycopy(byArray, 0, byArray3, 0, 8);
                Arrays.fill(byArray3, 8, byArray3.length, (byte)-67);
                Key key = NTLMEngineImpl.access$900(byArray3, 0);
                Key key2 = NTLMEngineImpl.access$900(byArray3, 7);
                byte[] byArray4 = new byte[8];
                System.arraycopy(byArray2, 0, byArray4, 0, byArray4.length);
                Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
                cipher.init(1, key);
                byte[] byArray5 = cipher.doFinal(byArray4);
                cipher = Cipher.getInstance("DES/ECB/NoPadding");
                cipher.init(1, key2);
                byte[] byArray6 = cipher.doFinal(byArray4);
                this.lanManagerSessionKey = new byte[16];
                System.arraycopy(byArray5, 0, this.lanManagerSessionKey, 0, byArray5.length);
                System.arraycopy(byArray6, 0, this.lanManagerSessionKey, byArray5.length, byArray6.length);
            }
            catch (Exception exception) {
                throw new NTLMEngineException(exception.getMessage(), exception);
            }
        }
        return this.lanManagerSessionKey;
    }
}

