/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.util.Locale;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.ContextAwareAuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public abstract class AuthSchemeBase
implements ContextAwareAuthScheme {
    private ChallengeState challengeState;

    @Deprecated
    public AuthSchemeBase(ChallengeState challengeState) {
        this.challengeState = challengeState;
    }

    public AuthSchemeBase() {
    }

    public void processChallenge(Header header) {
        int n2;
        CharArrayBuffer charArrayBuffer;
        Args.notNull(header, "Header");
        String string = header.getName();
        if (string.equalsIgnoreCase("WWW-Authenticate")) {
            this.challengeState = ChallengeState.TARGET;
        } else if (string.equalsIgnoreCase("Proxy-Authenticate")) {
            this.challengeState = ChallengeState.PROXY;
        } else {
            throw new MalformedChallengeException("Unexpected header name: " + string);
        }
        if (header instanceof FormattedHeader) {
            charArrayBuffer = ((FormattedHeader)header).getBuffer();
            n2 = ((FormattedHeader)header).getValuePos();
        } else {
            String string2 = header.getValue();
            if (string2 == null) {
                throw new MalformedChallengeException("Header value is null");
            }
            charArrayBuffer = new CharArrayBuffer(string2.length());
            charArrayBuffer.append(string2);
            n2 = 0;
        }
        while (n2 < charArrayBuffer.length() && HTTP.isWhitespace(charArrayBuffer.charAt(n2))) {
            ++n2;
        }
        int n3 = n2;
        while (n2 < charArrayBuffer.length() && !HTTP.isWhitespace(charArrayBuffer.charAt(n2))) {
            ++n2;
        }
        int n4 = n2;
        String string3 = charArrayBuffer.substring(n3, n4);
        if (!string3.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("Invalid scheme identifier: " + string3);
        }
        this.parseChallenge(charArrayBuffer, n2, charArrayBuffer.length());
    }

    public Header authenticate(Credentials credentials, HttpRequest httpRequest, HttpContext httpContext) {
        return this.authenticate(credentials, httpRequest);
    }

    protected abstract void parseChallenge(CharArrayBuffer var1, int var2, int var3);

    public boolean isProxy() {
        return this.challengeState != null && this.challengeState == ChallengeState.PROXY;
    }

    public ChallengeState getChallengeState() {
        return this.challengeState;
    }

    public String toString() {
        String string = this.getSchemeName();
        if (string != null) {
            return string.toUpperCase(Locale.US);
        }
        return super.toString();
    }
}

