/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

@NotThreadSafe
public class InputStreamEntity
extends AbstractHttpEntity {
    private final InputStream content;
    private final long length;

    public InputStreamEntity(InputStream inputStream) {
        this(inputStream, -1L);
    }

    public InputStreamEntity(InputStream inputStream, long l2) {
        this(inputStream, l2, null);
    }

    public InputStreamEntity(InputStream inputStream, ContentType contentType) {
        this(inputStream, -1L, contentType);
    }

    public InputStreamEntity(InputStream inputStream, long l2, ContentType contentType) {
        this.content = Args.notNull(inputStream, "Source input stream");
        this.length = l2;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public boolean isRepeatable() {
        return false;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) {
        block7: {
            Args.notNull(outputStream, "Output stream");
            InputStream inputStream = this.content;
            try {
                int n2;
                byte[] byArray = new byte[4096];
                if (this.length < 0L) {
                    int n3;
                    while ((n3 = inputStream.read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n3);
                    }
                    break block7;
                }
                for (long i2 = this.length; i2 > 0L; i2 -= (long)n2) {
                    n2 = inputStream.read(byArray, 0, (int)Math.min(4096L, i2));
                    if (n2 == -1) {
                        break;
                    }
                    outputStream.write(byArray, 0, n2);
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    public boolean isStreaming() {
        return true;
    }
}

