/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.config;

import org.apache.http.annotation.Immutable;
import org.apache.http.config.SocketConfig$Builder;
import org.apache.http.util.Args;

@Immutable
public class SocketConfig
implements Cloneable {
    public static final SocketConfig DEFAULT = new SocketConfig$Builder().build();
    private final int soTimeout;
    private final boolean soReuseAddress;
    private final int soLinger;
    private final boolean soKeepAlive;
    private final boolean tcpNoDelay;

    SocketConfig(int n2, boolean bl2, int n3, boolean bl3, boolean bl4) {
        this.soTimeout = n2;
        this.soReuseAddress = bl2;
        this.soLinger = n3;
        this.soKeepAlive = bl3;
        this.tcpNoDelay = bl4;
    }

    public int getSoTimeout() {
        return this.soTimeout;
    }

    public boolean isSoReuseAddress() {
        return this.soReuseAddress;
    }

    public int getSoLinger() {
        return this.soLinger;
    }

    public boolean isSoKeepAlive() {
        return this.soKeepAlive;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    protected SocketConfig clone() {
        return (SocketConfig)super.clone();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[soTimeout=").append(this.soTimeout).append(", soReuseAddress=").append(this.soReuseAddress).append(", soLinger=").append(this.soLinger).append(", soKeepAlive=").append(this.soKeepAlive).append(", tcpNoDelay=").append(this.tcpNoDelay).append("]");
        return stringBuilder.toString();
    }

    public static SocketConfig$Builder custom() {
        return new SocketConfig$Builder();
    }

    public static SocketConfig$Builder copy(SocketConfig socketConfig) {
        Args.notNull(socketConfig, "Socket config");
        return new SocketConfig$Builder().setSoTimeout(socketConfig.getSoTimeout()).setSoReuseAddress(socketConfig.isSoReuseAddress()).setSoLinger(socketConfig.getSoLinger()).setSoKeepAlive(socketConfig.isSoKeepAlive()).setTcpNoDelay(socketConfig.isTcpNoDelay());
    }
}

