/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.config;

import org.apache.http.config.MessageConstraints$Builder;
import org.apache.http.util.Args;

public class MessageConstraints
implements Cloneable {
    public static final MessageConstraints DEFAULT = new MessageConstraints$Builder().build();
    private final int maxLineLength;
    private final int maxHeaderCount;

    MessageConstraints(int n2, int n3) {
        this.maxLineLength = n2;
        this.maxHeaderCount = n3;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    protected MessageConstraints clone() {
        return (MessageConstraints)super.clone();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[maxLineLength=").append(this.maxLineLength).append(", maxHeaderCount=").append(this.maxHeaderCount).append("]");
        return stringBuilder.toString();
    }

    public static MessageConstraints lineLen(int n2) {
        return new MessageConstraints(Args.notNegative(n2, "Max line length"), -1);
    }

    public static MessageConstraints$Builder custom() {
        return new MessageConstraints$Builder();
    }

    public static MessageConstraints$Builder copy(MessageConstraints messageConstraints) {
        Args.notNull(messageConstraints, "Message constraints");
        return new MessageConstraints$Builder().setMaxHeaderCount(messageConstraints.getMaxHeaderCount()).setMaxLineLength(messageConstraints.getMaxLineLength());
    }
}

