/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.cookie.SetCookie2;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@Immutable
public class RequestAddCookies
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        int n2;
        Object object;
        Args.notNull(httpRequest, "HTTP request");
        Args.notNull(httpContext, "HTTP context");
        String string = httpRequest.getRequestLine().getMethod();
        if (string.equalsIgnoreCase("CONNECT")) {
            return;
        }
        HttpClientContext httpClientContext = HttpClientContext.adapt(httpContext);
        CookieStore cookieStore = httpClientContext.getCookieStore();
        if (cookieStore == null) {
            this.log.debug("Cookie store not specified in HTTP context");
            return;
        }
        Lookup<CookieSpecProvider> lookup = httpClientContext.getCookieSpecRegistry();
        if (lookup == null) {
            this.log.debug("CookieSpec registry not specified in HTTP context");
            return;
        }
        HttpHost httpHost = httpClientContext.getTargetHost();
        if (httpHost == null) {
            this.log.debug("Target host not set in the context");
            return;
        }
        RouteInfo routeInfo = httpClientContext.getHttpRoute();
        if (routeInfo == null) {
            this.log.debug("Connection route not set in the context");
            return;
        }
        RequestConfig requestConfig = httpClientContext.getRequestConfig();
        String string2 = requestConfig.getCookieSpec();
        if (string2 == null) {
            string2 = "best-match";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("CookieSpec selected: " + string2);
        }
        URI uRI = null;
        if (httpRequest instanceof HttpUriRequest) {
            uRI = ((HttpUriRequest)httpRequest).getURI();
        } else {
            try {
                uRI = new URI(httpRequest.getRequestLine().getUri());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String string3 = uRI != null ? uRI.getPath() : null;
        String string4 = httpHost.getHostName();
        int n3 = httpHost.getPort();
        if (n3 < 0) {
            n3 = routeInfo.getTargetHost().getPort();
        }
        CookieOrigin cookieOrigin = new CookieOrigin(string4, n3 >= 0 ? n3 : 0, !TextUtils.isEmpty(string3) ? string3 : "/", routeInfo.isSecure());
        CookieSpecProvider cookieSpecProvider = lookup.lookup(string2);
        if (cookieSpecProvider == null) {
            throw new HttpException("Unsupported cookie policy: " + string2);
        }
        CookieSpec cookieSpec = cookieSpecProvider.create(httpClientContext);
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>(cookieStore.getCookies());
        ArrayList<Cookie> arrayList2 = new ArrayList<Cookie>();
        Date date = new Date();
        for (Cookie object2 : arrayList) {
            if (!object2.isExpired(date)) {
                if (!cookieSpec.match(object2, cookieOrigin)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cookie " + object2 + " match " + cookieOrigin);
                }
                arrayList2.add(object2);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Cookie " + object2 + " expired");
        }
        if (!arrayList2.isEmpty()) {
            List<Header> list = cookieSpec.formatCookies(arrayList2);
            Iterator bl2 = list.iterator();
            while (bl2.hasNext()) {
                object = (Header)bl2.next();
                httpRequest.addHeader((Header)object);
            }
        }
        if ((n2 = cookieSpec.getVersion()) > 0) {
            boolean bl2;
            boolean bl3 = false;
            object = arrayList2.iterator();
            while (object.hasNext()) {
                Cookie cookie = (Cookie)object.next();
                if (n2 == cookie.getVersion() && cookie instanceof SetCookie2) continue;
                bl2 = true;
            }
            if (bl2 && (object = cookieSpec.getVersionHeader()) != null) {
                httpRequest.addHeader((Header)object);
            }
        }
        httpContext.setAttribute("http.cookie-spec", cookieSpec);
        httpContext.setAttribute("http.cookie-origin", cookieOrigin);
    }
}

