/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.entity;

import java.io.InputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.client.entity.DecompressingEntity;

@NotThreadSafe
class LazyDecompressingInputStream
extends InputStream {
    private final InputStream wrappedStream;
    private final DecompressingEntity decompressingEntity;
    private InputStream wrapperStream;

    public LazyDecompressingInputStream(InputStream inputStream, DecompressingEntity decompressingEntity) {
        this.wrappedStream = inputStream;
        this.decompressingEntity = decompressingEntity;
    }

    private void initWrapper() {
        if (this.wrapperStream == null) {
            this.wrapperStream = this.decompressingEntity.decorate(this.wrappedStream);
        }
    }

    public int read() {
        this.initWrapper();
        return this.wrapperStream.read();
    }

    public int read(byte[] byArray) {
        this.initWrapper();
        return this.wrapperStream.read(byArray);
    }

    public int read(byte[] byArray, int n2, int n3) {
        this.initWrapper();
        return this.wrapperStream.read(byArray, n2, n3);
    }

    public long skip(long l2) {
        this.initWrapper();
        return this.wrapperStream.skip(l2);
    }

    public boolean markSupported() {
        return false;
    }

    public int available() {
        this.initWrapper();
        return this.wrapperStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.wrapperStream != null) {
                this.wrapperStream.close();
            }
        }
        finally {
            this.wrappedStream.close();
        }
    }
}

