/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.config;

import java.net.InetAddress;
import java.util.Collection;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig$Builder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestConfig
implements Cloneable {
    public static final RequestConfig DEFAULT = new RequestConfig$Builder().build();
    private final boolean expectContinueEnabled;
    private final HttpHost proxy;
    private final InetAddress localAddress;
    private final boolean staleConnectionCheckEnabled;
    private final String cookieSpec;
    private final boolean redirectsEnabled;
    private final boolean relativeRedirectsAllowed;
    private final boolean circularRedirectsAllowed;
    private final int maxRedirects;
    private final boolean authenticationEnabled;
    private final Collection<String> targetPreferredAuthSchemes;
    private final Collection<String> proxyPreferredAuthSchemes;
    private final int connectionRequestTimeout;
    private final int connectTimeout;
    private final int socketTimeout;

    RequestConfig(boolean bl2, HttpHost httpHost, InetAddress inetAddress, boolean bl3, String string, boolean bl4, boolean bl5, boolean bl6, int n2, boolean bl7, Collection<String> collection, Collection<String> collection2, int n3, int n4, int n5) {
        this.expectContinueEnabled = bl2;
        this.proxy = httpHost;
        this.localAddress = inetAddress;
        this.staleConnectionCheckEnabled = bl3;
        this.cookieSpec = string;
        this.redirectsEnabled = bl4;
        this.relativeRedirectsAllowed = bl5;
        this.circularRedirectsAllowed = bl6;
        this.maxRedirects = n2;
        this.authenticationEnabled = bl7;
        this.targetPreferredAuthSchemes = collection;
        this.proxyPreferredAuthSchemes = collection2;
        this.connectionRequestTimeout = n3;
        this.connectTimeout = n4;
        this.socketTimeout = n5;
    }

    public boolean isExpectContinueEnabled() {
        return this.expectContinueEnabled;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public boolean isStaleConnectionCheckEnabled() {
        return this.staleConnectionCheckEnabled;
    }

    public String getCookieSpec() {
        return this.cookieSpec;
    }

    public boolean isRedirectsEnabled() {
        return this.redirectsEnabled;
    }

    public boolean isRelativeRedirectsAllowed() {
        return this.relativeRedirectsAllowed;
    }

    public boolean isCircularRedirectsAllowed() {
        return this.circularRedirectsAllowed;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public Collection<String> getTargetPreferredAuthSchemes() {
        return this.targetPreferredAuthSchemes;
    }

    public Collection<String> getProxyPreferredAuthSchemes() {
        return this.proxyPreferredAuthSchemes;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    protected RequestConfig clone() {
        return (RequestConfig)super.clone();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(", expectContinueEnabled=").append(this.expectContinueEnabled);
        stringBuilder.append(", proxy=").append(this.proxy);
        stringBuilder.append(", localAddress=").append(this.localAddress);
        stringBuilder.append(", staleConnectionCheckEnabled=").append(this.staleConnectionCheckEnabled);
        stringBuilder.append(", cookieSpec=").append(this.cookieSpec);
        stringBuilder.append(", redirectsEnabled=").append(this.redirectsEnabled);
        stringBuilder.append(", relativeRedirectsAllowed=").append(this.relativeRedirectsAllowed);
        stringBuilder.append(", maxRedirects=").append(this.maxRedirects);
        stringBuilder.append(", circularRedirectsAllowed=").append(this.circularRedirectsAllowed);
        stringBuilder.append(", authenticationEnabled=").append(this.authenticationEnabled);
        stringBuilder.append(", targetPreferredAuthSchemes=").append(this.targetPreferredAuthSchemes);
        stringBuilder.append(", proxyPreferredAuthSchemes=").append(this.proxyPreferredAuthSchemes);
        stringBuilder.append(", connectionRequestTimeout=").append(this.connectionRequestTimeout);
        stringBuilder.append(", connectTimeout=").append(this.connectTimeout);
        stringBuilder.append(", socketTimeout=").append(this.socketTimeout);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static RequestConfig$Builder custom() {
        return new RequestConfig$Builder();
    }

    public static RequestConfig$Builder copy(RequestConfig requestConfig) {
        return new RequestConfig$Builder().setExpectContinueEnabled(requestConfig.isExpectContinueEnabled()).setProxy(requestConfig.getProxy()).setLocalAddress(requestConfig.getLocalAddress()).setStaleConnectionCheckEnabled(requestConfig.isStaleConnectionCheckEnabled()).setCookieSpec(requestConfig.getCookieSpec()).setRedirectsEnabled(requestConfig.isRedirectsEnabled()).setRelativeRedirectsAllowed(requestConfig.isRelativeRedirectsAllowed()).setCircularRedirectsAllowed(requestConfig.isCircularRedirectsAllowed()).setMaxRedirects(requestConfig.getMaxRedirects()).setAuthenticationEnabled(requestConfig.isAuthenticationEnabled()).setTargetPreferredAuthSchemes(requestConfig.getTargetPreferredAuthSchemes()).setProxyPreferredAuthSchemes(requestConfig.getProxyPreferredAuthSchemes()).setConnectionRequestTimeout(requestConfig.getConnectionRequestTimeout()).setConnectTimeout(requestConfig.getConnectTimeout()).setSocketTimeout(requestConfig.getSocketTimeout());
    }
}

