/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeSet;
import org.apache.commons.lang3.time.FastDateParser;
import org.apache.commons.lang3.time.FastDateParser$PatternStrategy;
import org.apache.commons.lang3.time.FastDateParser$TimeZoneStrategy$TzInfo;

class FastDateParser$TimeZoneStrategy
extends FastDateParser$PatternStrategy {
    private static final String RFC_822_TIME_ZONE = "[+-]\\d{4}";
    private static final String GMT_OPTION = "GMT[+-]\\d{1,2}:\\d{2}";
    private final Locale locale;
    private final Map<String, FastDateParser$TimeZoneStrategy$TzInfo> tzNames = new HashMap<String, FastDateParser$TimeZoneStrategy$TzInfo>();
    private static final int ID = 0;

    FastDateParser$TimeZoneStrategy(Locale locale) {
        super(null);
        this.locale = locale;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("((?iu)[+-]\\d{4}|GMT[+-]\\d{1,2}:\\d{2}");
        TreeSet<String> treeSet = new TreeSet<String>(FastDateParser.access$700());
        String[][] stringArray = DateFormatSymbols.getInstance(locale).getZoneStrings();
        for (String[] stringArray2 : stringArray) {
            FastDateParser$TimeZoneStrategy$TzInfo fastDateParser$TimeZoneStrategy$TzInfo;
            String string = stringArray2[0];
            if (string.equalsIgnoreCase("GMT")) continue;
            TimeZone timeZone = TimeZone.getTimeZone(string);
            FastDateParser$TimeZoneStrategy$TzInfo fastDateParser$TimeZoneStrategy$TzInfo2 = fastDateParser$TimeZoneStrategy$TzInfo = new FastDateParser$TimeZoneStrategy$TzInfo(timeZone, false);
            for (int i2 = 1; i2 < stringArray2.length; ++i2) {
                switch (i2) {
                    case 3: {
                        fastDateParser$TimeZoneStrategy$TzInfo2 = new FastDateParser$TimeZoneStrategy$TzInfo(timeZone, true);
                        break;
                    }
                    case 5: {
                        fastDateParser$TimeZoneStrategy$TzInfo2 = fastDateParser$TimeZoneStrategy$TzInfo;
                    }
                }
                String string2 = stringArray2[i2].toLowerCase(locale);
                if (!treeSet.add(string2)) continue;
                this.tzNames.put(string2, fastDateParser$TimeZoneStrategy$TzInfo2);
            }
        }
        for (String string : treeSet) {
            FastDateParser.access$800(stringBuilder.append('|'), string);
        }
        stringBuilder.append(")");
        this.createPattern(stringBuilder);
    }

    @Override
    void setCalendar(FastDateParser fastDateParser, Calendar calendar, String string) {
        if (string.charAt(0) == '+' || string.charAt(0) == '-') {
            TimeZone timeZone = TimeZone.getTimeZone("GMT" + string);
            calendar.setTimeZone(timeZone);
        } else if (string.regionMatches(true, 0, "GMT", 0, 3)) {
            TimeZone timeZone = TimeZone.getTimeZone(string.toUpperCase());
            calendar.setTimeZone(timeZone);
        } else {
            FastDateParser$TimeZoneStrategy$TzInfo fastDateParser$TimeZoneStrategy$TzInfo = this.tzNames.get(string.toLowerCase(this.locale));
            calendar.set(16, fastDateParser$TimeZoneStrategy$TzInfo.dstOffset);
            calendar.set(15, fastDateParser$TimeZoneStrategy$TzInfo.zone.getRawOffset());
        }
    }
}

