/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrMatcher;

public class StrSubstitutor {
    public static final char DEFAULT_ESCAPE = '$';
    public static final StrMatcher DEFAULT_PREFIX = StrMatcher.stringMatcher("${");
    public static final StrMatcher DEFAULT_SUFFIX = StrMatcher.stringMatcher("}");
    public static final StrMatcher DEFAULT_VALUE_DELIMITER = StrMatcher.stringMatcher(":-");
    private char escapeChar;
    private StrMatcher prefixMatcher;
    private StrMatcher suffixMatcher;
    private StrMatcher valueDelimiterMatcher;
    private StrLookup<?> variableResolver;
    private boolean enableSubstitutionInVariables;
    private boolean preserveEscapes = false;

    public static <V> String replace(Object object, Map<String, V> map) {
        return new StrSubstitutor(map).replace(object);
    }

    public static <V> String replace(Object object, Map<String, V> map, String string, String string2) {
        return new StrSubstitutor(map, string, string2).replace(object);
    }

    public static String replace(Object object, Properties properties) {
        if (properties == null) {
            return object.toString();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            hashMap.put(string, string2);
        }
        return StrSubstitutor.replace(object, hashMap);
    }

    public static String replaceSystemProperties(Object object) {
        return new StrSubstitutor(StrLookup.systemPropertiesLookup()).replace(object);
    }

    public StrSubstitutor() {
        this((StrLookup)null, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public <V> StrSubstitutor(Map<String, V> map) {
        this(StrLookup.mapLookup(map), DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public <V> StrSubstitutor(Map<String, V> map, String string, String string2) {
        this(StrLookup.mapLookup(map), string, string2, '$');
    }

    public <V> StrSubstitutor(Map<String, V> map, String string, String string2, char c2) {
        this(StrLookup.mapLookup(map), string, string2, c2);
    }

    public <V> StrSubstitutor(Map<String, V> map, String string, String string2, char c2, String string3) {
        this(StrLookup.mapLookup(map), string, string2, c2, string3);
    }

    public StrSubstitutor(StrLookup<?> strLookup) {
        this(strLookup, DEFAULT_PREFIX, DEFAULT_SUFFIX, '$');
    }

    public StrSubstitutor(StrLookup<?> strLookup, String string, String string2, char c2) {
        this.setVariableResolver(strLookup);
        this.setVariablePrefix(string);
        this.setVariableSuffix(string2);
        this.setEscapeChar(c2);
        this.setValueDelimiterMatcher(DEFAULT_VALUE_DELIMITER);
    }

    public StrSubstitutor(StrLookup<?> strLookup, String string, String string2, char c2, String string3) {
        this.setVariableResolver(strLookup);
        this.setVariablePrefix(string);
        this.setVariableSuffix(string2);
        this.setEscapeChar(c2);
        this.setValueDelimiter(string3);
    }

    public StrSubstitutor(StrLookup<?> strLookup, StrMatcher strMatcher, StrMatcher strMatcher2, char c2) {
        this(strLookup, strMatcher, strMatcher2, c2, DEFAULT_VALUE_DELIMITER);
    }

    public StrSubstitutor(StrLookup<?> strLookup, StrMatcher strMatcher, StrMatcher strMatcher2, char c2, StrMatcher strMatcher3) {
        this.setVariableResolver(strLookup);
        this.setVariablePrefixMatcher(strMatcher);
        this.setVariableSuffixMatcher(strMatcher2);
        this.setEscapeChar(c2);
        this.setValueDelimiterMatcher(strMatcher3);
    }

    public String replace(String string) {
        if (string == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(string);
        if (!this.substitute(strBuilder, 0, string.length())) {
            return string;
        }
        return strBuilder.toString();
    }

    public String replace(String string, int n2, int n3) {
        if (string == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(string, n2, n3);
        if (!this.substitute(strBuilder, 0, n3)) {
            return string.substring(n2, n2 + n3);
        }
        return strBuilder.toString();
    }

    public String replace(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(cArray.length).append(cArray);
        this.substitute(strBuilder, 0, cArray.length);
        return strBuilder.toString();
    }

    public String replace(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(cArray, n2, n3);
        this.substitute(strBuilder, 0, n3);
        return strBuilder.toString();
    }

    public String replace(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(stringBuffer.length()).append(stringBuffer);
        this.substitute(strBuilder, 0, strBuilder.length());
        return strBuilder.toString();
    }

    public String replace(StringBuffer stringBuffer, int n2, int n3) {
        if (stringBuffer == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(stringBuffer, n2, n3);
        this.substitute(strBuilder, 0, n3);
        return strBuilder.toString();
    }

    public String replace(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        return this.replace(charSequence, 0, charSequence.length());
    }

    public String replace(CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(charSequence, n2, n3);
        this.substitute(strBuilder, 0, n3);
        return strBuilder.toString();
    }

    public String replace(StrBuilder strBuilder) {
        if (strBuilder == null) {
            return null;
        }
        StrBuilder strBuilder2 = new StrBuilder(strBuilder.length()).append(strBuilder);
        this.substitute(strBuilder2, 0, strBuilder2.length());
        return strBuilder2.toString();
    }

    public String replace(StrBuilder strBuilder, int n2, int n3) {
        if (strBuilder == null) {
            return null;
        }
        StrBuilder strBuilder2 = new StrBuilder(n3).append(strBuilder, n2, n3);
        this.substitute(strBuilder2, 0, n3);
        return strBuilder2.toString();
    }

    public String replace(Object object) {
        if (object == null) {
            return null;
        }
        StrBuilder strBuilder = new StrBuilder().append(object);
        this.substitute(strBuilder, 0, strBuilder.length());
        return strBuilder.toString();
    }

    public boolean replaceIn(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            return false;
        }
        return this.replaceIn(stringBuffer, 0, stringBuffer.length());
    }

    public boolean replaceIn(StringBuffer stringBuffer, int n2, int n3) {
        if (stringBuffer == null) {
            return false;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(stringBuffer, n2, n3);
        if (!this.substitute(strBuilder, 0, n3)) {
            return false;
        }
        stringBuffer.replace(n2, n2 + n3, strBuilder.toString());
        return true;
    }

    public boolean replaceIn(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return false;
        }
        return this.replaceIn(stringBuilder, 0, stringBuilder.length());
    }

    public boolean replaceIn(StringBuilder stringBuilder, int n2, int n3) {
        if (stringBuilder == null) {
            return false;
        }
        StrBuilder strBuilder = new StrBuilder(n3).append(stringBuilder, n2, n3);
        if (!this.substitute(strBuilder, 0, n3)) {
            return false;
        }
        stringBuilder.replace(n2, n2 + n3, strBuilder.toString());
        return true;
    }

    public boolean replaceIn(StrBuilder strBuilder) {
        if (strBuilder == null) {
            return false;
        }
        return this.substitute(strBuilder, 0, strBuilder.length());
    }

    public boolean replaceIn(StrBuilder strBuilder, int n2, int n3) {
        if (strBuilder == null) {
            return false;
        }
        return this.substitute(strBuilder, n2, n3);
    }

    protected boolean substitute(StrBuilder strBuilder, int n2, int n3) {
        return this.substitute(strBuilder, n2, n3, null) > 0;
    }

    private int substitute(StrBuilder strBuilder, int n2, int n3, List<String> list) {
        StrMatcher strMatcher = this.getVariablePrefixMatcher();
        StrMatcher strMatcher2 = this.getVariableSuffixMatcher();
        char c2 = this.getEscapeChar();
        StrMatcher strMatcher3 = this.getValueDelimiterMatcher();
        boolean bl2 = this.isEnableSubstitutionInVariables();
        boolean bl3 = list == null;
        boolean bl4 = false;
        int n4 = 0;
        char[] cArray = strBuilder.buffer;
        int n5 = n2 + n3;
        int n6 = n2;
        block0: while (n6 < n5) {
            int n7 = strMatcher.isMatch(cArray, n6, n2, n5);
            if (n7 == 0) {
                ++n6;
                continue;
            }
            if (n6 > n2 && cArray[n6 - 1] == c2) {
                if (this.preserveEscapes) {
                    ++n6;
                    continue;
                }
                strBuilder.deleteCharAt(n6 - 1);
                cArray = strBuilder.buffer;
                --n4;
                bl4 = true;
                --n5;
                continue;
            }
            int n8 = n6;
            n6 += n7;
            int n9 = 0;
            int n10 = 0;
            while (n6 < n5) {
                if (bl2 && (n9 = strMatcher.isMatch(cArray, n6, n2, n5)) != 0) {
                    ++n10;
                    n6 += n9;
                    continue;
                }
                n9 = strMatcher2.isMatch(cArray, n6, n2, n5);
                if (n9 == 0) {
                    ++n6;
                    continue;
                }
                if (n10 == 0) {
                    int n11;
                    int n12;
                    Object object;
                    String string = new String(cArray, n8 + n7, n6 - n8 - n7);
                    if (bl2) {
                        StrBuilder strBuilder2 = new StrBuilder(string);
                        this.substitute(strBuilder2, 0, strBuilder2.length());
                        string = strBuilder2.toString();
                    }
                    int n13 = n6 += n9;
                    String string2 = string;
                    String string3 = null;
                    if (strMatcher3 != null) {
                        object = string.toCharArray();
                        n12 = 0;
                        for (n11 = 0; n11 < ((char[])object).length && (bl2 || strMatcher.isMatch((char[])object, n11, n11, ((char[])object).length) == 0); ++n11) {
                            n12 = strMatcher3.isMatch((char[])object, n11);
                            if (n12 == 0) continue;
                            string2 = string.substring(0, n11);
                            string3 = string.substring(n11 + n12);
                            break;
                        }
                    }
                    if (list == null) {
                        list = new ArrayList<String>();
                        list.add(new String(cArray, n2, n3));
                    }
                    this.checkCyclicSubstitution(string2, list);
                    list.add(string2);
                    object = this.resolveVariable(string2, strBuilder, n8, n13);
                    if (object == null) {
                        object = string3;
                    }
                    if (object != null) {
                        n12 = ((String)object).length();
                        strBuilder.replace(n8, n13, (String)object);
                        bl4 = true;
                        n11 = this.substitute(strBuilder, n8, n12, list);
                        n11 = n11 + n12 - (n13 - n8);
                        n6 += n11;
                        n5 += n11;
                        n4 += n11;
                        cArray = strBuilder.buffer;
                    }
                    list.remove(list.size() - 1);
                    continue block0;
                }
                --n10;
                n6 += n9;
            }
        }
        if (bl3) {
            return bl4 ? 1 : 0;
        }
        return n4;
    }

    private void checkCyclicSubstitution(String string, List<String> list) {
        if (!list.contains(string)) {
            return;
        }
        StrBuilder strBuilder = new StrBuilder(256);
        strBuilder.append("Infinite loop in property interpolation of ");
        strBuilder.append(list.remove(0));
        strBuilder.append(": ");
        strBuilder.appendWithSeparators(list, "->");
        throw new IllegalStateException(strBuilder.toString());
    }

    protected String resolveVariable(String string, StrBuilder strBuilder, int n2, int n3) {
        StrLookup<?> strLookup = this.getVariableResolver();
        if (strLookup == null) {
            return null;
        }
        return strLookup.lookup(string);
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(char c2) {
        this.escapeChar = c2;
    }

    public StrMatcher getVariablePrefixMatcher() {
        return this.prefixMatcher;
    }

    public StrSubstitutor setVariablePrefixMatcher(StrMatcher strMatcher) {
        if (strMatcher == null) {
            throw new IllegalArgumentException("Variable prefix matcher must not be null!");
        }
        this.prefixMatcher = strMatcher;
        return this;
    }

    public StrSubstitutor setVariablePrefix(char c2) {
        return this.setVariablePrefixMatcher(StrMatcher.charMatcher(c2));
    }

    public StrSubstitutor setVariablePrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Variable prefix must not be null!");
        }
        return this.setVariablePrefixMatcher(StrMatcher.stringMatcher(string));
    }

    public StrMatcher getVariableSuffixMatcher() {
        return this.suffixMatcher;
    }

    public StrSubstitutor setVariableSuffixMatcher(StrMatcher strMatcher) {
        if (strMatcher == null) {
            throw new IllegalArgumentException("Variable suffix matcher must not be null!");
        }
        this.suffixMatcher = strMatcher;
        return this;
    }

    public StrSubstitutor setVariableSuffix(char c2) {
        return this.setVariableSuffixMatcher(StrMatcher.charMatcher(c2));
    }

    public StrSubstitutor setVariableSuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Variable suffix must not be null!");
        }
        return this.setVariableSuffixMatcher(StrMatcher.stringMatcher(string));
    }

    public StrMatcher getValueDelimiterMatcher() {
        return this.valueDelimiterMatcher;
    }

    public StrSubstitutor setValueDelimiterMatcher(StrMatcher strMatcher) {
        this.valueDelimiterMatcher = strMatcher;
        return this;
    }

    public StrSubstitutor setValueDelimiter(char c2) {
        return this.setValueDelimiterMatcher(StrMatcher.charMatcher(c2));
    }

    public StrSubstitutor setValueDelimiter(String string) {
        if (StringUtils.isEmpty(string)) {
            this.setValueDelimiterMatcher(null);
            return this;
        }
        return this.setValueDelimiterMatcher(StrMatcher.stringMatcher(string));
    }

    public StrLookup<?> getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(StrLookup<?> strLookup) {
        this.variableResolver = strLookup;
    }

    public boolean isEnableSubstitutionInVariables() {
        return this.enableSubstitutionInVariables;
    }

    public void setEnableSubstitutionInVariables(boolean bl2) {
        this.enableSubstitutionInVariables = bl2;
    }

    public boolean isPreserveEscapes() {
        return this.preserveEscapes;
    }

    public void setPreserveEscapes(boolean bl2) {
        this.preserveEscapes = bl2;
    }
}

