/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.lang3.concurrent.BackgroundInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;

public class MultiBackgroundInitializer$MultiBackgroundInitializerResults {
    private final Map<String, BackgroundInitializer<?>> initializers;
    private final Map<String, Object> resultObjects;
    private final Map<String, ConcurrentException> exceptions;

    private MultiBackgroundInitializer$MultiBackgroundInitializerResults(Map<String, BackgroundInitializer<?>> map, Map<String, Object> map2, Map<String, ConcurrentException> map3) {
        this.initializers = map;
        this.resultObjects = map2;
        this.exceptions = map3;
    }

    public BackgroundInitializer<?> getInitializer(String string) {
        return this.checkName(string);
    }

    public Object getResultObject(String string) {
        this.checkName(string);
        return this.resultObjects.get(string);
    }

    public boolean isException(String string) {
        this.checkName(string);
        return this.exceptions.containsKey(string);
    }

    public ConcurrentException getException(String string) {
        this.checkName(string);
        return this.exceptions.get(string);
    }

    public Set<String> initializerNames() {
        return Collections.unmodifiableSet(this.initializers.keySet());
    }

    public boolean isSuccessful() {
        return this.exceptions.isEmpty();
    }

    private BackgroundInitializer<?> checkName(String string) {
        BackgroundInitializer<?> backgroundInitializer = this.initializers.get(string);
        if (backgroundInitializer == null) {
            throw new NoSuchElementException("No child initializer with name " + string);
        }
        return backgroundInitializer;
    }
}

