/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.ThreadUtils$AlwaysTruePredicate;
import org.apache.commons.lang3.ThreadUtils$NamePredicate;
import org.apache.commons.lang3.ThreadUtils$ThreadGroupPredicate;
import org.apache.commons.lang3.ThreadUtils$ThreadIdPredicate;
import org.apache.commons.lang3.ThreadUtils$ThreadPredicate;

public class ThreadUtils {
    public static final ThreadUtils$AlwaysTruePredicate ALWAYS_TRUE_PREDICATE = new ThreadUtils$AlwaysTruePredicate(null);

    public static Thread findThreadById(long l2, ThreadGroup threadGroup) {
        if (threadGroup == null) {
            throw new IllegalArgumentException("The thread group must not be null");
        }
        Thread thread = ThreadUtils.findThreadById(l2);
        if (thread != null && threadGroup.equals(thread.getThreadGroup())) {
            return thread;
        }
        return null;
    }

    public static Thread findThreadById(long l2, String string) {
        if (string == null) {
            throw new IllegalArgumentException("The thread group name must not be null");
        }
        Thread thread = ThreadUtils.findThreadById(l2);
        if (thread != null && thread.getThreadGroup() != null && thread.getThreadGroup().getName().equals(string)) {
            return thread;
        }
        return null;
    }

    public static Collection<Thread> findThreadsByName(String string, ThreadGroup threadGroup) {
        return ThreadUtils.findThreads(threadGroup, false, new ThreadUtils$NamePredicate(string));
    }

    public static Collection<Thread> findThreadsByName(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("The thread name must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The thread group name must not be null");
        }
        Collection<ThreadGroup> collection = ThreadUtils.findThreadGroups(new ThreadUtils$NamePredicate(string2));
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        ThreadUtils$NamePredicate threadUtils$NamePredicate = new ThreadUtils$NamePredicate(string);
        for (ThreadGroup threadGroup : collection) {
            arrayList.addAll(ThreadUtils.findThreads(threadGroup, false, threadUtils$NamePredicate));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static Collection<ThreadGroup> findThreadGroupsByName(String string) {
        return ThreadUtils.findThreadGroups(new ThreadUtils$NamePredicate(string));
    }

    public static Collection<ThreadGroup> getAllThreadGroups() {
        return ThreadUtils.findThreadGroups(ALWAYS_TRUE_PREDICATE);
    }

    public static ThreadGroup getSystemThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    public static Collection<Thread> getAllThreads() {
        return ThreadUtils.findThreads(ALWAYS_TRUE_PREDICATE);
    }

    public static Collection<Thread> findThreadsByName(String string) {
        return ThreadUtils.findThreads(new ThreadUtils$NamePredicate(string));
    }

    public static Thread findThreadById(long l2) {
        Collection<Thread> collection = ThreadUtils.findThreads(new ThreadUtils$ThreadIdPredicate(l2));
        return collection.isEmpty() ? null : collection.iterator().next();
    }

    public static Collection<Thread> findThreads(ThreadUtils$ThreadPredicate threadUtils$ThreadPredicate) {
        return ThreadUtils.findThreads(ThreadUtils.getSystemThreadGroup(), true, threadUtils$ThreadPredicate);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadUtils$ThreadGroupPredicate threadUtils$ThreadGroupPredicate) {
        return ThreadUtils.findThreadGroups(ThreadUtils.getSystemThreadGroup(), true, threadUtils$ThreadGroupPredicate);
    }

    public static Collection<Thread> findThreads(ThreadGroup threadGroup, boolean bl2, ThreadUtils$ThreadPredicate threadUtils$ThreadPredicate) {
        Thread[] threadArray;
        if (threadGroup == null) {
            throw new IllegalArgumentException("The group must not be null");
        }
        if (threadUtils$ThreadPredicate == null) {
            throw new IllegalArgumentException("The predicate must not be null");
        }
        int n2 = threadGroup.activeCount();
        while ((n2 = threadGroup.enumerate(threadArray = new Thread[n2 + n2 / 2 + 1], bl2)) >= threadArray.length) {
        }
        ArrayList<Thread> arrayList = new ArrayList<Thread>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!threadUtils$ThreadPredicate.test(threadArray[i2])) continue;
            arrayList.add(threadArray[i2]);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public static Collection<ThreadGroup> findThreadGroups(ThreadGroup threadGroup, boolean bl2, ThreadUtils$ThreadGroupPredicate threadUtils$ThreadGroupPredicate) {
        ThreadGroup[] threadGroupArray;
        if (threadGroup == null) {
            throw new IllegalArgumentException("The group must not be null");
        }
        if (threadUtils$ThreadGroupPredicate == null) {
            throw new IllegalArgumentException("The predicate must not be null");
        }
        int n2 = threadGroup.activeGroupCount();
        while ((n2 = threadGroup.enumerate(threadGroupArray = new ThreadGroup[n2 + n2 / 2 + 1], bl2)) >= threadGroupArray.length) {
        }
        ArrayList<ThreadGroup> arrayList = new ArrayList<ThreadGroup>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!threadUtils$ThreadGroupPredicate.test(threadGroupArray[i2])) continue;
            arrayList.add(threadGroupArray[i2]);
        }
        return Collections.unmodifiableCollection(arrayList);
    }
}

