/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils$ClassLoaderAwareObjectInputStream;

public class SerializationUtils {
    public static <T extends Serializable> T clone(T t2) {
        if (t2 == null) {
            return null;
        }
        byte[] byArray = SerializationUtils.serialize(t2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = null;
        try {
            Serializable serializable;
            objectInputStream = new SerializationUtils$ClassLoaderAwareObjectInputStream(byteArrayInputStream, t2.getClass().getClassLoader());
            Serializable serializable2 = serializable = (Serializable)objectInputStream.readObject();
            return (T)serializable2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerializationException("ClassNotFoundException while reading cloned object data", classNotFoundException);
        }
        catch (IOException iOException) {
            throw new SerializationException("IOException while reading cloned object data", iOException);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new SerializationException("IOException on closing cloned object data InputStream.", iOException);
            }
        }
    }

    public static <T extends Serializable> T roundtrip(T t2) {
        return (T)((Serializable)SerializationUtils.deserialize(SerializationUtils.serialize(t2)));
    }

    public static void serialize(Serializable serializable, OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] serialize(Serializable serializable) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        SerializationUtils.serialize(serializable, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static <T> T deserialize(InputStream inputStream) {
        Object object;
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        ObjectInputStream objectInputStream = null;
        try {
            Object object2;
            objectInputStream = new ObjectInputStream(inputStream);
            object = object2 = objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerializationException(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return (T)object;
    }

    public static <T> T deserialize(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        return SerializationUtils.deserialize(new ByteArrayInputStream(byArray));
    }
}

