/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.FilterOutputStream;
import java.io.OutputStream;

public class ChunkedOutputStream
extends FilterOutputStream {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private final int chunkSize;

    public ChunkedOutputStream(OutputStream outputStream, int n2) {
        super(outputStream);
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.chunkSize = n2;
    }

    public ChunkedOutputStream(OutputStream outputStream) {
        this(outputStream, 4096);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        int n4 = n3;
        int n5 = n2;
        while (n4 > 0) {
            int n6 = Math.min(n4, this.chunkSize);
            this.out.write(byArray, n5, n6);
            n4 -= n6;
            n5 += n6;
        }
    }
}

