/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ProxyInputStream
extends FilterInputStream {
    public ProxyInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int read() {
        try {
            this.beforeRead(1);
            int n2 = this.in.read();
            this.afterRead(n2 != -1 ? 1 : -1);
            return n2;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(byte[] byArray) {
        try {
            this.beforeRead(byArray != null ? byArray.length : 0);
            int n2 = this.in.read(byArray);
            this.afterRead(n2);
            return n2;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        try {
            this.beforeRead(n3);
            int n4 = this.in.read(byArray, n2, n3);
            this.afterRead(n4);
            return n4;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public long skip(long l2) {
        try {
            return this.in.skip(l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return 0L;
        }
    }

    @Override
    public int available() {
        try {
            return super.available();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return 0;
        }
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public synchronized void mark(int n2) {
        this.in.mark(n2);
    }

    @Override
    public synchronized void reset() {
        try {
            this.in.reset();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    protected void beforeRead(int n2) {
    }

    protected void afterRead(int n2) {
    }

    protected void handleIOException(IOException iOException) {
        throw iOException;
    }
}

