/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;

    public ClassLoaderObjectInputStream(ClassLoader classLoader, InputStream inputStream) {
        super(inputStream);
        this.classLoader = classLoader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) {
        try {
            return Class.forName(objectStreamClass.getName(), false, this.classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return super.resolveClass(objectStreamClass);
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] stringArray) {
        Class[] classArray = new Class[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            classArray[i2] = Class.forName(stringArray[i2], false, this.classLoader);
        }
        try {
            return Proxy.getProxyClass(this.classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.resolveProxyClass(stringArray);
        }
    }
}

