/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class AgeFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -2132740084016138541L;
    private final long cutoff;
    private final boolean acceptOlder;

    public AgeFileFilter(long l2) {
        this(l2, true);
    }

    public AgeFileFilter(long l2, boolean bl2) {
        this.acceptOlder = bl2;
        this.cutoff = l2;
    }

    public AgeFileFilter(Date date) {
        this(date, true);
    }

    public AgeFileFilter(Date date, boolean bl2) {
        this(date.getTime(), bl2);
    }

    public AgeFileFilter(File file) {
        this(file, true);
    }

    public AgeFileFilter(File file, boolean bl2) {
        this(file.lastModified(), bl2);
    }

    @Override
    public boolean accept(File file) {
        boolean bl2 = FileUtils.isFileNewer(file, this.cutoff);
        return this.acceptOlder ? !bl2 : bl2;
    }

    @Override
    public String toString() {
        String string = this.acceptOlder ? "<=" : ">";
        return super.toString() + "(" + string + this.cutoff + ")";
    }
}

