/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.Serializable;
import org.apache.commons.io.FilenameUtils;

public enum IOCase implements Serializable
{
    SENSITIVE("Sensitive", true),
    INSENSITIVE("Insensitive", false),
    SYSTEM("System", !FilenameUtils.isSystemWindows());

    private static final long serialVersionUID = -6343169151696340687L;
    private final String name;
    private final transient boolean sensitive;

    public static IOCase forName(String string) {
        for (IOCase iOCase : IOCase.values()) {
            if (!iOCase.getName().equals(string)) continue;
            return iOCase;
        }
        throw new IllegalArgumentException("Invalid IOCase name: " + string);
    }

    private IOCase(String string2, boolean bl2) {
        this.name = string2;
        this.sensitive = bl2;
    }

    private Object readResolve() {
        return IOCase.forName(this.name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isCaseSensitive() {
        return this.sensitive;
    }

    public int checkCompareTo(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("The strings must not be null");
        }
        return this.sensitive ? string.compareTo(string2) : string.compareToIgnoreCase(string2);
    }

    public boolean checkEquals(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("The strings must not be null");
        }
        return this.sensitive ? string.equals(string2) : string.equalsIgnoreCase(string2);
    }

    public boolean checkStartsWith(String string, String string2) {
        return string.regionMatches(!this.sensitive, 0, string2, 0, string2.length());
    }

    public boolean checkEndsWith(String string, String string2) {
        int n2 = string2.length();
        return string.regionMatches(!this.sensitive, string.length() - n2, string2, 0, n2);
    }

    public int checkIndexOf(String string, int n2, String string2) {
        int n3 = string.length() - string2.length();
        if (n3 >= n2) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                if (!this.checkRegionMatches(string, i2, string2)) continue;
                return i2;
            }
        }
        return -1;
    }

    public boolean checkRegionMatches(String string, int n2, String string2) {
        return string.regionMatches(!this.sensitive, n2, string2, 0, string2.length());
    }

    public String toString() {
        return this.name;
    }
}

