/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.OutputStream;
import java.nio.charset.Charset;

public class HexDump {
    public static final String EOL = System.getProperty("line.separator");
    private static final char[] _hexcodes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] _shifts = new int[]{28, 24, 20, 16, 12, 8, 4, 0};

    public static void dump(byte[] byArray, long l2, OutputStream outputStream, int n2) {
        if (n2 < 0 || n2 >= byArray.length) {
            throw new ArrayIndexOutOfBoundsException("illegal index: " + n2 + " into array of length " + byArray.length);
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("cannot write to nullstream");
        }
        long l3 = l2 + (long)n2;
        StringBuilder stringBuilder = new StringBuilder(74);
        for (int i2 = n2; i2 < byArray.length; i2 += 16) {
            int n3;
            int n4 = byArray.length - i2;
            if (n4 > 16) {
                n4 = 16;
            }
            HexDump.dump(stringBuilder, l3).append(' ');
            for (n3 = 0; n3 < 16; ++n3) {
                if (n3 < n4) {
                    HexDump.dump(stringBuilder, byArray[n3 + i2]);
                } else {
                    stringBuilder.append("  ");
                }
                stringBuilder.append(' ');
            }
            for (n3 = 0; n3 < n4; ++n3) {
                if (byArray[n3 + i2] >= 32 && byArray[n3 + i2] < 127) {
                    stringBuilder.append((char)byArray[n3 + i2]);
                    continue;
                }
                stringBuilder.append('.');
            }
            stringBuilder.append(EOL);
            outputStream.write(stringBuilder.toString().getBytes(Charset.defaultCharset()));
            outputStream.flush();
            stringBuilder.setLength(0);
            l3 += (long)n4;
        }
    }

    private static StringBuilder dump(StringBuilder stringBuilder, long l2) {
        for (int i2 = 0; i2 < 8; ++i2) {
            stringBuilder.append(_hexcodes[(int)(l2 >> _shifts[i2]) & 0xF]);
        }
        return stringBuilder;
    }

    private static StringBuilder dump(StringBuilder stringBuilder, byte by2) {
        for (int i2 = 0; i2 < 2; ++i2) {
            stringBuilder.append(_hexcodes[by2 >> _shifts[i2 + 6] & 0xF]);
        }
        return stringBuilder;
    }
}

