/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtils {
    private static final int COPY_BUF_SIZE = 8024;
    private static final int SKIP_BUF_SIZE = 4096;
    private static final byte[] SKIP_BUF = new byte[4096];

    private IOUtils() {
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) {
        return IOUtils.copy(inputStream, outputStream, 8024);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int n2) {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        long l2 = 0L;
        while (-1 != (n3 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n3);
            l2 += (long)n3;
        }
        return l2;
    }

    public static long skip(InputStream inputStream, long l2) {
        int n2;
        long l3;
        long l4 = l2;
        while (l2 > 0L && (l3 = inputStream.skip(l2)) != 0L) {
            l2 -= l3;
        }
        while (l2 > 0L && (n2 = IOUtils.readFully(inputStream, SKIP_BUF, 0, (int)Math.min(l2, 4096L))) >= 1) {
            l2 -= (long)n2;
        }
        return l4 - l2;
    }

    public static int readFully(InputStream inputStream, byte[] byArray) {
        return IOUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static int readFully(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4;
        if (n3 < 0 || n2 < 0 || n3 + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n5 = 0;
        for (n4 = 0; n4 != n3 && (n5 = inputStream.read(byArray, n2 + n4, n3 - n4)) != -1; n4 += n5) {
        }
        return n4;
    }

    public static byte[] toByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

