/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.FilterOutputStream;
import java.io.OutputStream;

public class CountingOutputStream
extends FilterOutputStream {
    private long bytesWritten = 0L;

    public CountingOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n2) {
        this.out.write(n2);
        this.count(1L);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.out.write(byArray, n2, n3);
        this.count(n3);
    }

    protected void count(long l2) {
        if (l2 != -1L) {
            this.bytesWritten += l2;
        }
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }
}

