/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.FilterInputStream;
import java.io.InputStream;

public class CountingInputStream
extends FilterInputStream {
    private long bytesRead;

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() {
        int n2 = this.in.read();
        if (n2 >= 0) {
            this.count(1L);
        }
        return n2;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.in.read(byArray, n2, n3);
        if (n4 >= 0) {
            this.count(n4);
        }
        return n4;
    }

    protected final void count(long l2) {
        if (l2 != -1L) {
            this.bytesRead += l2;
        }
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

