/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class ChecksumVerifyingInputStream
extends InputStream {
    private final InputStream in;
    private long bytesRemaining;
    private final long expectedChecksum;
    private final Checksum checksum;

    public ChecksumVerifyingInputStream(Checksum checksum, InputStream inputStream, long l2, long l3) {
        this.checksum = checksum;
        this.in = inputStream;
        this.expectedChecksum = l3;
        this.bytesRemaining = l2;
    }

    public int read() {
        if (this.bytesRemaining <= 0L) {
            return -1;
        }
        int n2 = this.in.read();
        if (n2 >= 0) {
            this.checksum.update(n2);
            --this.bytesRemaining;
        }
        if (this.bytesRemaining == 0L && this.expectedChecksum != this.checksum.getValue()) {
            throw new IOException("Checksum verification failed");
        }
        return n2;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.in.read(byArray, n2, n3);
        if (n4 >= 0) {
            this.checksum.update(byArray, n2, n4);
            this.bytesRemaining -= (long)n4;
        }
        if (this.bytesRemaining <= 0L && this.expectedChecksum != this.checksum.getValue()) {
            throw new IOException("Checksum verification failed");
        }
        return n4;
    }

    public long skip(long l2) {
        if (this.read() >= 0) {
            return 1L;
        }
        return 0L;
    }

    public void close() {
        this.in.close();
    }
}

