/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.z._internal_;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;

public abstract class InternalLZWInputStream
extends CompressorInputStream {
    private final byte[] oneByte = new byte[1];
    protected final InputStream in;
    protected int clearCode = -1;
    protected int codeSize = 9;
    protected int bitsCached = 0;
    protected int bitsCachedSize = 0;
    protected int previousCode = -1;
    protected int tableSize = 0;
    protected int[] prefixes;
    protected byte[] characters;
    private byte[] outputStack;
    private int outputStackLocation;

    protected InternalLZWInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void close() {
        this.in.close();
    }

    public int read() {
        int n2 = this.read(this.oneByte);
        if (n2 < 0) {
            return n2;
        }
        return 0xFF & this.oneByte[0];
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.readFromStack(byArray, n2, n3);
        while (n3 - n4 > 0) {
            int n5 = this.decompressNextSymbol();
            if (n5 < 0) {
                if (n4 > 0) {
                    this.count(n4);
                    return n4;
                }
                return n5;
            }
            n4 += this.readFromStack(byArray, n2 + n4, n3 - n4);
        }
        this.count(n4);
        return n4;
    }

    protected abstract int decompressNextSymbol();

    protected abstract int addEntry(int var1, byte var2);

    protected void setClearCode(int n2) {
        this.clearCode = 1 << n2 - 1;
    }

    protected void initializeTables(int n2) {
        int n3 = 1 << n2;
        this.prefixes = new int[n3];
        this.characters = new byte[n3];
        this.outputStack = new byte[n3];
        this.outputStackLocation = n3;
        int n4 = 256;
        for (int i2 = 0; i2 < 256; ++i2) {
            this.prefixes[i2] = -1;
            this.characters[i2] = (byte)i2;
        }
    }

    protected int readNextCode() {
        int n2;
        while (this.bitsCachedSize < this.codeSize) {
            n2 = this.in.read();
            if (n2 < 0) {
                return n2;
            }
            this.bitsCached |= n2 << this.bitsCachedSize;
            this.bitsCachedSize += 8;
        }
        n2 = (1 << this.codeSize) - 1;
        int n3 = this.bitsCached & n2;
        this.bitsCached >>>= this.codeSize;
        this.bitsCachedSize -= this.codeSize;
        return n3;
    }

    protected int addEntry(int n2, byte by2, int n3) {
        if (this.tableSize < n3) {
            int n4 = this.tableSize;
            this.prefixes[this.tableSize] = n2;
            this.characters[this.tableSize] = by2;
            ++this.tableSize;
            return n4;
        }
        return -1;
    }

    protected int addRepeatOfPreviousCode() {
        if (this.previousCode == -1) {
            throw new IOException("The first code can't be a reference to its preceding code");
        }
        byte by2 = 0;
        int n2 = this.previousCode;
        while (n2 >= 0) {
            by2 = this.characters[n2];
            n2 = this.prefixes[n2];
        }
        return this.addEntry(this.previousCode, by2);
    }

    protected int expandCodeToOutputStack(int n2, boolean bl2) {
        int n3 = n2;
        while (n3 >= 0) {
            this.outputStack[--this.outputStackLocation] = this.characters[n3];
            n3 = this.prefixes[n3];
        }
        if (this.previousCode != -1 && !bl2) {
            this.addEntry(this.previousCode, this.outputStack[this.outputStackLocation]);
        }
        this.previousCode = n2;
        return this.outputStackLocation;
    }

    private int readFromStack(byte[] byArray, int n2, int n3) {
        int n4 = this.outputStack.length - this.outputStackLocation;
        if (n4 > 0) {
            int n5 = Math.min(n4, n3);
            System.arraycopy(this.outputStack, this.outputStackLocation, byArray, n2, n5);
            this.outputStackLocation += n5;
            return n5;
        }
        return 0;
    }
}

