/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.z;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.z._internal_.InternalLZWInputStream;

public class ZCompressorInputStream
extends InternalLZWInputStream {
    private static final int MAGIC_1 = 31;
    private static final int MAGIC_2 = 157;
    private static final int BLOCK_MODE_MASK = 128;
    private static final int MAX_CODE_SIZE_MASK = 31;
    private final boolean blockMode;
    private final int maxCodeSize;
    private long totalCodesRead = 0L;

    public ZCompressorInputStream(InputStream inputStream) {
        super(inputStream);
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (n2 != 31 || n3 != 157 || n4 < 0) {
            throw new IOException("Input is not in .Z format");
        }
        this.blockMode = (n4 & 0x80) != 0;
        this.maxCodeSize = n4 & 0x1F;
        if (this.blockMode) {
            this.setClearCode(this.codeSize);
        }
        this.initializeTables(this.maxCodeSize);
        this.clearEntries();
    }

    private void clearEntries() {
        this.tableSize = 256;
        if (this.blockMode) {
            ++this.tableSize;
        }
    }

    protected int readNextCode() {
        int n2 = super.readNextCode();
        if (n2 >= 0) {
            ++this.totalCodesRead;
        }
        return n2;
    }

    private void reAlignReading() {
        long l2 = 8L - this.totalCodesRead % 8L;
        if (l2 == 8L) {
            l2 = 0L;
        }
        for (long i2 = 0L; i2 < l2; ++i2) {
            this.readNextCode();
        }
        this.bitsCached = 0;
        this.bitsCachedSize = 0;
    }

    protected int addEntry(int n2, byte by2) {
        int n3 = 1 << this.codeSize;
        int n4 = this.addEntry(n2, by2, n3);
        if (this.tableSize == n3 && this.codeSize < this.maxCodeSize) {
            this.reAlignReading();
            ++this.codeSize;
        }
        return n4;
    }

    protected int decompressNextSymbol() {
        int n2 = this.readNextCode();
        if (n2 < 0) {
            return -1;
        }
        if (this.blockMode && n2 == this.clearCode) {
            this.clearEntries();
            this.reAlignReading();
            this.codeSize = 9;
            this.previousCode = -1;
            return 0;
        }
        boolean bl2 = false;
        if (n2 == this.tableSize) {
            this.addRepeatOfPreviousCode();
            bl2 = true;
        } else if (n2 > this.tableSize) {
            throw new IOException(String.format("Invalid %d bit code 0x%x", this.codeSize, n2));
        }
        return this.expandCodeToOutputStack(n2, bl2);
    }

    public static boolean matches(byte[] byArray, int n2) {
        return n2 > 3 && byArray[0] == 31 && byArray[1] == -99;
    }
}

