/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.xz;

import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.tukaani.xz.SingleXZInputStream;
import org.tukaani.xz.XZ;
import org.tukaani.xz.XZInputStream;

public class XZCompressorInputStream
extends CompressorInputStream {
    private final InputStream in;

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < XZ.HEADER_MAGIC.length) {
            return false;
        }
        for (int i2 = 0; i2 < XZ.HEADER_MAGIC.length; ++i2) {
            if (byArray[i2] == XZ.HEADER_MAGIC[i2]) continue;
            return false;
        }
        return true;
    }

    public XZCompressorInputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public XZCompressorInputStream(InputStream inputStream, boolean bl2) {
        this.in = bl2 ? new XZInputStream(inputStream) : new SingleXZInputStream(inputStream);
    }

    public int read() {
        int n2 = this.in.read();
        this.count(n2 == -1 ? -1 : 1);
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.in.read(byArray, n2, n3);
        this.count(n4);
        return n4;
    }

    public long skip(long l2) {
        return this.in.skip(l2);
    }

    public int available() {
        return this.in.available();
    }

    public void close() {
        this.in.close();
    }
}

