/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.snappy;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class SnappyCompressorInputStream
extends CompressorInputStream {
    private static final int TAG_MASK = 3;
    public static final int DEFAULT_BLOCK_SIZE = 32768;
    private final byte[] decompressBuf;
    private int writeIndex;
    private int readIndex;
    private final int blockSize;
    private final InputStream in;
    private final int size;
    private int uncompressedBytesRemaining;
    private final byte[] oneByte = new byte[1];
    private boolean endReached = false;

    public SnappyCompressorInputStream(InputStream inputStream) {
        this(inputStream, 32768);
    }

    public SnappyCompressorInputStream(InputStream inputStream, int n2) {
        this.in = inputStream;
        this.blockSize = n2;
        this.decompressBuf = new byte[n2 * 3];
        this.readIndex = 0;
        this.writeIndex = 0;
        this.uncompressedBytesRemaining = this.size = (int)this.readSize();
    }

    public int read() {
        return this.read(this.oneByte, 0, 1) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    public void close() {
        this.in.close();
    }

    public int available() {
        return this.writeIndex - this.readIndex;
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (this.endReached) {
            return -1;
        }
        int n4 = this.available();
        if (n3 > n4) {
            this.fill(n3 - n4);
        }
        int n5 = Math.min(n3, this.available());
        System.arraycopy(this.decompressBuf, this.readIndex, byArray, n2, n5);
        this.readIndex += n5;
        if (this.readIndex > this.blockSize) {
            this.slideBuffer();
        }
        return n5;
    }

    private void fill(int n2) {
        if (this.uncompressedBytesRemaining == 0) {
            this.endReached = true;
        }
        int n3 = Math.min(n2, this.uncompressedBytesRemaining);
        while (n3 > 0) {
            int n4 = this.readOneByte();
            int n5 = 0;
            long l2 = 0L;
            switch (n4 & 3) {
                case 0: {
                    n5 = this.readLiteralLength(n4);
                    if (!this.expandLiteral(n5)) break;
                    return;
                }
                case 1: {
                    n5 = 4 + (n4 >> 2 & 7);
                    l2 = (n4 & 0xE0) << 3;
                    if (!this.expandCopy(l2 |= (long)this.readOneByte(), n5)) break;
                    return;
                }
                case 2: {
                    n5 = (n4 >> 2) + 1;
                    l2 = this.readOneByte();
                    if (!this.expandCopy(l2 |= (long)(this.readOneByte() << 8), n5)) break;
                    return;
                }
                case 3: {
                    n5 = (n4 >> 2) + 1;
                    l2 = this.readOneByte();
                    l2 |= (long)(this.readOneByte() << 8);
                    l2 |= (long)(this.readOneByte() << 16);
                    if (!this.expandCopy(l2 |= (long)this.readOneByte() << 24, n5)) break;
                    return;
                }
            }
            n3 -= n5;
            this.uncompressedBytesRemaining -= n5;
        }
    }

    private void slideBuffer() {
        System.arraycopy(this.decompressBuf, this.blockSize, this.decompressBuf, 0, this.blockSize * 2);
        this.writeIndex -= this.blockSize;
        this.readIndex -= this.blockSize;
    }

    private int readLiteralLength(int n2) {
        int n3;
        switch (n2 >> 2) {
            case 60: {
                n3 = this.readOneByte();
                break;
            }
            case 61: {
                n3 = this.readOneByte();
                n3 |= this.readOneByte() << 8;
                break;
            }
            case 62: {
                n3 = this.readOneByte();
                n3 |= this.readOneByte() << 8;
                n3 |= this.readOneByte() << 16;
                break;
            }
            case 63: {
                n3 = this.readOneByte();
                n3 |= this.readOneByte() << 8;
                n3 |= this.readOneByte() << 16;
                n3 = (int)((long)n3 | (long)this.readOneByte() << 24);
                break;
            }
            default: {
                n3 = n2 >> 2;
            }
        }
        return n3 + 1;
    }

    private boolean expandLiteral(int n2) {
        int n3 = IOUtils.readFully(this.in, this.decompressBuf, this.writeIndex, n2);
        this.count(n3);
        if (n2 != n3) {
            throw new IOException("Premature end of stream");
        }
        this.writeIndex += n2;
        return this.writeIndex >= 2 * this.blockSize;
    }

    private boolean expandCopy(long l2, int n2) {
        if (l2 > (long)this.blockSize) {
            throw new IOException("Offset is larger than block size");
        }
        int n3 = (int)l2;
        if (n3 == 1) {
            byte by2 = this.decompressBuf[this.writeIndex - 1];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.decompressBuf[this.writeIndex++] = by2;
            }
        } else if (n2 < n3) {
            System.arraycopy(this.decompressBuf, this.writeIndex - n3, this.decompressBuf, this.writeIndex, n2);
            this.writeIndex += n2;
        } else {
            int n4 = n2 / n3;
            int n5 = n2 - n3 * n4;
            while (n4-- != 0) {
                System.arraycopy(this.decompressBuf, this.writeIndex - n3, this.decompressBuf, this.writeIndex, n3);
                this.writeIndex += n3;
            }
            if (n5 > 0) {
                System.arraycopy(this.decompressBuf, this.writeIndex - n3, this.decompressBuf, this.writeIndex, n5);
                this.writeIndex += n5;
            }
        }
        return this.writeIndex >= 2 * this.blockSize;
    }

    private int readOneByte() {
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new IOException("Premature end of stream");
        }
        this.count(1);
        return n2 & 0xFF;
    }

    private long readSize() {
        int n2 = 0;
        long l2 = 0L;
        int n3 = 0;
        do {
            n3 = this.readOneByte();
            l2 |= (long)((n3 & 0x7F) << n2++ * 7);
        } while (0 != (n3 & 0x80));
        return l2;
    }

    public int getSize() {
        return this.size;
    }
}

