/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.snappy;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.snappy.PureJavaCrc32C;
import org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import org.apache.commons.compress.utils.BoundedInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class FramedSnappyCompressorInputStream
extends CompressorInputStream {
    static final long MASK_OFFSET = 2726488792L;
    private static final int STREAM_IDENTIFIER_TYPE = 255;
    private static final int COMPRESSED_CHUNK_TYPE = 0;
    private static final int UNCOMPRESSED_CHUNK_TYPE = 1;
    private static final int PADDING_CHUNK_TYPE = 254;
    private static final int MIN_UNSKIPPABLE_TYPE = 2;
    private static final int MAX_UNSKIPPABLE_TYPE = 127;
    private static final int MAX_SKIPPABLE_TYPE = 253;
    private static final byte[] SZ_SIGNATURE = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89};
    private final PushbackInputStream in;
    private SnappyCompressorInputStream currentCompressedChunk;
    private final byte[] oneByte = new byte[1];
    private boolean endReached;
    private boolean inUncompressedChunk;
    private int uncompressedBytesRemaining;
    private long expectedChecksum = -1L;
    private final PureJavaCrc32C checksum = new PureJavaCrc32C();

    public FramedSnappyCompressorInputStream(InputStream inputStream) {
        this.in = new PushbackInputStream(inputStream, 1);
        this.readStreamIdentifier();
    }

    public int read() {
        return this.read(this.oneByte, 0, 1) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    public void close() {
        if (this.currentCompressedChunk != null) {
            this.currentCompressedChunk.close();
            this.currentCompressedChunk = null;
        }
        this.in.close();
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4 = this.readOnce(byArray, n2, n3);
        if (n4 == -1) {
            this.readNextBlock();
            if (this.endReached) {
                return -1;
            }
            n4 = this.readOnce(byArray, n2, n3);
        }
        return n4;
    }

    public int available() {
        if (this.inUncompressedChunk) {
            return Math.min(this.uncompressedBytesRemaining, this.in.available());
        }
        if (this.currentCompressedChunk != null) {
            return this.currentCompressedChunk.available();
        }
        return 0;
    }

    private int readOnce(byte[] byArray, int n2, int n3) {
        int n4 = -1;
        if (this.inUncompressedChunk) {
            int n5 = Math.min(this.uncompressedBytesRemaining, n3);
            if (n5 == 0) {
                return -1;
            }
            n4 = this.in.read(byArray, n2, n5);
            if (n4 != -1) {
                this.uncompressedBytesRemaining -= n4;
                this.count(n4);
            }
        } else if (this.currentCompressedChunk != null) {
            long l2 = this.currentCompressedChunk.getBytesRead();
            n4 = this.currentCompressedChunk.read(byArray, n2, n3);
            if (n4 == -1) {
                this.currentCompressedChunk.close();
                this.currentCompressedChunk = null;
            } else {
                this.count(this.currentCompressedChunk.getBytesRead() - l2);
            }
        }
        if (n4 > 0) {
            this.checksum.update(byArray, n2, n4);
        }
        return n4;
    }

    private void readNextBlock() {
        this.verifyLastChecksumAndReset();
        this.inUncompressedChunk = false;
        int n2 = this.readOneByte();
        if (n2 == -1) {
            this.endReached = true;
        } else if (n2 == 255) {
            this.in.unread(n2);
            this.pushedBackBytes(1L);
            this.readStreamIdentifier();
            this.readNextBlock();
        } else if (n2 == 254 || n2 > 127 && n2 <= 253) {
            this.skipBlock();
            this.readNextBlock();
        } else {
            if (n2 >= 2 && n2 <= 127) {
                throw new IOException("unskippable chunk with type " + n2 + " (hex " + Integer.toHexString(n2) + ")" + " detected.");
            }
            if (n2 == 1) {
                this.inUncompressedChunk = true;
                this.uncompressedBytesRemaining = this.readSize() - 4;
                this.expectedChecksum = FramedSnappyCompressorInputStream.unmask(this.readCrc());
            } else if (n2 == 0) {
                long l2 = this.readSize() - 4;
                this.expectedChecksum = FramedSnappyCompressorInputStream.unmask(this.readCrc());
                this.currentCompressedChunk = new SnappyCompressorInputStream(new BoundedInputStream(this.in, l2));
                this.count(this.currentCompressedChunk.getBytesRead());
            } else {
                throw new IOException("unknown chunk type " + n2 + " detected.");
            }
        }
    }

    private long readCrc() {
        byte[] byArray = new byte[4];
        int n2 = IOUtils.readFully(this.in, byArray);
        this.count(n2);
        if (n2 != 4) {
            throw new IOException("premature end of stream");
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            l2 |= ((long)byArray[i2] & 0xFFL) << 8 * i2;
        }
        return l2;
    }

    static long unmask(long l2) {
        l2 -= 2726488792L;
        return ((l2 &= 0xFFFFFFFFL) >> 17 | l2 << 15) & 0xFFFFFFFFL;
    }

    private int readSize() {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            n2 = this.readOneByte();
            if (n2 == -1) {
                throw new IOException("premature end of stream");
            }
            n3 |= n2 << i2 * 8;
        }
        return n3;
    }

    private void skipBlock() {
        int n2 = this.readSize();
        long l2 = IOUtils.skip(this.in, n2);
        this.count(l2);
        if (l2 != (long)n2) {
            throw new IOException("premature end of stream");
        }
    }

    private void readStreamIdentifier() {
        byte[] byArray = new byte[10];
        int n2 = IOUtils.readFully(this.in, byArray);
        this.count(n2);
        if (10 != n2 || !FramedSnappyCompressorInputStream.matches(byArray, 10)) {
            throw new IOException("Not a framed Snappy stream");
        }
    }

    private int readOneByte() {
        int n2 = this.in.read();
        if (n2 != -1) {
            this.count(1);
            return n2 & 0xFF;
        }
        return -1;
    }

    private void verifyLastChecksumAndReset() {
        if (this.expectedChecksum >= 0L && this.expectedChecksum != this.checksum.getValue()) {
            throw new IOException("Checksum verification failed");
        }
        this.expectedChecksum = -1L;
        this.checksum.reset();
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < SZ_SIGNATURE.length) {
            return false;
        }
        byte[] byArray2 = byArray;
        if (byArray.length > SZ_SIGNATURE.length) {
            byArray2 = new byte[SZ_SIGNATURE.length];
            System.arraycopy(byArray, 0, byArray2, 0, SZ_SIGNATURE.length);
        }
        return Arrays.equals(byArray2, SZ_SIGNATURE);
    }
}

