/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.pack200;

import java.io.OutputStream;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.jar.Pack200;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.pack200.Pack200Strategy;
import org.apache.commons.compress.compressors.pack200.StreamBridge;
import org.apache.commons.compress.utils.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pack200CompressorOutputStream
extends CompressorOutputStream {
    private boolean finished = false;
    private final OutputStream originalOutput;
    private final StreamBridge streamBridge;
    private final Map<String, String> properties;

    public Pack200CompressorOutputStream(OutputStream outputStream) {
        this(outputStream, Pack200Strategy.IN_MEMORY);
    }

    public Pack200CompressorOutputStream(OutputStream outputStream, Pack200Strategy pack200Strategy) {
        this(outputStream, pack200Strategy, null);
    }

    public Pack200CompressorOutputStream(OutputStream outputStream, Map<String, String> map) {
        this(outputStream, Pack200Strategy.IN_MEMORY, map);
    }

    public Pack200CompressorOutputStream(OutputStream outputStream, Pack200Strategy pack200Strategy, Map<String, String> map) {
        this.originalOutput = outputStream;
        this.streamBridge = pack200Strategy.newStreamBridge();
        this.properties = map;
    }

    @Override
    public void write(int n2) {
        this.streamBridge.write(n2);
    }

    @Override
    public void write(byte[] byArray) {
        this.streamBridge.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.streamBridge.write(byArray, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.finish();
        try {
            this.streamBridge.stop();
        }
        finally {
            this.originalOutput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finish() {
        if (this.finished) return;
        this.finished = true;
        Pack200.Packer packer = Pack200.newPacker();
        if (this.properties != null) {
            packer.properties().putAll(this.properties);
        }
        JarInputStream jarInputStream = null;
        boolean bl2 = false;
        try {
            jarInputStream = new JarInputStream(this.streamBridge.getInput());
            packer.pack(jarInputStream, this.originalOutput);
            return;
        }
        catch (Throwable throwable) {
            if (bl2) throw throwable;
            IOUtils.closeQuietly(jarInputStream);
            throw throwable;
        }
    }
}

