/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.gzip;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;

public class GzipCompressorInputStream
extends CompressorInputStream {
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private static final int FRESERVED = 224;
    private final InputStream in;
    private final boolean decompressConcatenated;
    private final byte[] buf = new byte[8192];
    private int bufUsed = 0;
    private Inflater inf = new Inflater(true);
    private final CRC32 crc = new CRC32();
    private int memberSize;
    private boolean endReached = false;
    private final byte[] oneByte = new byte[1];
    private final GzipParameters parameters = new GzipParameters();

    public GzipCompressorInputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public GzipCompressorInputStream(InputStream inputStream, boolean bl2) {
        this.in = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        this.decompressConcatenated = bl2;
        this.init(true);
    }

    public GzipParameters getMetaData() {
        return this.parameters;
    }

    private boolean init(boolean bl2) {
        assert (bl2 || this.decompressConcatenated);
        int n2 = this.in.read();
        int n3 = this.in.read();
        if (n2 == -1 && !bl2) {
            return false;
        }
        if (n2 != 31 || n3 != 139) {
            throw new IOException(bl2 ? "Input is not in the .gz format" : "Garbage after a valid .gz stream");
        }
        DataInputStream dataInputStream = new DataInputStream(this.in);
        int n4 = dataInputStream.readUnsignedByte();
        if (n4 != 8) {
            throw new IOException("Unsupported compression method " + n4 + " in the .gz header");
        }
        int n5 = dataInputStream.readUnsignedByte();
        if ((n5 & 0xE0) != 0) {
            throw new IOException("Reserved flags are set in the .gz header");
        }
        this.parameters.setModificationTime(this.readLittleEndianInt(dataInputStream) * 1000);
        switch (dataInputStream.readUnsignedByte()) {
            case 2: {
                this.parameters.setCompressionLevel(9);
                break;
            }
            case 4: {
                this.parameters.setCompressionLevel(1);
                break;
            }
        }
        this.parameters.setOperatingSystem(dataInputStream.readUnsignedByte());
        if ((n5 & 4) != 0) {
            int n6 = dataInputStream.readUnsignedByte();
            n6 |= dataInputStream.readUnsignedByte() << 8;
            while (n6-- > 0) {
                dataInputStream.readUnsignedByte();
            }
        }
        if ((n5 & 8) != 0) {
            this.parameters.setFilename(new String(this.readToNull(dataInputStream), "ISO-8859-1"));
        }
        if ((n5 & 0x10) != 0) {
            this.parameters.setComment(new String(this.readToNull(dataInputStream), "ISO-8859-1"));
        }
        if ((n5 & 2) != 0) {
            dataInputStream.readShort();
        }
        this.inf.reset();
        this.crc.reset();
        this.memberSize = 0;
        return true;
    }

    private byte[] readToNull(DataInputStream dataInputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while ((n2 = dataInputStream.readUnsignedByte()) != 0) {
            byteArrayOutputStream.write(n2);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private int readLittleEndianInt(DataInputStream dataInputStream) {
        return dataInputStream.readUnsignedByte() | dataInputStream.readUnsignedByte() << 8 | dataInputStream.readUnsignedByte() << 16 | dataInputStream.readUnsignedByte() << 24;
    }

    public int read() {
        return this.read(this.oneByte, 0, 1) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (this.endReached) {
            return -1;
        }
        int n4 = 0;
        while (n3 > 0) {
            int n5;
            int n6;
            if (this.inf.needsInput()) {
                this.in.mark(this.buf.length);
                this.bufUsed = this.in.read(this.buf);
                if (this.bufUsed == -1) {
                    throw new EOFException();
                }
                this.inf.setInput(this.buf, 0, this.bufUsed);
            }
            try {
                n6 = this.inf.inflate(byArray, n2, n3);
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException("Gzip-compressed data is corrupt");
            }
            this.crc.update(byArray, n2, n6);
            this.memberSize += n6;
            n2 += n6;
            n3 -= n6;
            n4 += n6;
            this.count(n6);
            if (!this.inf.finished()) continue;
            this.in.reset();
            int n7 = this.bufUsed - this.inf.getRemaining();
            if (this.in.skip(n7) != (long)n7) {
                throw new IOException();
            }
            this.bufUsed = 0;
            DataInputStream dataInputStream = new DataInputStream(this.in);
            long l2 = 0L;
            for (n5 = 0; n5 < 4; ++n5) {
                l2 |= (long)dataInputStream.readUnsignedByte() << n5 * 8;
            }
            if (l2 != this.crc.getValue()) {
                throw new IOException("Gzip-compressed data is corrupt (CRC32 error)");
            }
            n5 = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                n5 |= dataInputStream.readUnsignedByte() << i2 * 8;
            }
            if (n5 != this.memberSize) {
                throw new IOException("Gzip-compressed data is corrupt(uncompressed size mismatch)");
            }
            if (this.decompressConcatenated && this.init(false)) continue;
            this.inf.end();
            this.inf = null;
            this.endReached = true;
            return n4 == 0 ? -1 : n4;
        }
        return n4;
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < 2) {
            return false;
        }
        if (byArray[0] != 31) {
            return false;
        }
        return byArray[1] == -117;
    }

    public void close() {
        if (this.inf != null) {
            this.inf.end();
            this.inf = null;
        }
        if (this.in != System.in) {
            this.in.close();
        }
    }
}

