/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.util.BitSet;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream$Data;

class BlockSort {
    private static final int QSORT_STACK_SIZE = 1000;
    private static final int FALLBACK_QSORT_STACK_SIZE = 100;
    private static final int STACK_SIZE = 1000;
    private int workDone;
    private int workLimit;
    private boolean firstAttempt;
    private final int[] stack_ll = new int[1000];
    private final int[] stack_hh = new int[1000];
    private final int[] stack_dd = new int[1000];
    private final int[] mainSort_runningOrder = new int[256];
    private final int[] mainSort_copy = new int[256];
    private final boolean[] mainSort_bigDone = new boolean[256];
    private final int[] ftab = new int[65537];
    private final char[] quadrant;
    private static final int FALLBACK_QSORT_SMALL_THRESH = 10;
    private int[] eclass;
    private static final int[] INCS = new int[]{1, 4, 13, 40, 121, 364, 1093, 3280, 9841, 29524, 88573, 265720, 797161, 2391484};
    private static final int SMALL_THRESH = 20;
    private static final int DEPTH_THRESH = 10;
    private static final int WORK_FACTOR = 30;
    private static final int SETMASK = 0x200000;
    private static final int CLEARMASK = -2097153;

    BlockSort(BZip2CompressorOutputStream$Data bZip2CompressorOutputStream$Data) {
        this.quadrant = bZip2CompressorOutputStream$Data.sfmap;
    }

    void blockSort(BZip2CompressorOutputStream$Data bZip2CompressorOutputStream$Data, int n2) {
        this.workLimit = 30 * n2;
        this.workDone = 0;
        this.firstAttempt = true;
        if (n2 + 1 < 10000) {
            this.fallbackSort(bZip2CompressorOutputStream$Data, n2);
        } else {
            this.mainSort(bZip2CompressorOutputStream$Data, n2);
            if (this.firstAttempt && this.workDone > this.workLimit) {
                this.fallbackSort(bZip2CompressorOutputStream$Data, n2);
            }
        }
        int[] nArray = bZip2CompressorOutputStream$Data.fmap;
        bZip2CompressorOutputStream$Data.origPtr = -1;
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (nArray[i2] != 0) continue;
            bZip2CompressorOutputStream$Data.origPtr = i2;
            break;
        }
    }

    final void fallbackSort(BZip2CompressorOutputStream$Data bZip2CompressorOutputStream$Data, int n2) {
        bZip2CompressorOutputStream$Data.block[0] = bZip2CompressorOutputStream$Data.block[n2 + 1];
        this.fallbackSort(bZip2CompressorOutputStream$Data.fmap, bZip2CompressorOutputStream$Data.block, n2 + 1);
        int n3 = 0;
        while (n3 < n2 + 1) {
            int n4 = n3++;
            bZip2CompressorOutputStream$Data.fmap[n4] = bZip2CompressorOutputStream$Data.fmap[n4] - 1;
        }
        for (n3 = 0; n3 < n2 + 1; ++n3) {
            if (bZip2CompressorOutputStream$Data.fmap[n3] != -1) continue;
            bZip2CompressorOutputStream$Data.fmap[n3] = n2;
            break;
        }
    }

    private void fallbackSimpleSort(int[] nArray, int[] nArray2, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n2 == n3) {
            return;
        }
        if (n3 - n2 > 3) {
            for (n7 = n3 - 4; n7 >= n2; --n7) {
                n6 = nArray[n7];
                n5 = nArray2[n6];
                for (n4 = n7 + 4; n4 <= n3 && n5 > nArray2[nArray[n4]]; n4 += 4) {
                    nArray[n4 - 4] = nArray[n4];
                }
                nArray[n4 - 4] = n6;
            }
        }
        for (n7 = n3 - 1; n7 >= n2; --n7) {
            n6 = nArray[n7];
            n5 = nArray2[n6];
            for (n4 = n7 + 1; n4 <= n3 && n5 > nArray2[nArray[n4]]; ++n4) {
                nArray[n4 - 1] = nArray[n4];
            }
            nArray[n4 - 1] = n6;
        }
    }

    private void fswap(int[] nArray, int n2, int n3) {
        int n4 = nArray[n2];
        nArray[n2] = nArray[n3];
        nArray[n3] = n4;
    }

    private void fvswap(int[] nArray, int n2, int n3, int n4) {
        while (n4 > 0) {
            this.fswap(nArray, n2, n3);
            ++n2;
            ++n3;
            --n4;
        }
    }

    private int fmin(int n2, int n3) {
        return n2 < n3 ? n2 : n3;
    }

    private void fpush(int n2, int n3, int n4) {
        this.stack_ll[n2] = n3;
        this.stack_hh[n2] = n4;
    }

    private int[] fpop(int n2) {
        return new int[]{this.stack_ll[n2], this.stack_hh[n2]};
    }

    private void fallbackQSort3(int[] nArray, int[] nArray2, int n2, int n3) {
        long l2 = 0L;
        int n4 = 0;
        this.fpush(n4++, n2, n3);
        while (n4 > 0) {
            int n5;
            int n6;
            int n7;
            int n8;
            int[] nArray3;
            int n9;
            if ((n9 = (nArray3 = this.fpop(--n4))[1]) - (n8 = nArray3[0]) < 10) {
                this.fallbackSimpleSort(nArray, nArray2, n8, n9);
                continue;
            }
            long l3 = (l2 = (l2 * 7621L + 1L) % 32768L) % 3L;
            long l4 = l3 == 0L ? (long)nArray2[nArray[n8]] : (l3 == 1L ? (long)nArray2[nArray[n8 + n9 >>> 1]] : (long)nArray2[nArray[n9]]);
            int n10 = n7 = n8;
            int n11 = n6 = n9;
            while (true) {
                if (n10 <= n11) {
                    n5 = nArray2[nArray[n10]] - (int)l4;
                    if (n5 == 0) {
                        this.fswap(nArray, n10, n7);
                        ++n7;
                        ++n10;
                        continue;
                    }
                    if (n5 <= 0) {
                        ++n10;
                        continue;
                    }
                }
                while (n10 <= n11) {
                    n5 = nArray2[nArray[n11]] - (int)l4;
                    if (n5 == 0) {
                        this.fswap(nArray, n11, n6);
                        --n6;
                        --n11;
                        continue;
                    }
                    if (n5 < 0) break;
                    --n11;
                }
                if (n10 > n11) break;
                this.fswap(nArray, n10, n11);
                ++n10;
                --n11;
            }
            if (n6 < n7) continue;
            n5 = this.fmin(n7 - n8, n10 - n7);
            this.fvswap(nArray, n8, n10 - n5, n5);
            int n12 = this.fmin(n9 - n6, n6 - n11);
            this.fvswap(nArray, n11 + 1, n9 - n12 + 1, n12);
            n5 = n8 + n10 - n7 - 1;
            n12 = n9 - (n6 - n11) + 1;
            if (n5 - n8 > n9 - n12) {
                this.fpush(n4++, n8, n5);
                this.fpush(n4++, n12, n9);
                continue;
            }
            this.fpush(n4++, n12, n9);
            this.fpush(n4++, n8, n5);
        }
    }

    private int[] getEclass() {
        return this.eclass == null ? (this.eclass = new int[this.quadrant.length / 2]) : this.eclass;
    }

    /*
     * Unable to fully structure code
     */
    final void fallbackSort(int[] var1_1, byte[] var2_2, int var3_3) {
        var4_4 = new int[257];
        var15_5 = this.getEclass();
        for (var6_6 = 0; var6_6 < var3_3; ++var6_6) {
            var15_5[var6_6] = 0;
        }
        for (var6_6 = 0; var6_6 < var3_3; ++var6_6) {
            v0 = var2_2[var6_6] & 255;
            var4_4[v0] = var4_4[v0] + 1;
        }
        for (var6_6 = 1; var6_6 < 257; ++var6_6) {
            v1 = var6_6;
            var4_4[v1] = var4_4[v1] + var4_4[var6_6 - 1];
        }
        var6_6 = 0;
        while (var6_6 < var3_3) {
            var7_7 = var2_2[var6_6] & 255;
            var4_4[var7_7] = var8_8 = var4_4[var7_7] - 1;
            var1_1[var8_8] = var6_6++;
        }
        var14_9 = 64 + var3_3;
        var16_10 = new BitSet(var14_9);
        for (var6_6 = 0; var6_6 < 256; ++var6_6) {
            var16_10.set(var4_4[var6_6]);
        }
        for (var6_6 = 0; var6_6 < 32; ++var6_6) {
            var16_10.set(var3_3 + 2 * var6_6);
            var16_10.clear(var3_3 + 2 * var6_6 + 1);
        }
        var5_11 = 1;
        block6: do {
            var7_7 = 0;
            for (var6_6 = 0; var6_6 < var3_3; ++var6_6) {
                if (var16_10.get(var6_6)) {
                    var7_7 = var6_6;
                }
                if ((var8_8 = var1_1[var6_6] - var5_11) < 0) {
                    var8_8 += var3_3;
                }
                var15_5[var8_8] = var7_7;
            }
            var13_16 = 0;
            var10_13 = -1;
            block8: while (true) {
                var8_8 = var10_13 + 1;
                var9_12 = (var8_8 = var16_10.nextClearBit(var8_8)) - 1;
                if (var9_12 >= var3_3 || (var10_13 = (var8_8 = var16_10.nextSetBit(var8_8 + 1)) - 1) >= var3_3) continue block6;
                if (var10_13 <= var9_12) continue;
                var13_16 += var10_13 - var9_12 + 1;
                this.fallbackQSort3(var1_1, var15_5, var9_12, var10_13);
                var11_14 = -1;
                var6_6 = var9_12;
                while (true) {
                    if (var6_6 <= var10_13) ** break;
                    continue block8;
                    var12_15 = var15_5[var1_1[var6_6]];
                    if (var11_14 != var12_15) {
                        var16_10.set(var6_6);
                        var11_14 = var12_15;
                    }
                    ++var6_6;
                }
                break;
            }
        } while ((var5_11 *= 2) <= var3_3 && var13_16 != 0);
    }

    private boolean mainSimpleSort(BZip2CompressorOutputStream$Data bZip2CompressorOutputStream$Data, int n2, int n3, int n4, int n5) {
        int n6 = n3 - n2 + 1;
        if (n6 < 2) {
            return this.firstAttempt && this.workDone > this.workLimit;
        }
        int n7 = 0;
        while (INCS[n7] < n6) {
            ++n7;
        }
        int[] nArray = bZip2CompressorOutputStream$Data.fmap;
        char[] cArray = this.quadrant;
        byte[] byArray = bZip2CompressorOutputStream$Data.block;
        int n8 = n5 + 1;
        boolean bl2 = this.firstAttempt;
        int n9 = this.workLimit;
        int n10 = this.workDone;
        block1: while (--n7 >= 0) {
            int n11 = INCS[n7];
            int n12 = n2 + n11 - 1;
            int n13 = n2 + n11;
            while (n13 <= n3) {
                int n14 = 3;
                while (n13 <= n3 && --n14 >= 0) {
                    int n15 = nArray[n13];
                    int n16 = n15 + n4;
                    int n17 = n13;
                    boolean bl3 = false;
                    int n18 = 0;
                    block4: while (true) {
                        int n19;
                        int n20;
                        if (bl3) {
                            nArray[n17] = n18;
                            if ((n17 -= n11) <= n12) {
                                break;
                            }
                        } else {
                            bl3 = true;
                        }
                        if (byArray[(n20 = (n18 = nArray[n17 - n11]) + n4) + 1] == byArray[(n19 = n16) + 1]) {
                            if (byArray[n20 + 2] == byArray[n19 + 2]) {
                                if (byArray[n20 + 3] == byArray[n19 + 3]) {
                                    if (byArray[n20 + 4] == byArray[n19 + 4]) {
                                        if (byArray[n20 + 5] == byArray[n19 + 5]) {
                                            if (byArray[n20 += 6] == byArray[n19 += 6]) {
                                                int n21 = n5;
                                                while (n21 > 0) {
                                                    n21 -= 4;
                                                    if (byArray[n20 + 1] == byArray[n19 + 1]) {
                                                        if (cArray[n20] == cArray[n19]) {
                                                            if (byArray[n20 + 2] == byArray[n19 + 2]) {
                                                                if (cArray[n20 + 1] == cArray[n19 + 1]) {
                                                                    if (byArray[n20 + 3] == byArray[n19 + 3]) {
                                                                        if (cArray[n20 + 2] == cArray[n19 + 2]) {
                                                                            if (byArray[n20 + 4] == byArray[n19 + 4]) {
                                                                                if (cArray[n20 + 3] == cArray[n19 + 3]) {
                                                                                    if ((n20 += 4) >= n8) {
                                                                                        n20 -= n8;
                                                                                    }
                                                                                    if ((n19 += 4) >= n8) {
                                                                                        n19 -= n8;
                                                                                    }
                                                                                    ++n10;
                                                                                    continue;
                                                                                }
                                                                                if (cArray[n20 + 3] <= cArray[n19 + 3]) break block4;
                                                                                continue block4;
                                                                            }
                                                                            if ((byArray[n20 + 4] & 0xFF) <= (byArray[n19 + 4] & 0xFF)) break block4;
                                                                            continue block4;
                                                                        }
                                                                        if (cArray[n20 + 2] <= cArray[n19 + 2]) break block4;
                                                                        continue block4;
                                                                    }
                                                                    if ((byArray[n20 + 3] & 0xFF) <= (byArray[n19 + 3] & 0xFF)) break block4;
                                                                    continue block4;
                                                                }
                                                                if (cArray[n20 + 1] <= cArray[n19 + 1]) break block4;
                                                                continue block4;
                                                            }
                                                            if ((byArray[n20 + 2] & 0xFF) <= (byArray[n19 + 2] & 0xFF)) break block4;
                                                            continue block4;
                                                        }
                                                        if (cArray[n20] <= cArray[n19]) break block4;
                                                        continue block4;
                                                    }
                                                    if ((byArray[n20 + 1] & 0xFF) <= (byArray[n19 + 1] & 0xFF)) break block4;
                                                    continue block4;
                                                }
                                                break;
                                            }
                                            if ((byArray[n20] & 0xFF) <= (byArray[n19] & 0xFF)) break;
                                            continue;
                                        }
                                        if ((byArray[n20 + 5] & 0xFF) <= (byArray[n19 + 5] & 0xFF)) break;
                                        continue;
                                    }
                                    if ((byArray[n20 + 4] & 0xFF) <= (byArray[n19 + 4] & 0xFF)) break;
                                    continue;
                                }
                                if ((byArray[n20 + 3] & 0xFF) <= (byArray[n19 + 3] & 0xFF)) break;
                                continue;
                            }
                            if ((byArray[n20 + 2] & 0xFF) <= (byArray[n19 + 2] & 0xFF)) break;
                            continue;
                        }
                        if ((byArray[n20 + 1] & 0xFF) <= (byArray[n19 + 1] & 0xFF)) break;
                    }
                    nArray[n17] = n15;
                    ++n13;
                }
                if (!bl2 || n13 > n3 || n10 <= n9) continue;
                break block1;
            }
        }
        this.workDone = n10;
        return bl2 && n10 > n9;
    }

    private static void vswap(int[] nArray, int n2, int n3, int n4) {
        n4 += n2;
        while (n2 < n4) {
            int n5 = nArray[n2];
            nArray[n2++] = nArray[n3];
            nArray[n3++] = n5;
        }
    }

    private static byte med3(byte by2, byte by3, byte by4) {
        return by2 < by3 ? (by3 < by4 ? by3 : (by2 < by4 ? by4 : by2)) : (by3 > by4 ? by3 : (by2 > by4 ? by4 : by2));
    }

    private void mainQSort3(BZip2CompressorOutputStream$Data bZip2CompressorOutputStream$Data, int n2, int n3, int n4, int n5) {
        int[] nArray = this.stack_ll;
        int[] nArray2 = this.stack_hh;
        int[] nArray3 = this.stack_dd;
        int[] nArray4 = bZip2CompressorOutputStream$Data.fmap;
        byte[] byArray = bZip2CompressorOutputStream$Data.block;
        nArray[0] = n2;
        nArray2[0] = n3;
        nArray3[0] = n4;
        int n6 = 1;
        while (--n6 >= 0) {
            int n7;
            int n8;
            int n9 = nArray[n6];
            int n10 = nArray2[n6];
            int n11 = nArray3[n6];
            if (n10 - n9 < 20 || n11 > 10) {
                if (!this.mainSimpleSort(bZip2CompressorOutputStream$Data, n9, n10, n11, n5)) continue;
                return;
            }
            int n12 = n11 + 1;
            int n13 = BlockSort.med3(byArray[nArray4[n9] + n12], byArray[nArray4[n10] + n12], byArray[nArray4[n9 + n10 >>> 1] + n12]) & 0xFF;
            int n14 = n9;
            int n15 = n10;
            int n16 = n9;
            int n17 = n10;
            while (true) {
                if (n14 <= n15) {
                    n8 = (byArray[nArray4[n14] + n12] & 0xFF) - n13;
                    if (n8 == 0) {
                        n7 = nArray4[n14];
                        nArray4[n14++] = nArray4[n16];
                        nArray4[n16++] = n7;
                        continue;
                    }
                    if (n8 < 0) {
                        ++n14;
                        continue;
                    }
                }
                while (n14 <= n15) {
                    n8 = (byArray[nArray4[n15] + n12] & 0xFF) - n13;
                    if (n8 == 0) {
                        n7 = nArray4[n15];
                        nArray4[n15--] = nArray4[n17];
                        nArray4[n17--] = n7;
                        continue;
                    }
                    if (n8 <= 0) break;
                    --n15;
                }
                if (n14 > n15) break;
                n8 = nArray4[n14];
                nArray4[n14++] = nArray4[n15];
                nArray4[n15--] = n8;
            }
            if (n17 < n16) {
                nArray[n6] = n9;
                nArray2[n6] = n10;
                nArray3[n6] = n12;
                ++n6;
                continue;
            }
            n8 = n16 - n9 < n14 - n16 ? n16 - n9 : n14 - n16;
            BlockSort.vswap(nArray4, n9, n14 - n8, n8);
            n7 = n10 - n17 < n17 - n15 ? n10 - n17 : n17 - n15;
            BlockSort.vswap(nArray4, n14, n10 - n7 + 1, n7);
            n8 = n9 + n14 - n16 - 1;
            n7 = n10 - (n17 - n15) + 1;
            nArray[n6] = n9;
            nArray2[n6] = n8;
            nArray3[n6] = n11;
            nArray[++n6] = n8 + 1;
            nArray2[n6] = n7 - 1;
            nArray3[n6] = n12;
            nArray[++n6] = n7;
            nArray2[n6] = n10;
            nArray3[n6] = n11;
            ++n6;
        }
    }

    final void mainSort(BZip2CompressorOutputStream$Data bZip2CompressorOutputStream$Data, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int[] nArray = this.mainSort_runningOrder;
        int[] nArray2 = this.mainSort_copy;
        boolean[] blArray = this.mainSort_bigDone;
        int[] nArray3 = this.ftab;
        byte[] byArray = bZip2CompressorOutputStream$Data.block;
        int[] nArray4 = bZip2CompressorOutputStream$Data.fmap;
        char[] cArray = this.quadrant;
        int n10 = this.workLimit;
        boolean bl2 = this.firstAttempt;
        int n11 = 65537;
        while (--n11 >= 0) {
            nArray3[n11] = 0;
        }
        for (n11 = 0; n11 < 20; ++n11) {
            byArray[n2 + n11 + 2] = byArray[n11 % (n2 + 1) + 1];
        }
        n11 = n2 + 20 + 1;
        while (--n11 >= 0) {
            cArray[n11] = '\u0000';
        }
        byArray[0] = byArray[n2 + 1];
        n11 = byArray[0] & 0xFF;
        for (n9 = 0; n9 <= n2; ++n9) {
            n8 = byArray[n9 + 1] & 0xFF;
            int n12 = (n11 << 8) + n8;
            nArray3[n12] = nArray3[n12] + 1;
            n11 = n8;
        }
        for (n9 = 1; n9 <= 65536; ++n9) {
            int n13 = n9;
            nArray3[n13] = nArray3[n13] + nArray3[n9 - 1];
        }
        n11 = byArray[1] & 0xFF;
        n9 = 0;
        while (n9 < n2) {
            n8 = byArray[n9 + 2] & 0xFF;
            int n14 = (n11 << 8) + n8;
            int n15 = nArray3[n14] - 1;
            nArray3[n14] = n15;
            nArray4[n15] = n9++;
            n11 = n8;
        }
        int n16 = ((byArray[n2 + 1] & 0xFF) << 8) + (byArray[1] & 0xFF);
        int n17 = nArray3[n16] - 1;
        nArray3[n16] = n17;
        nArray4[n17] = n2;
        n9 = 256;
        while (--n9 >= 0) {
            blArray[n9] = false;
            nArray[n9] = n9;
        }
        n9 = 364;
        while (n9 != 1) {
            for (n8 = n9 /= 3; n8 <= 255; ++n8) {
                n7 = nArray[n8];
                n6 = nArray3[n7 + 1 << 8] - nArray3[n7 << 8];
                n5 = n9 - 1;
                n4 = n8;
                n3 = nArray[n4 - n9];
                while (nArray3[n3 + 1 << 8] - nArray3[n3 << 8] > n6) {
                    nArray[n4] = n3;
                    if ((n4 -= n9) <= n5) break;
                    n3 = nArray[n4 - n9];
                }
                nArray[n4] = n7;
            }
        }
        for (n9 = 0; n9 <= 255; ++n9) {
            n8 = nArray[n9];
            for (n7 = 0; n7 <= 255; ++n7) {
                n6 = (n8 << 8) + n7;
                n5 = nArray3[n6];
                if ((n5 & 0x200000) == 0x200000) continue;
                n3 = (nArray3[n6 + 1] & 0xFFDFFFFF) - 1;
                n4 = n5 & 0xFFDFFFFF;
                if (n3 > n4) {
                    this.mainQSort3(bZip2CompressorOutputStream$Data, n4, n3, 2, n2);
                    if (bl2 && this.workDone > n10) {
                        return;
                    }
                }
                nArray3[n6] = n5 | 0x200000;
            }
            for (n7 = 0; n7 <= 255; ++n7) {
                nArray2[n7] = nArray3[(n7 << 8) + n8] & 0xFFDFFFFF;
            }
            n6 = nArray3[n8 + 1 << 8] & 0xFFDFFFFF;
            for (n7 = nArray3[n8 << 8] & 0xFFDFFFFF; n7 < n6; ++n7) {
                n5 = nArray4[n7];
                n11 = byArray[n5] & 0xFF;
                if (blArray[n11]) continue;
                nArray4[nArray2[n11]] = n5 == 0 ? n2 : n5 - 1;
                int n18 = n11;
                nArray2[n18] = nArray2[n18] + 1;
            }
            n7 = 256;
            while (--n7 >= 0) {
                int n19 = (n7 << 8) + n8;
                nArray3[n19] = nArray3[n19] | 0x200000;
            }
            blArray[n8] = true;
            if (n9 >= 255) continue;
            n7 = nArray3[n8 << 8] & 0xFFDFFFFF;
            n6 = (nArray3[n8 + 1 << 8] & 0xFFDFFFFF) - n7;
            n5 = 0;
            while (n6 >> n5 > 65534) {
                ++n5;
            }
            for (n4 = 0; n4 < n6; ++n4) {
                char c2;
                n3 = nArray4[n7 + n4];
                cArray[n3] = c2 = (char)(n4 >> n5);
                if (n3 >= 20) continue;
                cArray[n3 + n2 + 1] = c2;
            }
        }
    }
}

