/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream$Data;
import org.apache.commons.compress.compressors.bzip2.BZip2Constants;
import org.apache.commons.compress.compressors.bzip2.CRC;
import org.apache.commons.compress.compressors.bzip2.Rand;

public class BZip2CompressorInputStream
extends CompressorInputStream
implements BZip2Constants {
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private int bsBuff;
    private int bsLive;
    private final CRC crc = new CRC();
    private int nInUse;
    private InputStream in;
    private final boolean decompressConcatenated;
    private static final int EOF = 0;
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private int currentState = 1;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    private int su_count;
    private int su_ch2;
    private int su_chPrev;
    private int su_i2;
    private int su_j2;
    private int su_rNToGo;
    private int su_rTPos;
    private int su_tPos;
    private char su_z;
    private BZip2CompressorInputStream$Data data;

    public BZip2CompressorInputStream(InputStream inputStream) {
        this(inputStream, false);
    }

    public BZip2CompressorInputStream(InputStream inputStream, boolean bl2) {
        this.in = inputStream;
        this.decompressConcatenated = bl2;
        this.init(true);
        this.initBlock();
    }

    public int read() {
        if (this.in != null) {
            int n2 = this.read0();
            this.count(n2 < 0 ? -1 : 1);
            return n2;
        }
        throw new IOException("stream closed");
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("offs(" + n2 + ") < 0.");
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("len(" + n3 + ") < 0.");
        }
        if (n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("offs(" + n2 + ") + len(" + n3 + ") > dest.length(" + byArray.length + ").");
        }
        if (this.in == null) {
            throw new IOException("stream closed");
        }
        int n5 = n2 + n3;
        int n6 = n2;
        while (n6 < n5 && (n4 = this.read0()) >= 0) {
            byArray[n6++] = (byte)n4;
            this.count(1);
        }
        int n7 = n6 == n2 ? -1 : n6 - n2;
        return n7;
    }

    private void makeMaps() {
        boolean[] blArray = this.data.inUse;
        byte[] byArray = this.data.seqToUnseq;
        int n2 = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            if (!blArray[i2]) continue;
            byArray[n2++] = (byte)i2;
        }
        this.nInUse = n2;
    }

    private int read0() {
        switch (this.currentState) {
            case 0: {
                return -1;
            }
            case 1: {
                return this.setupBlock();
            }
            case 2: {
                throw new IllegalStateException();
            }
            case 3: {
                return this.setupRandPartB();
            }
            case 4: {
                return this.setupRandPartC();
            }
            case 5: {
                throw new IllegalStateException();
            }
            case 6: {
                return this.setupNoRandPartB();
            }
            case 7: {
                return this.setupNoRandPartC();
            }
        }
        throw new IllegalStateException();
    }

    private boolean init(boolean bl2) {
        if (null == this.in) {
            throw new IOException("No InputStream");
        }
        int n2 = this.in.read();
        if (n2 == -1 && !bl2) {
            return false;
        }
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (n2 != 66 || n3 != 90 || n4 != 104) {
            throw new IOException(bl2 ? "Stream is not in the BZip2 format" : "Garbage after a valid BZip2 stream");
        }
        int n5 = this.in.read();
        if (n5 < 49 || n5 > 57) {
            throw new IOException("BZip2 block size is invalid");
        }
        this.blockSize100k = n5 - 48;
        this.bsLive = 0;
        this.computedCombinedCRC = 0;
        return true;
    }

    private void initBlock() {
        char c2;
        char c3;
        char c4;
        char c5;
        char c6;
        char c7;
        block3: {
            do {
                c7 = this.bsGetUByte();
                c6 = this.bsGetUByte();
                c5 = this.bsGetUByte();
                c4 = this.bsGetUByte();
                c3 = this.bsGetUByte();
                c2 = this.bsGetUByte();
                if (c7 != '\u0017' || c6 != 'r' || c5 != 'E' || c4 != '8' || c3 != 'P' || c2 != '\u0090') break block3;
            } while (!this.complete());
            return;
        }
        if (c7 != '1' || c6 != 'A' || c5 != 'Y' || c4 != '&' || c3 != 'S' || c2 != 'Y') {
            this.currentState = 0;
            throw new IOException("bad block header");
        }
        this.storedBlockCRC = this.bsGetInt();
        boolean bl2 = this.blockRandomised = this.bsR(1) == 1;
        if (this.data == null) {
            this.data = new BZip2CompressorInputStream$Data(this.blockSize100k);
        }
        this.getAndMoveToFrontDecode();
        this.crc.initialiseCRC();
        this.currentState = 1;
    }

    private void endBlock() {
        this.computedBlockCRC = this.crc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            this.computedCombinedCRC = this.storedCombinedCRC << 1 | this.storedCombinedCRC >>> 31;
            this.computedCombinedCRC ^= this.storedBlockCRC;
            throw new IOException("BZip2 CRC error");
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private boolean complete() {
        this.storedCombinedCRC = this.bsGetInt();
        this.currentState = 0;
        this.data = null;
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            throw new IOException("BZip2 CRC error");
        }
        return !this.decompressConcatenated || !this.init(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        InputStream inputStream = this.in;
        if (inputStream != null) {
            try {
                if (inputStream != System.in) {
                    inputStream.close();
                }
            }
            finally {
                this.data = null;
                this.in = null;
            }
        }
    }

    private int bsR(int n2) {
        int n3 = this.bsLive;
        int n4 = this.bsBuff;
        if (n3 < n2) {
            InputStream inputStream = this.in;
            do {
                int n5;
                if ((n5 = inputStream.read()) < 0) {
                    throw new IOException("unexpected end of stream");
                }
                n4 = n4 << 8 | n5;
            } while ((n3 += 8) < n2);
            this.bsBuff = n4;
        }
        this.bsLive = n3 - n2;
        return n4 >> n3 - n2 & (1 << n2) - 1;
    }

    private boolean bsGetBit() {
        int n2 = this.bsLive;
        int n3 = this.bsBuff;
        if (n2 < 1) {
            int n4 = this.in.read();
            if (n4 < 0) {
                throw new IOException("unexpected end of stream");
            }
            n3 = n3 << 8 | n4;
            n2 += 8;
            this.bsBuff = n3;
        }
        this.bsLive = n2 - 1;
        return (n3 >> n2 - 1 & 1) != 0;
    }

    private char bsGetUByte() {
        return (char)this.bsR(8);
    }

    private int bsGetInt() {
        return ((this.bsR(8) << 8 | this.bsR(8)) << 8 | this.bsR(8)) << 8 | this.bsR(8);
    }

    private static void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, char[] cArray, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = 0;
        for (n6 = n2; n6 <= n3; ++n6) {
            for (n5 = 0; n5 < n4; ++n5) {
                if (cArray[n5] != n6) continue;
                nArray3[n7++] = n5;
            }
        }
        n6 = 23;
        while (--n6 > 0) {
            nArray2[n6] = 0;
            nArray[n6] = 0;
        }
        for (n6 = 0; n6 < n4; ++n6) {
            int n8 = cArray[n6] + '\u0001';
            nArray2[n8] = nArray2[n8] + 1;
        }
        n7 = nArray2[0];
        for (n6 = 1; n6 < 23; ++n6) {
            nArray2[n6] = n7 += nArray2[n6];
        }
        n7 = 0;
        n5 = nArray2[n6];
        for (n6 = n2; n6 <= n3; ++n6) {
            int n9 = nArray2[n6 + 1];
            n5 = n9;
            nArray[n6] = (n7 += n9 - n5) - 1;
            n7 <<= 1;
        }
        for (n6 = n2 + 1; n6 <= n3; ++n6) {
            nArray2[n6] = (nArray[n6 - 1] + 1 << 1) - nArray2[n6];
        }
    }

    private void recvDecodingTables() {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        BZip2CompressorInputStream$Data bZip2CompressorInputStream$Data = this.data;
        boolean[] blArray = bZip2CompressorInputStream$Data.inUse;
        byte[] byArray = bZip2CompressorInputStream$Data.recvDecodingTables_pos;
        byte[] byArray2 = bZip2CompressorInputStream$Data.selector;
        byte[] byArray3 = bZip2CompressorInputStream$Data.selectorMtf;
        int n8 = 0;
        for (n7 = 0; n7 < 16; ++n7) {
            if (!this.bsGetBit()) continue;
            n8 |= 1 << n7;
        }
        n7 = 256;
        while (--n7 >= 0) {
            blArray[n7] = false;
        }
        for (n7 = 0; n7 < 16; ++n7) {
            if ((n8 & 1 << n7) == 0) continue;
            n6 = n7 << 4;
            for (n5 = 0; n5 < 16; ++n5) {
                if (!this.bsGetBit()) continue;
                blArray[n6 + n5] = true;
            }
        }
        this.makeMaps();
        n7 = this.nInUse + 2;
        n6 = this.bsR(3);
        n5 = this.bsR(15);
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = 0;
            while (this.bsGetBit()) {
                ++n3;
            }
            byArray3[n4] = (byte)n3;
        }
        n4 = n6;
        while (--n4 >= 0) {
            byArray[n4] = (byte)n4;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n2 = byArray[n3];
            for (n3 = byArray3[n4] & 0xFF; n3 > 0; --n3) {
                byArray[n3] = byArray[n3 - 1];
            }
            byArray[0] = n2;
            byArray2[n4] = n2;
        }
        char[][] cArray = bZip2CompressorInputStream$Data.temp_charArray2d;
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = this.bsR(5);
            char[] cArray2 = cArray[n3];
            for (int i2 = 0; i2 < n7; ++i2) {
                while (this.bsGetBit()) {
                    n2 += this.bsGetBit() ? -1 : 1;
                }
                cArray2[i2] = (char)n2;
            }
        }
        this.createHuffmanDecodingTables(n7, n6);
    }

    private void createHuffmanDecodingTables(int n2, int n3) {
        BZip2CompressorInputStream$Data bZip2CompressorInputStream$Data = this.data;
        char[][] cArray = bZip2CompressorInputStream$Data.temp_charArray2d;
        int[] nArray = bZip2CompressorInputStream$Data.minLens;
        int[][] nArray2 = bZip2CompressorInputStream$Data.limit;
        int[][] nArray3 = bZip2CompressorInputStream$Data.base;
        int[][] nArray4 = bZip2CompressorInputStream$Data.perm;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = 32;
            int n5 = 0;
            char[] cArray2 = cArray[i2];
            int n6 = n2;
            while (--n6 >= 0) {
                int n7 = cArray2[n6];
                if (n7 > n5) {
                    n5 = n7;
                }
                if (n7 >= n4) continue;
                n4 = n7;
            }
            BZip2CompressorInputStream.hbCreateDecodeTables(nArray2[i2], nArray3[i2], nArray4[i2], cArray[i2], n4, n5, n2);
            nArray[i2] = n4;
        }
    }

    private void getAndMoveToFrontDecode() {
        this.origPtr = this.bsR(24);
        this.recvDecodingTables();
        InputStream inputStream = this.in;
        BZip2CompressorInputStream$Data bZip2CompressorInputStream$Data = this.data;
        byte[] byArray = bZip2CompressorInputStream$Data.ll8;
        int[] nArray = bZip2CompressorInputStream$Data.unzftab;
        byte[] byArray2 = bZip2CompressorInputStream$Data.selector;
        byte[] byArray3 = bZip2CompressorInputStream$Data.seqToUnseq;
        char[] cArray = bZip2CompressorInputStream$Data.getAndMoveToFrontDecode_yy;
        int[] nArray2 = bZip2CompressorInputStream$Data.minLens;
        int[][] nArray3 = bZip2CompressorInputStream$Data.limit;
        int[][] nArray4 = bZip2CompressorInputStream$Data.base;
        int[][] nArray5 = bZip2CompressorInputStream$Data.perm;
        int n2 = this.blockSize100k * 100000;
        int n3 = 256;
        while (--n3 >= 0) {
            cArray[n3] = (char)n3;
            nArray[n3] = 0;
        }
        n3 = 0;
        int n4 = 49;
        int n5 = this.nInUse + 1;
        int n6 = this.getAndMoveToFrontDecode0(0);
        int n7 = this.bsBuff;
        int n8 = this.bsLive;
        int n9 = -1;
        int n10 = byArray2[n3] & 0xFF;
        int[] nArray6 = nArray4[n10];
        int[] nArray7 = nArray3[n10];
        int[] nArray8 = nArray5[n10];
        int n11 = nArray2[n10];
        while (n6 != n5) {
            int n12;
            int n13;
            int n14;
            int n15;
            if (n6 == 0 || n6 == 1) {
                n15 = -1;
                n14 = 1;
                while (true) {
                    if (n6 == 0) {
                        n15 += n14;
                    } else {
                        if (n6 != 1) break;
                        n15 += n14 << 1;
                    }
                    if (n4 == 0) {
                        n4 = 49;
                        n10 = byArray2[++n3] & 0xFF;
                        nArray6 = nArray4[n10];
                        nArray7 = nArray3[n10];
                        nArray8 = nArray5[n10];
                        n11 = nArray2[n10];
                    } else {
                        --n4;
                    }
                    n13 = n11;
                    while (n8 < n13) {
                        n12 = inputStream.read();
                        if (n12 >= 0) {
                            n7 = n7 << 8 | n12;
                            n8 += 8;
                            continue;
                        }
                        throw new IOException("unexpected end of stream");
                    }
                    n12 = n7 >> n8 - n13 & (1 << n13) - 1;
                    n8 -= n13;
                    while (n12 > nArray7[n13]) {
                        ++n13;
                        while (n8 < 1) {
                            int n16 = inputStream.read();
                            if (n16 >= 0) {
                                n7 = n7 << 8 | n16;
                                n8 += 8;
                                continue;
                            }
                            throw new IOException("unexpected end of stream");
                        }
                        n12 = n12 << 1 | n7 >> --n8 & 1;
                    }
                    n6 = nArray8[n12 - nArray6[n13]];
                    n14 <<= 1;
                }
                n14 = byArray3[cArray[0]];
                int n17 = n14 & 0xFF;
                nArray[n17] = nArray[n17] + (n15 + 1);
                while (n15-- >= 0) {
                    byArray[++n9] = n14;
                }
                if (n9 < n2) continue;
                throw new IOException("block overrun");
            }
            if (++n9 >= n2) {
                throw new IOException("block overrun");
            }
            n15 = cArray[n6 - 1];
            int n18 = byArray3[n15] & 0xFF;
            nArray[n18] = nArray[n18] + 1;
            byArray[n9] = byArray3[n15];
            if (n6 <= 16) {
                n14 = n6 - 1;
                while (n14 > 0) {
                    cArray[n14--] = cArray[n14];
                }
            } else {
                System.arraycopy(cArray, 0, cArray, 1, n6 - 1);
            }
            cArray[0] = n15;
            if (n4 == 0) {
                n4 = 49;
                n10 = byArray2[++n3] & 0xFF;
                nArray6 = nArray4[n10];
                nArray7 = nArray3[n10];
                nArray8 = nArray5[n10];
                n11 = nArray2[n10];
            } else {
                --n4;
            }
            n14 = n11;
            while (n8 < n14) {
                n13 = inputStream.read();
                if (n13 >= 0) {
                    n7 = n7 << 8 | n13;
                    n8 += 8;
                    continue;
                }
                throw new IOException("unexpected end of stream");
            }
            n13 = n7 >> n8 - n14 & (1 << n14) - 1;
            n8 -= n14;
            while (n13 > nArray7[n14]) {
                ++n14;
                while (n8 < 1) {
                    n12 = inputStream.read();
                    if (n12 >= 0) {
                        n7 = n7 << 8 | n12;
                        n8 += 8;
                        continue;
                    }
                    throw new IOException("unexpected end of stream");
                }
                n13 = n13 << 1 | n7 >> --n8 & 1;
            }
            n6 = nArray8[n13 - nArray6[n14]];
        }
        this.last = n9;
        this.bsLive = n8;
        this.bsBuff = n7;
    }

    private int getAndMoveToFrontDecode0(int n2) {
        InputStream inputStream = this.in;
        BZip2CompressorInputStream$Data bZip2CompressorInputStream$Data = this.data;
        int n3 = bZip2CompressorInputStream$Data.selector[n2] & 0xFF;
        int[] nArray = bZip2CompressorInputStream$Data.limit[n3];
        int n4 = bZip2CompressorInputStream$Data.minLens[n3];
        int n5 = this.bsR(n4);
        int n6 = this.bsLive;
        int n7 = this.bsBuff;
        while (n5 > nArray[n4]) {
            ++n4;
            while (n6 < 1) {
                int n8 = inputStream.read();
                if (n8 >= 0) {
                    n7 = n7 << 8 | n8;
                    n6 += 8;
                    continue;
                }
                throw new IOException("unexpected end of stream");
            }
            n5 = n5 << 1 | n7 >> --n6 & 1;
        }
        this.bsLive = n6;
        this.bsBuff = n7;
        return bZip2CompressorInputStream$Data.perm[n3][n5 - bZip2CompressorInputStream$Data.base[n3][n4]];
    }

    private int setupBlock() {
        int n2;
        if (this.currentState == 0 || this.data == null) {
            return -1;
        }
        int[] nArray = this.data.cftab;
        int[] nArray2 = this.data.initTT(this.last + 1);
        byte[] byArray = this.data.ll8;
        nArray[0] = 0;
        System.arraycopy(this.data.unzftab, 0, nArray, 1, 256);
        int n3 = nArray[0];
        for (n2 = 1; n2 <= 256; ++n2) {
            nArray[n2] = n3 += nArray[n2];
        }
        n2 = 0;
        n3 = this.last;
        while (n2 <= n3) {
            int n4 = byArray[n2] & 0xFF;
            int n5 = nArray[n4];
            nArray[n4] = n5 + 1;
            nArray2[n5] = n2++;
        }
        if (this.origPtr < 0 || this.origPtr >= nArray2.length) {
            throw new IOException("stream corrupted");
        }
        this.su_tPos = nArray2[this.origPtr];
        this.su_count = 0;
        this.su_i2 = 0;
        this.su_ch2 = 256;
        if (this.blockRandomised) {
            this.su_rNToGo = 0;
            this.su_rTPos = 0;
            return this.setupRandPartA();
        }
        return this.setupNoRandPartA();
    }

    private int setupRandPartA() {
        if (this.su_i2 <= this.last) {
            this.su_chPrev = this.su_ch2;
            int n2 = this.data.ll8[this.su_tPos] & 0xFF;
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = Rand.rNums(this.su_rTPos) - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_ch2 = n2 ^= this.su_rNToGo == 1 ? 1 : 0;
            ++this.su_i2;
            this.currentState = 3;
            this.crc.updateCRC(n2);
            return n2;
        }
        this.endBlock();
        this.initBlock();
        return this.setupBlock();
    }

    private int setupNoRandPartA() {
        if (this.su_i2 <= this.last) {
            int n2;
            this.su_chPrev = this.su_ch2;
            this.su_ch2 = n2 = this.data.ll8[this.su_tPos] & 0xFF;
            this.su_tPos = this.data.tt[this.su_tPos];
            ++this.su_i2;
            this.currentState = 6;
            this.crc.updateCRC(n2);
            return n2;
        }
        this.currentState = 5;
        this.endBlock();
        this.initBlock();
        return this.setupBlock();
    }

    private int setupRandPartB() {
        if (this.su_ch2 != this.su_chPrev) {
            this.currentState = 2;
            this.su_count = 1;
            return this.setupRandPartA();
        }
        if (++this.su_count >= 4) {
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = Rand.rNums(this.su_rTPos) - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_j2 = 0;
            this.currentState = 4;
            if (this.su_rNToGo == 1) {
                this.su_z = (char)(this.su_z ^ '\u0001');
            }
            return this.setupRandPartC();
        }
        this.currentState = 2;
        return this.setupRandPartA();
    }

    private int setupRandPartC() {
        if (this.su_j2 < this.su_z) {
            this.crc.updateCRC(this.su_ch2);
            ++this.su_j2;
            return this.su_ch2;
        }
        this.currentState = 2;
        ++this.su_i2;
        this.su_count = 0;
        return this.setupRandPartA();
    }

    private int setupNoRandPartB() {
        if (this.su_ch2 != this.su_chPrev) {
            this.su_count = 1;
            return this.setupNoRandPartA();
        }
        if (++this.su_count >= 4) {
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            this.su_tPos = this.data.tt[this.su_tPos];
            this.su_j2 = 0;
            return this.setupNoRandPartC();
        }
        return this.setupNoRandPartA();
    }

    private int setupNoRandPartC() {
        if (this.su_j2 < this.su_z) {
            int n2 = this.su_ch2;
            this.crc.updateCRC(n2);
            ++this.su_j2;
            this.currentState = 7;
            return n2;
        }
        ++this.su_i2;
        this.su_count = 0;
        return this.setupNoRandPartA();
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < 3) {
            return false;
        }
        if (byArray[0] != 66) {
            return false;
        }
        if (byArray[1] != 90) {
            return false;
        }
        return byArray[2] == 104;
    }
}

