/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ExplodingInputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.UnshrinkingInputStream;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipFile$1;
import org.apache.commons.compress.archivers.zip.ZipFile$2;
import org.apache.commons.compress.archivers.zip.ZipFile$BoundedInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile$Entry;
import org.apache.commons.compress.archivers.zip.ZipFile$NameAndComment;
import org.apache.commons.compress.archivers.zip.ZipFile$OffsetEntry;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;
import org.apache.commons.compress.utils.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements Closeable {
    private static final int HASH_SIZE = 509;
    static final int NIBLET_MASK = 15;
    static final int BYTE_SHIFT = 8;
    private static final int POS_0 = 0;
    private static final int POS_1 = 1;
    private static final int POS_2 = 2;
    private static final int POS_3 = 3;
    private final List<ZipArchiveEntry> entries = new LinkedList<ZipArchiveEntry>();
    private final Map<String, LinkedList<ZipArchiveEntry>> nameMap = new HashMap<String, LinkedList<ZipArchiveEntry>>(509);
    private final String encoding;
    private final ZipEncoding zipEncoding;
    private final String archiveName;
    private final RandomAccessFile archive;
    private final boolean useUnicodeExtraFields;
    private boolean closed;
    private final byte[] DWORD_BUF = new byte[8];
    private final byte[] WORD_BUF = new byte[4];
    private final byte[] CFH_BUF = new byte[42];
    private final byte[] SHORT_BUF = new byte[2];
    private static final int CFH_LEN = 42;
    private static final long CFH_SIG = ZipLong.getValue(ZipArchiveOutputStream.CFH_SIG);
    static final int MIN_EOCD_SIZE = 22;
    private static final int MAX_EOCD_SIZE = 65557;
    private static final int CFD_LOCATOR_OFFSET = 16;
    private static final int ZIP64_EOCDL_LENGTH = 20;
    private static final int ZIP64_EOCDL_LOCATOR_OFFSET = 8;
    private static final int ZIP64_EOCD_CFD_LOCATOR_OFFSET = 48;
    private static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;
    private final Comparator<ZipArchiveEntry> OFFSET_COMPARATOR = new ZipFile$2(this);

    public ZipFile(File file) {
        this(file, "UTF8");
    }

    public ZipFile(String string) {
        this(new File(string), "UTF8");
    }

    public ZipFile(String string, String string2) {
        this(new File(string), string2, true);
    }

    public ZipFile(File file, String string) {
        this(file, string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFile(File file, String string, boolean bl2) {
        this.archiveName = file.getAbsolutePath();
        this.encoding = string;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        this.useUnicodeExtraFields = bl2;
        this.archive = new RandomAccessFile(file, "r");
        boolean bl3 = false;
        try {
            Map<ZipArchiveEntry, ZipFile$NameAndComment> map = this.populateFromCentralDirectory();
            this.resolveLocalFileHeaderData(map);
            bl3 = true;
        }
        finally {
            if (!bl3) {
                this.closed = true;
                IOUtils.closeQuietly(this.archive);
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void close() {
        this.closed = true;
        this.archive.close();
    }

    public static void closeQuietly(ZipFile zipFile) {
        IOUtils.closeQuietly(zipFile);
    }

    public Enumeration<ZipArchiveEntry> getEntries() {
        return Collections.enumeration(this.entries);
    }

    public Enumeration<ZipArchiveEntry> getEntriesInPhysicalOrder() {
        ZipArchiveEntry[] zipArchiveEntryArray = this.entries.toArray(new ZipArchiveEntry[0]);
        Arrays.sort(zipArchiveEntryArray, this.OFFSET_COMPARATOR);
        return Collections.enumeration(Arrays.asList(zipArchiveEntryArray));
    }

    public ZipArchiveEntry getEntry(String string) {
        LinkedList<ZipArchiveEntry> linkedList = this.nameMap.get(string);
        return linkedList != null ? linkedList.getFirst() : null;
    }

    public Iterable<ZipArchiveEntry> getEntries(String string) {
        List<ZipArchiveEntry> list = (List<ZipArchiveEntry>)this.nameMap.get(string);
        return list != null ? list : Collections.emptyList();
    }

    public Iterable<ZipArchiveEntry> getEntriesInPhysicalOrder(String string) {
        ZipArchiveEntry[] zipArchiveEntryArray = new ZipArchiveEntry[]{};
        if (this.nameMap.containsKey(string)) {
            zipArchiveEntryArray = this.nameMap.get(string).toArray(zipArchiveEntryArray);
            Arrays.sort(zipArchiveEntryArray, this.OFFSET_COMPARATOR);
        }
        return Arrays.asList(zipArchiveEntryArray);
    }

    public boolean canReadEntryData(ZipArchiveEntry zipArchiveEntry) {
        return ZipUtil.canHandleEntryData(zipArchiveEntry);
    }

    public InputStream getInputStream(ZipArchiveEntry zipArchiveEntry) {
        if (!(zipArchiveEntry instanceof ZipFile$Entry)) {
            return null;
        }
        ZipFile$OffsetEntry zipFile$OffsetEntry = ((ZipFile$Entry)zipArchiveEntry).getOffsetEntry();
        ZipUtil.checkRequestedFeatures(zipArchiveEntry);
        long l2 = ZipFile$OffsetEntry.access$000(zipFile$OffsetEntry);
        ZipFile$BoundedInputStream zipFile$BoundedInputStream = new ZipFile$BoundedInputStream(this, l2, zipArchiveEntry.getCompressedSize());
        switch (ZipMethod.getMethodByCode(zipArchiveEntry.getMethod())) {
            case STORED: {
                return zipFile$BoundedInputStream;
            }
            case UNSHRINKING: {
                return new UnshrinkingInputStream(zipFile$BoundedInputStream);
            }
            case IMPLODING: {
                return new ExplodingInputStream(zipArchiveEntry.getGeneralPurposeBit().getSlidingDictionarySize(), zipArchiveEntry.getGeneralPurposeBit().getNumberOfShannonFanoTrees(), new BufferedInputStream(zipFile$BoundedInputStream));
            }
            case DEFLATED: {
                zipFile$BoundedInputStream.addDummy();
                Inflater inflater = new Inflater(true);
                return new ZipFile$1(this, zipFile$BoundedInputStream, inflater, inflater);
            }
        }
        throw new ZipException("Found unsupported compression method " + zipArchiveEntry.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUnixSymlink(ZipArchiveEntry zipArchiveEntry) {
        if (zipArchiveEntry != null && zipArchiveEntry.isUnixSymlink()) {
            InputStream inputStream = null;
            try {
                inputStream = this.getInputStream(zipArchiveEntry);
                byte[] byArray = IOUtils.toByteArray(inputStream);
                String string = this.zipEncoding.decode(byArray);
                return string;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        try {
            if (!this.closed) {
                System.err.println("Cleaning up unclosed ZipFile for archive " + this.archiveName);
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private Map<ZipArchiveEntry, ZipFile$NameAndComment> populateFromCentralDirectory() {
        HashMap<ZipArchiveEntry, ZipFile$NameAndComment> hashMap = new HashMap<ZipArchiveEntry, ZipFile$NameAndComment>();
        this.positionAtCentralDirectory();
        this.archive.readFully(this.WORD_BUF);
        long l2 = ZipLong.getValue(this.WORD_BUF);
        if (l2 != CFH_SIG && this.startsWithLocalFileHeader()) {
            throw new IOException("central directory is empty, can't expand corrupt archive.");
        }
        while (l2 == CFH_SIG) {
            this.readCentralDirectoryEntry(hashMap);
            this.archive.readFully(this.WORD_BUF);
            l2 = ZipLong.getValue(this.WORD_BUF);
        }
        return hashMap;
    }

    private void readCentralDirectoryEntry(Map<ZipArchiveEntry, ZipFile$NameAndComment> map) {
        this.archive.readFully(this.CFH_BUF);
        int n2 = 0;
        ZipFile$OffsetEntry zipFile$OffsetEntry = new ZipFile$OffsetEntry();
        ZipFile$Entry zipFile$Entry = new ZipFile$Entry(zipFile$OffsetEntry);
        int n3 = ZipShort.getValue(this.CFH_BUF, n2);
        n2 += 2;
        zipFile$Entry.setPlatform(n3 >> 8 & 0xF);
        GeneralPurposeBit generalPurposeBit = GeneralPurposeBit.parse(this.CFH_BUF, n2 += 2);
        boolean bl2 = generalPurposeBit.usesUTF8ForNames();
        ZipEncoding zipEncoding = bl2 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        zipFile$Entry.setGeneralPurposeBit(generalPurposeBit);
        zipFile$Entry.setMethod(ZipShort.getValue(this.CFH_BUF, n2 += 2));
        long l2 = ZipUtil.dosToJavaTime(ZipLong.getValue(this.CFH_BUF, n2 += 2));
        zipFile$Entry.setTime(l2);
        zipFile$Entry.setCrc(ZipLong.getValue(this.CFH_BUF, n2 += 4));
        zipFile$Entry.setCompressedSize(ZipLong.getValue(this.CFH_BUF, n2 += 4));
        zipFile$Entry.setSize(ZipLong.getValue(this.CFH_BUF, n2 += 4));
        int n4 = ZipShort.getValue(this.CFH_BUF, n2 += 4);
        int n5 = ZipShort.getValue(this.CFH_BUF, n2 += 2);
        int n6 = ZipShort.getValue(this.CFH_BUF, n2 += 2);
        int n7 = ZipShort.getValue(this.CFH_BUF, n2 += 2);
        zipFile$Entry.setInternalAttributes(ZipShort.getValue(this.CFH_BUF, n2 += 2));
        zipFile$Entry.setExternalAttributes(ZipLong.getValue(this.CFH_BUF, n2 += 2));
        byte[] byArray = new byte[n4];
        this.archive.readFully(byArray);
        zipFile$Entry.setName(zipEncoding.decode(byArray), byArray);
        ZipFile$OffsetEntry.access$202(zipFile$OffsetEntry, ZipLong.getValue(this.CFH_BUF, n2 += 4));
        this.entries.add(zipFile$Entry);
        byte[] byArray2 = new byte[n5];
        this.archive.readFully(byArray2);
        zipFile$Entry.setCentralDirectoryExtra(byArray2);
        this.setSizesAndOffsetFromZip64Extra(zipFile$Entry, zipFile$OffsetEntry, n7);
        byte[] byArray3 = new byte[n6];
        this.archive.readFully(byArray3);
        zipFile$Entry.setComment(zipEncoding.decode(byArray3));
        if (!bl2 && this.useUnicodeExtraFields) {
            map.put(zipFile$Entry, new ZipFile$NameAndComment(byArray, byArray3));
        }
    }

    private void setSizesAndOffsetFromZip64Extra(ZipArchiveEntry zipArchiveEntry, ZipFile$OffsetEntry zipFile$OffsetEntry, int n2) {
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = (Zip64ExtendedInformationExtraField)zipArchiveEntry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        if (zip64ExtendedInformationExtraField != null) {
            boolean bl2 = zipArchiveEntry.getSize() == 0xFFFFFFFFL;
            boolean bl3 = zipArchiveEntry.getCompressedSize() == 0xFFFFFFFFL;
            boolean bl4 = ZipFile$OffsetEntry.access$200(zipFile$OffsetEntry) == 0xFFFFFFFFL;
            zip64ExtendedInformationExtraField.reparseCentralDirectoryData(bl2, bl3, bl4, n2 == 65535);
            if (bl2) {
                zipArchiveEntry.setSize(zip64ExtendedInformationExtraField.getSize().getLongValue());
            } else if (bl3) {
                zip64ExtendedInformationExtraField.setSize(new ZipEightByteInteger(zipArchiveEntry.getSize()));
            }
            if (bl3) {
                zipArchiveEntry.setCompressedSize(zip64ExtendedInformationExtraField.getCompressedSize().getLongValue());
            } else if (bl2) {
                zip64ExtendedInformationExtraField.setCompressedSize(new ZipEightByteInteger(zipArchiveEntry.getCompressedSize()));
            }
            if (bl4) {
                ZipFile$OffsetEntry.access$202(zipFile$OffsetEntry, zip64ExtendedInformationExtraField.getRelativeHeaderOffset().getLongValue());
            }
        }
    }

    private void positionAtCentralDirectory() {
        boolean bl2;
        this.positionAtEndOfCentralDirectoryRecord();
        boolean bl3 = false;
        boolean bl4 = bl2 = this.archive.getFilePointer() > 20L;
        if (bl2) {
            this.archive.seek(this.archive.getFilePointer() - 20L);
            this.archive.readFully(this.WORD_BUF);
            bl3 = Arrays.equals(ZipArchiveOutputStream.ZIP64_EOCD_LOC_SIG, this.WORD_BUF);
        }
        if (!bl3) {
            if (bl2) {
                this.skipBytes(16);
            }
            this.positionAtCentralDirectory32();
        } else {
            this.positionAtCentralDirectory64();
        }
    }

    private void positionAtCentralDirectory64() {
        this.skipBytes(4);
        this.archive.readFully(this.DWORD_BUF);
        this.archive.seek(ZipEightByteInteger.getLongValue(this.DWORD_BUF));
        this.archive.readFully(this.WORD_BUF);
        if (!Arrays.equals(this.WORD_BUF, ZipArchiveOutputStream.ZIP64_EOCD_SIG)) {
            throw new ZipException("archive's ZIP64 end of central directory locator is corrupt.");
        }
        this.skipBytes(44);
        this.archive.readFully(this.DWORD_BUF);
        this.archive.seek(ZipEightByteInteger.getLongValue(this.DWORD_BUF));
    }

    private void positionAtCentralDirectory32() {
        this.skipBytes(16);
        this.archive.readFully(this.WORD_BUF);
        this.archive.seek(ZipLong.getValue(this.WORD_BUF));
    }

    private void positionAtEndOfCentralDirectoryRecord() {
        boolean bl2 = this.tryToLocateSignature(22L, 65557L, ZipArchiveOutputStream.EOCD_SIG);
        if (!bl2) {
            throw new ZipException("archive is not a ZIP archive");
        }
    }

    private boolean tryToLocateSignature(long l2, long l3, byte[] byArray) {
        long l4;
        boolean bl2 = false;
        long l5 = Math.max(0L, this.archive.length() - l3);
        if (l4 >= 0L) {
            for (l4 = this.archive.length() - l2; l4 >= l5; --l4) {
                this.archive.seek(l4);
                int n2 = this.archive.read();
                if (n2 == -1) break;
                if (n2 != byArray[0] || (n2 = this.archive.read()) != byArray[1] || (n2 = this.archive.read()) != byArray[2] || (n2 = this.archive.read()) != byArray[3]) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            this.archive.seek(l4);
        }
        return bl2;
    }

    private void skipBytes(int n2) {
        int n3;
        for (int i2 = 0; i2 < n2; i2 += n3) {
            n3 = this.archive.skipBytes(n2 - i2);
            if (n3 > 0) continue;
            throw new EOFException();
        }
    }

    private void resolveLocalFileHeaderData(Map<ZipArchiveEntry, ZipFile$NameAndComment> map) {
        for (ZipArchiveEntry zipArchiveEntry : this.entries) {
            LinkedList<ZipArchiveEntry> linkedList;
            Object object;
            int n2;
            ZipFile$Entry zipFile$Entry = (ZipFile$Entry)zipArchiveEntry;
            ZipFile$OffsetEntry zipFile$OffsetEntry = zipFile$Entry.getOffsetEntry();
            long l2 = ZipFile$OffsetEntry.access$200(zipFile$OffsetEntry);
            this.archive.seek(l2 + 26L);
            this.archive.readFully(this.SHORT_BUF);
            int n3 = ZipShort.getValue(this.SHORT_BUF);
            this.archive.readFully(this.SHORT_BUF);
            int n4 = ZipShort.getValue(this.SHORT_BUF);
            for (int i2 = n3; i2 > 0; i2 -= n2) {
                n2 = this.archive.skipBytes(i2);
                if (n2 > 0) continue;
                throw new IOException("failed to skip file name in local file header");
            }
            byte[] byArray = new byte[n4];
            this.archive.readFully(byArray);
            zipFile$Entry.setExtra(byArray);
            ZipFile$OffsetEntry.access$002(zipFile$OffsetEntry, l2 + 26L + 2L + 2L + (long)n3 + (long)n4);
            if (map.containsKey(zipFile$Entry)) {
                object = map.get(zipFile$Entry);
                ZipUtil.setNameAndCommentFromExtraFields(zipFile$Entry, ZipFile$NameAndComment.access$400((ZipFile$NameAndComment)object), ZipFile$NameAndComment.access$500((ZipFile$NameAndComment)object));
            }
            if ((linkedList = this.nameMap.get(object = zipFile$Entry.getName())) == null) {
                linkedList = new LinkedList();
                this.nameMap.put((String)object, linkedList);
            }
            linkedList.addLast(zipFile$Entry);
        }
    }

    private boolean startsWithLocalFileHeader() {
        this.archive.seek(0L);
        this.archive.readFully(this.WORD_BUF);
        return Arrays.equals(this.WORD_BUF, ZipArchiveOutputStream.LFH_SIG);
    }

    static /* synthetic */ RandomAccessFile access$600(ZipFile zipFile) {
        return zipFile.archive;
    }
}

