/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.UnicodeCommentExtraField;
import org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.Zip64RequiredException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream$CurrentEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream$UnicodeExtraFieldPolicy;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;
import org.apache.commons.compress.utils.IOUtils;

public class ZipArchiveOutputStream
extends ArchiveOutputStream {
    static final int BUFFER_SIZE = 512;
    protected boolean finished = false;
    private static final int DEFLATER_BLOCK_SIZE = 8192;
    public static final int DEFLATED = 8;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int STORED = 0;
    static final String DEFAULT_ENCODING = "UTF8";
    @Deprecated
    public static final int EFS_FLAG = 2048;
    private static final byte[] EMPTY = new byte[0];
    private ZipArchiveOutputStream$CurrentEntry entry;
    private String comment = "";
    private int level = -1;
    private boolean hasCompressionLevelChanged = false;
    private int method = 8;
    private final List<ZipArchiveEntry> entries = new LinkedList<ZipArchiveEntry>();
    private final CRC32 crc = new CRC32();
    private long written = 0L;
    private long cdOffset = 0L;
    private long cdLength = 0L;
    private static final byte[] ZERO = new byte[]{0, 0};
    private static final byte[] LZERO = new byte[]{0, 0, 0, 0};
    private final Map<ZipArchiveEntry, Long> offsets = new HashMap<ZipArchiveEntry, Long>();
    private String encoding = "UTF8";
    private ZipEncoding zipEncoding = ZipEncodingHelper.getZipEncoding("UTF8");
    protected final Deflater def = new Deflater(this.level, true);
    private final byte[] buf = new byte[512];
    private final RandomAccessFile raf;
    private final OutputStream out;
    private boolean useUTF8Flag = true;
    private boolean fallbackToUTF8 = false;
    private ZipArchiveOutputStream$UnicodeExtraFieldPolicy createUnicodeExtraFields = ZipArchiveOutputStream$UnicodeExtraFieldPolicy.NEVER;
    private boolean hasUsedZip64 = false;
    private Zip64Mode zip64Mode = Zip64Mode.AsNeeded;
    static final byte[] LFH_SIG = ZipLong.LFH_SIG.getBytes();
    static final byte[] DD_SIG = ZipLong.DD_SIG.getBytes();
    static final byte[] CFH_SIG = ZipLong.CFH_SIG.getBytes();
    static final byte[] EOCD_SIG = ZipLong.getBytes(101010256L);
    static final byte[] ZIP64_EOCD_SIG = ZipLong.getBytes(101075792L);
    static final byte[] ZIP64_EOCD_LOC_SIG = ZipLong.getBytes(117853008L);
    private static final byte[] ONE = ZipLong.getBytes(1L);

    public ZipArchiveOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        this.raf = null;
    }

    public ZipArchiveOutputStream(File file) {
        FileOutputStream fileOutputStream = null;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(0L);
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(randomAccessFile);
            randomAccessFile = null;
            fileOutputStream = new FileOutputStream(file);
        }
        this.out = fileOutputStream;
        this.raf = randomAccessFile;
    }

    public boolean isSeekable() {
        return this.raf != null;
    }

    public void setEncoding(String string) {
        this.encoding = string;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        if (this.useUTF8Flag && !ZipEncodingHelper.isUTF8(string)) {
            this.useUTF8Flag = false;
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setUseLanguageEncodingFlag(boolean bl2) {
        this.useUTF8Flag = bl2 && ZipEncodingHelper.isUTF8(this.encoding);
    }

    public void setCreateUnicodeExtraFields(ZipArchiveOutputStream$UnicodeExtraFieldPolicy zipArchiveOutputStream$UnicodeExtraFieldPolicy) {
        this.createUnicodeExtraFields = zipArchiveOutputStream$UnicodeExtraFieldPolicy;
    }

    public void setFallbackToUTF8(boolean bl2) {
        this.fallbackToUTF8 = bl2;
    }

    public void setUseZip64(Zip64Mode zip64Mode) {
        this.zip64Mode = zip64Mode;
    }

    public void finish() {
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        if (this.entry != null) {
            throw new IOException("This archive contains unclosed entries.");
        }
        this.cdOffset = this.written;
        for (ZipArchiveEntry zipArchiveEntry : this.entries) {
            this.writeCentralFileHeader(zipArchiveEntry);
        }
        this.cdLength = this.written - this.cdOffset;
        this.writeZip64CentralDirectory();
        this.writeCentralDirectoryEnd();
        this.offsets.clear();
        this.entries.clear();
        this.def.end();
        this.finished = true;
    }

    public void closeArchiveEntry() {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (this.entry == null) {
            throw new IOException("No current entry to close");
        }
        if (!ZipArchiveOutputStream$CurrentEntry.access$000(this.entry)) {
            this.write(EMPTY, 0, 0);
        }
        this.flushDeflater();
        Zip64Mode zip64Mode = this.getEffectiveZip64Mode(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry));
        long l2 = this.written - ZipArchiveOutputStream$CurrentEntry.access$200(this.entry);
        long l3 = this.crc.getValue();
        this.crc.reset();
        boolean bl2 = this.handleSizesAndCrc(l2, l3, zip64Mode);
        if (this.raf != null) {
            this.rewriteSizesAndCrc(bl2);
        }
        this.writeDataDescriptor(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry));
        this.entry = null;
    }

    private void flushDeflater() {
        if (ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getMethod() == 8) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
        }
    }

    private boolean handleSizesAndCrc(long l2, long l3, Zip64Mode zip64Mode) {
        boolean bl2;
        if (ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getMethod() == 8) {
            ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).setSize(ZipArchiveOutputStream$CurrentEntry.access$300(this.entry));
            ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).setCompressedSize(l2);
            ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).setCrc(l3);
            this.def.reset();
        } else if (this.raf == null) {
            if (ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getCrc() != l3) {
                throw new ZipException("bad CRC checksum for entry " + ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getName() + ": " + Long.toHexString(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getCrc()) + " instead of " + Long.toHexString(l3));
            }
            if (ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getSize() != l2) {
                throw new ZipException("bad size for entry " + ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getName() + ": " + ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getSize() + " instead of " + l2);
            }
        } else {
            ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).setSize(l2);
            ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).setCompressedSize(l2);
            ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).setCrc(l3);
        }
        boolean bl3 = bl2 = zip64Mode == Zip64Mode.Always || ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getSize() >= 0xFFFFFFFFL || ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getCompressedSize() >= 0xFFFFFFFFL;
        if (bl2 && zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException(Zip64RequiredException.getEntryTooBigMessage(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry)));
        }
        return bl2;
    }

    private void rewriteSizesAndCrc(boolean bl2) {
        long l2 = this.raf.getFilePointer();
        this.raf.seek(ZipArchiveOutputStream$CurrentEntry.access$400(this.entry));
        this.writeOut(ZipLong.getBytes(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getCrc()));
        if (!this.hasZip64Extra(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry)) || !bl2) {
            this.writeOut(ZipLong.getBytes(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getCompressedSize()));
            this.writeOut(ZipLong.getBytes(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getSize()));
        } else {
            this.writeOut(ZipLong.ZIP64_MAGIC.getBytes());
            this.writeOut(ZipLong.ZIP64_MAGIC.getBytes());
        }
        if (this.hasZip64Extra(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry))) {
            this.raf.seek(ZipArchiveOutputStream$CurrentEntry.access$400(this.entry) + 12L + 4L + (long)this.getName(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry)).limit() + 4L);
            this.writeOut(ZipEightByteInteger.getBytes(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getSize()));
            this.writeOut(ZipEightByteInteger.getBytes(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getCompressedSize()));
            if (!bl2) {
                this.raf.seek(ZipArchiveOutputStream$CurrentEntry.access$400(this.entry) - 10L);
                this.writeOut(ZipShort.getBytes(10));
                ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).removeExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
                ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).setExtra();
                if (ZipArchiveOutputStream$CurrentEntry.access$500(this.entry)) {
                    this.hasUsedZip64 = false;
                }
            }
        }
        this.raf.seek(l2);
    }

    public void putArchiveEntry(ArchiveEntry archiveEntry) {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (this.entry != null) {
            this.closeArchiveEntry();
        }
        this.entry = new ZipArchiveOutputStream$CurrentEntry((ZipArchiveEntry)archiveEntry, null);
        this.entries.add(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry));
        this.setDefaults(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry));
        Zip64Mode zip64Mode = this.getEffectiveZip64Mode(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry));
        this.validateSizeInformation(zip64Mode);
        if (this.shouldAddZip64Extra(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry), zip64Mode)) {
            Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = this.getZip64Extra(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry));
            ZipEightByteInteger zipEightByteInteger = ZipEightByteInteger.ZERO;
            if (ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getMethod() == 0 && ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getSize() != -1L) {
                zipEightByteInteger = new ZipEightByteInteger(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getSize());
            }
            zip64ExtendedInformationExtraField.setSize(zipEightByteInteger);
            zip64ExtendedInformationExtraField.setCompressedSize(zipEightByteInteger);
            ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).setExtra();
        }
        if (ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getMethod() == 8 && this.hasCompressionLevelChanged) {
            this.def.setLevel(this.level);
            this.hasCompressionLevelChanged = false;
        }
        this.writeLocalFileHeader(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry));
    }

    private void setDefaults(ZipArchiveEntry zipArchiveEntry) {
        if (zipArchiveEntry.getMethod() == -1) {
            zipArchiveEntry.setMethod(this.method);
        }
        if (zipArchiveEntry.getTime() == -1L) {
            zipArchiveEntry.setTime(System.currentTimeMillis());
        }
    }

    private void validateSizeInformation(Zip64Mode zip64Mode) {
        if (ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getMethod() == 0 && this.raf == null) {
            if (ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method when not writing to a file");
            }
            if (ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method when not writing to a file");
            }
            ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).setCompressedSize(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getSize());
        }
        if ((ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getSize() >= 0xFFFFFFFFL || ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getCompressedSize() >= 0xFFFFFFFFL) && zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException(Zip64RequiredException.getEntryTooBigMessage(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry)));
        }
    }

    private boolean shouldAddZip64Extra(ZipArchiveEntry zipArchiveEntry, Zip64Mode zip64Mode) {
        return zip64Mode == Zip64Mode.Always || zipArchiveEntry.getSize() >= 0xFFFFFFFFL || zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL || zipArchiveEntry.getSize() == -1L && this.raf != null && zip64Mode != Zip64Mode.Never;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setLevel(int n2) {
        if (n2 < -1 || n2 > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + n2);
        }
        this.hasCompressionLevelChanged = this.level != n2;
        this.level = n2;
    }

    public void setMethod(int n2) {
        this.method = n2;
    }

    public boolean canWriteEntryData(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof ZipArchiveEntry) {
            ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)archiveEntry;
            return zipArchiveEntry.getMethod() != ZipMethod.IMPLODING.getCode() && zipArchiveEntry.getMethod() != ZipMethod.UNSHRINKING.getCode() && ZipUtil.canHandleEntryData(zipArchiveEntry);
        }
        return false;
    }

    public void write(byte[] byArray, int n2, int n3) {
        if (this.entry == null) {
            throw new IllegalStateException("No current entry");
        }
        ZipUtil.checkRequestedFeatures(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry));
        ZipArchiveOutputStream$CurrentEntry.access$002(this.entry, true);
        if (ZipArchiveOutputStream$CurrentEntry.access$100(this.entry).getMethod() == 8) {
            this.writeDeflated(byArray, n2, n3);
        } else {
            this.writeOut(byArray, n2, n3);
            this.written += (long)n3;
        }
        this.crc.update(byArray, n2, n3);
        this.count(n3);
    }

    private void writeDeflated(byte[] byArray, int n2, int n3) {
        if (n3 > 0 && !this.def.finished()) {
            ZipArchiveOutputStream$CurrentEntry.access$314(this.entry, n3);
            if (n3 <= 8192) {
                this.def.setInput(byArray, n2, n3);
                this.deflateUntilInputIsNeeded();
            } else {
                int n4;
                int n5 = n3 / 8192;
                for (n4 = 0; n4 < n5; ++n4) {
                    this.def.setInput(byArray, n2 + n4 * 8192, 8192);
                    this.deflateUntilInputIsNeeded();
                }
                n4 = n5 * 8192;
                if (n4 < n3) {
                    this.def.setInput(byArray, n2 + n4, n3 - n4);
                    this.deflateUntilInputIsNeeded();
                }
            }
        }
    }

    public void close() {
        if (!this.finished) {
            this.finish();
        }
        this.destroy();
    }

    public void flush() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected final void deflate() {
        int n2 = this.def.deflate(this.buf, 0, this.buf.length);
        if (n2 > 0) {
            this.writeOut(this.buf, 0, n2);
            this.written += (long)n2;
        }
    }

    protected void writeLocalFileHeader(ZipArchiveEntry zipArchiveEntry) {
        byte[] byArray;
        boolean bl2 = this.zipEncoding.canEncode(zipArchiveEntry.getName());
        ByteBuffer byteBuffer = this.getName(zipArchiveEntry);
        if (this.createUnicodeExtraFields != ZipArchiveOutputStream$UnicodeExtraFieldPolicy.NEVER) {
            this.addUnicodeExtraFields(zipArchiveEntry, bl2, byteBuffer);
        }
        this.offsets.put(zipArchiveEntry, this.written);
        this.writeOut(LFH_SIG);
        this.written += 4L;
        int n2 = zipArchiveEntry.getMethod();
        this.writeVersionNeededToExtractAndGeneralPurposeBits(n2, !bl2 && this.fallbackToUTF8, this.hasZip64Extra(zipArchiveEntry));
        this.written += 4L;
        this.writeOut(ZipShort.getBytes(n2));
        this.written += 2L;
        this.writeOut(ZipUtil.toDosTime(zipArchiveEntry.getTime()));
        this.written += 4L;
        ZipArchiveOutputStream$CurrentEntry.access$402(this.entry, this.written);
        if (n2 == 8 || this.raf != null) {
            this.writeOut(LZERO);
            if (this.hasZip64Extra(ZipArchiveOutputStream$CurrentEntry.access$100(this.entry))) {
                this.writeOut(ZipLong.ZIP64_MAGIC.getBytes());
                this.writeOut(ZipLong.ZIP64_MAGIC.getBytes());
            } else {
                this.writeOut(LZERO);
                this.writeOut(LZERO);
            }
        } else {
            this.writeOut(ZipLong.getBytes(zipArchiveEntry.getCrc()));
            byArray = ZipLong.ZIP64_MAGIC.getBytes();
            if (!this.hasZip64Extra(zipArchiveEntry)) {
                byArray = ZipLong.getBytes(zipArchiveEntry.getSize());
            }
            this.writeOut(byArray);
            this.writeOut(byArray);
        }
        this.written += 12L;
        this.writeOut(ZipShort.getBytes(byteBuffer.limit()));
        this.written += 2L;
        byArray = zipArchiveEntry.getLocalFileDataExtra();
        this.writeOut(ZipShort.getBytes(byArray.length));
        this.written += 2L;
        this.writeOut(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit() - byteBuffer.position());
        this.written += (long)byteBuffer.limit();
        this.writeOut(byArray);
        this.written += (long)byArray.length;
        ZipArchiveOutputStream$CurrentEntry.access$202(this.entry, this.written);
    }

    private void addUnicodeExtraFields(ZipArchiveEntry zipArchiveEntry, boolean bl2, ByteBuffer byteBuffer) {
        String string;
        if (this.createUnicodeExtraFields == ZipArchiveOutputStream$UnicodeExtraFieldPolicy.ALWAYS || !bl2) {
            zipArchiveEntry.addExtraField(new UnicodePathExtraField(zipArchiveEntry.getName(), byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit() - byteBuffer.position()));
        }
        if ((string = zipArchiveEntry.getComment()) != null && !"".equals(string)) {
            boolean bl3 = this.zipEncoding.canEncode(string);
            if (this.createUnicodeExtraFields == ZipArchiveOutputStream$UnicodeExtraFieldPolicy.ALWAYS || !bl3) {
                ByteBuffer byteBuffer2 = this.getEntryEncoding(zipArchiveEntry).encode(string);
                zipArchiveEntry.addExtraField(new UnicodeCommentExtraField(string, byteBuffer2.array(), byteBuffer2.arrayOffset(), byteBuffer2.limit() - byteBuffer2.position()));
            }
        }
    }

    protected void writeDataDescriptor(ZipArchiveEntry zipArchiveEntry) {
        if (zipArchiveEntry.getMethod() != 8 || this.raf != null) {
            return;
        }
        this.writeOut(DD_SIG);
        this.writeOut(ZipLong.getBytes(zipArchiveEntry.getCrc()));
        int n2 = 4;
        if (!this.hasZip64Extra(zipArchiveEntry)) {
            this.writeOut(ZipLong.getBytes(zipArchiveEntry.getCompressedSize()));
            this.writeOut(ZipLong.getBytes(zipArchiveEntry.getSize()));
        } else {
            n2 = 8;
            this.writeOut(ZipEightByteInteger.getBytes(zipArchiveEntry.getCompressedSize()));
            this.writeOut(ZipEightByteInteger.getBytes(zipArchiveEntry.getSize()));
        }
        this.written += (long)(8 + 2 * n2);
    }

    protected void writeCentralFileHeader(ZipArchiveEntry zipArchiveEntry) {
        boolean bl2;
        this.writeOut(CFH_SIG);
        this.written += 4L;
        long l2 = this.offsets.get(zipArchiveEntry);
        boolean bl3 = bl2 = this.hasZip64Extra(zipArchiveEntry) || zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL || zipArchiveEntry.getSize() >= 0xFFFFFFFFL || l2 >= 0xFFFFFFFFL;
        if (bl2 && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("archive's size exceeds the limit of 4GByte.");
        }
        this.handleZip64Extra(zipArchiveEntry, l2, bl2);
        this.writeOut(ZipShort.getBytes(zipArchiveEntry.getPlatform() << 8 | (!this.hasUsedZip64 ? 20 : 45)));
        this.written += 2L;
        int n2 = zipArchiveEntry.getMethod();
        boolean bl4 = this.zipEncoding.canEncode(zipArchiveEntry.getName());
        this.writeVersionNeededToExtractAndGeneralPurposeBits(n2, !bl4 && this.fallbackToUTF8, bl2);
        this.written += 4L;
        this.writeOut(ZipShort.getBytes(n2));
        this.written += 2L;
        this.writeOut(ZipUtil.toDosTime(zipArchiveEntry.getTime()));
        this.written += 4L;
        this.writeOut(ZipLong.getBytes(zipArchiveEntry.getCrc()));
        if (zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL || zipArchiveEntry.getSize() >= 0xFFFFFFFFL) {
            this.writeOut(ZipLong.ZIP64_MAGIC.getBytes());
            this.writeOut(ZipLong.ZIP64_MAGIC.getBytes());
        } else {
            this.writeOut(ZipLong.getBytes(zipArchiveEntry.getCompressedSize()));
            this.writeOut(ZipLong.getBytes(zipArchiveEntry.getSize()));
        }
        this.written += 12L;
        ByteBuffer byteBuffer = this.getName(zipArchiveEntry);
        this.writeOut(ZipShort.getBytes(byteBuffer.limit()));
        this.written += 2L;
        byte[] byArray = zipArchiveEntry.getCentralDirectoryExtra();
        this.writeOut(ZipShort.getBytes(byArray.length));
        this.written += 2L;
        String string = zipArchiveEntry.getComment();
        if (string == null) {
            string = "";
        }
        ByteBuffer byteBuffer2 = this.getEntryEncoding(zipArchiveEntry).encode(string);
        this.writeOut(ZipShort.getBytes(byteBuffer2.limit()));
        this.written += 2L;
        this.writeOut(ZERO);
        this.written += 2L;
        this.writeOut(ZipShort.getBytes(zipArchiveEntry.getInternalAttributes()));
        this.written += 2L;
        this.writeOut(ZipLong.getBytes(zipArchiveEntry.getExternalAttributes()));
        this.written += 4L;
        this.writeOut(ZipLong.getBytes(Math.min(l2, 0xFFFFFFFFL)));
        this.written += 4L;
        this.writeOut(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit() - byteBuffer.position());
        this.written += (long)byteBuffer.limit();
        this.writeOut(byArray);
        this.written += (long)byArray.length;
        this.writeOut(byteBuffer2.array(), byteBuffer2.arrayOffset(), byteBuffer2.limit() - byteBuffer2.position());
        this.written += (long)byteBuffer2.limit();
    }

    private void handleZip64Extra(ZipArchiveEntry zipArchiveEntry, long l2, boolean bl2) {
        if (bl2) {
            Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = this.getZip64Extra(zipArchiveEntry);
            if (zipArchiveEntry.getCompressedSize() >= 0xFFFFFFFFL || zipArchiveEntry.getSize() >= 0xFFFFFFFFL) {
                zip64ExtendedInformationExtraField.setCompressedSize(new ZipEightByteInteger(zipArchiveEntry.getCompressedSize()));
                zip64ExtendedInformationExtraField.setSize(new ZipEightByteInteger(zipArchiveEntry.getSize()));
            } else {
                zip64ExtendedInformationExtraField.setCompressedSize(null);
                zip64ExtendedInformationExtraField.setSize(null);
            }
            if (l2 >= 0xFFFFFFFFL) {
                zip64ExtendedInformationExtraField.setRelativeHeaderOffset(new ZipEightByteInteger(l2));
            }
            zipArchiveEntry.setExtra();
        }
    }

    protected void writeCentralDirectoryEnd() {
        this.writeOut(EOCD_SIG);
        this.writeOut(ZERO);
        this.writeOut(ZERO);
        int n2 = this.entries.size();
        if (n2 > 65535 && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("archive contains more than 65535 entries.");
        }
        if (this.cdOffset > 0xFFFFFFFFL && this.zip64Mode == Zip64Mode.Never) {
            throw new Zip64RequiredException("archive's size exceeds the limit of 4GByte.");
        }
        byte[] byArray = ZipShort.getBytes(Math.min(n2, 65535));
        this.writeOut(byArray);
        this.writeOut(byArray);
        this.writeOut(ZipLong.getBytes(Math.min(this.cdLength, 0xFFFFFFFFL)));
        this.writeOut(ZipLong.getBytes(Math.min(this.cdOffset, 0xFFFFFFFFL)));
        ByteBuffer byteBuffer = this.zipEncoding.encode(this.comment);
        this.writeOut(ZipShort.getBytes(byteBuffer.limit()));
        this.writeOut(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.limit() - byteBuffer.position());
    }

    protected void writeZip64CentralDirectory() {
        if (this.zip64Mode == Zip64Mode.Never) {
            return;
        }
        if (!(this.hasUsedZip64 || this.cdOffset < 0xFFFFFFFFL && this.cdLength < 0xFFFFFFFFL && this.entries.size() < 65535)) {
            this.hasUsedZip64 = true;
        }
        if (!this.hasUsedZip64) {
            return;
        }
        long l2 = this.written;
        this.writeOut(ZIP64_EOCD_SIG);
        this.writeOut(ZipEightByteInteger.getBytes(44L));
        this.writeOut(ZipShort.getBytes(45));
        this.writeOut(ZipShort.getBytes(45));
        this.writeOut(LZERO);
        this.writeOut(LZERO);
        byte[] byArray = ZipEightByteInteger.getBytes(this.entries.size());
        this.writeOut(byArray);
        this.writeOut(byArray);
        this.writeOut(ZipEightByteInteger.getBytes(this.cdLength));
        this.writeOut(ZipEightByteInteger.getBytes(this.cdOffset));
        this.writeOut(ZIP64_EOCD_LOC_SIG);
        this.writeOut(LZERO);
        this.writeOut(ZipEightByteInteger.getBytes(l2));
        this.writeOut(ONE);
    }

    protected final void writeOut(byte[] byArray) {
        this.writeOut(byArray, 0, byArray.length);
    }

    protected final void writeOut(byte[] byArray, int n2, int n3) {
        if (this.raf != null) {
            this.raf.write(byArray, n2, n3);
        } else {
            this.out.write(byArray, n2, n3);
        }
    }

    private void deflateUntilInputIsNeeded() {
        while (!this.def.needsInput()) {
            this.deflate();
        }
    }

    private void writeVersionNeededToExtractAndGeneralPurposeBits(int n2, boolean bl2, boolean bl3) {
        int n3 = 10;
        GeneralPurposeBit generalPurposeBit = new GeneralPurposeBit();
        generalPurposeBit.useUTF8ForNames(this.useUTF8Flag || bl2);
        if (n2 == 8 && this.raf == null) {
            n3 = 20;
            generalPurposeBit.useDataDescriptor(true);
        }
        if (bl3) {
            n3 = 45;
        }
        this.writeOut(ZipShort.getBytes(n3));
        this.writeOut(generalPurposeBit.encode());
    }

    public ArchiveEntry createArchiveEntry(File file, String string) {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        return new ZipArchiveEntry(file, string);
    }

    private Zip64ExtendedInformationExtraField getZip64Extra(ZipArchiveEntry zipArchiveEntry) {
        if (this.entry != null) {
            ZipArchiveOutputStream$CurrentEntry.access$502(this.entry, !this.hasUsedZip64);
        }
        this.hasUsedZip64 = true;
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = (Zip64ExtendedInformationExtraField)zipArchiveEntry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        if (zip64ExtendedInformationExtraField == null) {
            zip64ExtendedInformationExtraField = new Zip64ExtendedInformationExtraField();
        }
        zipArchiveEntry.addAsFirstExtraField(zip64ExtendedInformationExtraField);
        return zip64ExtendedInformationExtraField;
    }

    private boolean hasZip64Extra(ZipArchiveEntry zipArchiveEntry) {
        return zipArchiveEntry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID) != null;
    }

    private Zip64Mode getEffectiveZip64Mode(ZipArchiveEntry zipArchiveEntry) {
        if (this.zip64Mode != Zip64Mode.AsNeeded || this.raf != null || zipArchiveEntry.getMethod() != 8 || zipArchiveEntry.getSize() != -1L) {
            return this.zip64Mode;
        }
        return Zip64Mode.Never;
    }

    private ZipEncoding getEntryEncoding(ZipArchiveEntry zipArchiveEntry) {
        boolean bl2 = this.zipEncoding.canEncode(zipArchiveEntry.getName());
        return !bl2 && this.fallbackToUTF8 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
    }

    private ByteBuffer getName(ZipArchiveEntry zipArchiveEntry) {
        return this.getEntryEncoding(zipArchiveEntry).encode(zipArchiveEntry.getName());
    }

    void destroy() {
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }
}

