/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ExplodingInputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.UnshrinkingInputStream;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException$Feature;
import org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream$BoundedInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream$CurrentEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipMethod;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;
import org.apache.commons.compress.utils.IOUtils;

public class ZipArchiveInputStream
extends ArchiveInputStream {
    private final ZipEncoding zipEncoding;
    private final boolean useUnicodeExtraFields;
    private final InputStream in;
    private final Inflater inf = new Inflater(true);
    private final ByteBuffer buf = ByteBuffer.allocate(512);
    private ZipArchiveInputStream$CurrentEntry current = null;
    private boolean closed = false;
    private boolean hitCentralDirectory = false;
    private ByteArrayInputStream lastStoredEntry = null;
    private boolean allowStoredEntriesWithDataDescriptor = false;
    private static final int LFH_LEN = 30;
    private static final int CFH_LEN = 46;
    private static final long TWO_EXP_32 = 0x100000000L;
    private final byte[] LFH_BUF = new byte[30];
    private final byte[] SKIP_BUF = new byte[1024];
    private final byte[] SHORT_BUF = new byte[2];
    private final byte[] WORD_BUF = new byte[4];
    private final byte[] TWO_DWORD_BUF = new byte[16];
    private int entriesRead = 0;
    private static final byte[] LFH = ZipLong.LFH_SIG.getBytes();
    private static final byte[] CFH = ZipLong.CFH_SIG.getBytes();
    private static final byte[] DD = ZipLong.DD_SIG.getBytes();

    public ZipArchiveInputStream(InputStream inputStream) {
        this(inputStream, "UTF8");
    }

    public ZipArchiveInputStream(InputStream inputStream, String string) {
        this(inputStream, string, true);
    }

    public ZipArchiveInputStream(InputStream inputStream, String string, boolean bl2) {
        this(inputStream, string, bl2, false);
    }

    public ZipArchiveInputStream(InputStream inputStream, String string, boolean bl2, boolean bl3) {
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        this.useUnicodeExtraFields = bl2;
        this.in = new PushbackInputStream(inputStream, this.buf.capacity());
        this.allowStoredEntriesWithDataDescriptor = bl3;
        this.buf.limit(0);
    }

    public ZipArchiveEntry getNextZipEntry() {
        boolean bl2 = true;
        if (this.closed || this.hitCentralDirectory) {
            return null;
        }
        if (this.current != null) {
            this.closeEntry();
            bl2 = false;
        }
        try {
            if (bl2) {
                this.readFirstLocalFileHeader(this.LFH_BUF);
            } else {
                this.readFully(this.LFH_BUF);
            }
        }
        catch (EOFException eOFException) {
            return null;
        }
        ZipLong zipLong = new ZipLong(this.LFH_BUF);
        if (zipLong.equals(ZipLong.CFH_SIG) || zipLong.equals(ZipLong.AED_SIG)) {
            this.hitCentralDirectory = true;
            this.skipRemainderOfArchive();
        }
        if (!zipLong.equals(ZipLong.LFH_SIG)) {
            return null;
        }
        int n2 = 4;
        this.current = new ZipArchiveInputStream$CurrentEntry(null);
        int n3 = ZipShort.getValue(this.LFH_BUF, n2);
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setPlatform(n3 >> 8 & 0xF);
        GeneralPurposeBit generalPurposeBit = GeneralPurposeBit.parse(this.LFH_BUF, n2 += 2);
        boolean bl3 = generalPurposeBit.usesUTF8ForNames();
        ZipEncoding zipEncoding = bl3 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        ZipArchiveInputStream$CurrentEntry.access$202(this.current, generalPurposeBit.usesDataDescriptor());
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setGeneralPurposeBit(generalPurposeBit);
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setMethod(ZipShort.getValue(this.LFH_BUF, n2 += 2));
        long l2 = ZipUtil.dosToJavaTime(ZipLong.getValue(this.LFH_BUF, n2 += 2));
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setTime(l2);
        n2 += 4;
        ZipLong zipLong2 = null;
        ZipLong zipLong3 = null;
        if (!ZipArchiveInputStream$CurrentEntry.access$200(this.current)) {
            ZipArchiveInputStream$CurrentEntry.access$100(this.current).setCrc(ZipLong.getValue(this.LFH_BUF, n2));
            zipLong3 = new ZipLong(this.LFH_BUF, n2 += 4);
            zipLong2 = new ZipLong(this.LFH_BUF, n2 += 4);
            n2 += 4;
        } else {
            n2 += 12;
        }
        int n4 = ZipShort.getValue(this.LFH_BUF, n2);
        int n5 = ZipShort.getValue(this.LFH_BUF, n2 += 2);
        n2 += 2;
        byte[] byArray = new byte[n4];
        this.readFully(byArray);
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setName(zipEncoding.decode(byArray), byArray);
        byte[] byArray2 = new byte[n5];
        this.readFully(byArray2);
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setExtra(byArray2);
        if (!bl3 && this.useUnicodeExtraFields) {
            ZipUtil.setNameAndCommentFromExtraFields(ZipArchiveInputStream$CurrentEntry.access$100(this.current), byArray, null);
        }
        this.processZip64Extra(zipLong2, zipLong3);
        if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getCompressedSize() != -1L) {
            if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == ZipMethod.UNSHRINKING.getCode()) {
                ZipArchiveInputStream$CurrentEntry.access$302(this.current, new UnshrinkingInputStream(new ZipArchiveInputStream$BoundedInputStream(this, this.in, ZipArchiveInputStream$CurrentEntry.access$100(this.current).getCompressedSize())));
            } else if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == ZipMethod.IMPLODING.getCode()) {
                ZipArchiveInputStream$CurrentEntry.access$302(this.current, new ExplodingInputStream(ZipArchiveInputStream$CurrentEntry.access$100(this.current).getGeneralPurposeBit().getSlidingDictionarySize(), ZipArchiveInputStream$CurrentEntry.access$100(this.current).getGeneralPurposeBit().getNumberOfShannonFanoTrees(), new ZipArchiveInputStream$BoundedInputStream(this, this.in, ZipArchiveInputStream$CurrentEntry.access$100(this.current).getCompressedSize())));
            }
        }
        ++this.entriesRead;
        return ZipArchiveInputStream$CurrentEntry.access$100(this.current);
    }

    private void readFirstLocalFileHeader(byte[] byArray) {
        this.readFully(byArray);
        ZipLong zipLong = new ZipLong(byArray);
        if (zipLong.equals(ZipLong.DD_SIG)) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException$Feature.SPLITTING);
        }
        if (zipLong.equals(ZipLong.SINGLE_SEGMENT_SPLIT_MARKER)) {
            byte[] byArray2 = new byte[4];
            this.readFully(byArray2);
            System.arraycopy(byArray, 4, byArray, 0, 26);
            System.arraycopy(byArray2, 0, byArray, 26, 4);
        }
    }

    private void processZip64Extra(ZipLong zipLong, ZipLong zipLong2) {
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = (Zip64ExtendedInformationExtraField)ZipArchiveInputStream$CurrentEntry.access$100(this.current).getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        ZipArchiveInputStream$CurrentEntry.access$402(this.current, zip64ExtendedInformationExtraField != null);
        if (!ZipArchiveInputStream$CurrentEntry.access$200(this.current)) {
            if (zip64ExtendedInformationExtraField != null && (zipLong2.equals(ZipLong.ZIP64_MAGIC) || zipLong.equals(ZipLong.ZIP64_MAGIC))) {
                ZipArchiveInputStream$CurrentEntry.access$100(this.current).setCompressedSize(zip64ExtendedInformationExtraField.getCompressedSize().getLongValue());
                ZipArchiveInputStream$CurrentEntry.access$100(this.current).setSize(zip64ExtendedInformationExtraField.getSize().getLongValue());
            } else {
                ZipArchiveInputStream$CurrentEntry.access$100(this.current).setCompressedSize(zipLong2.getValue());
                ZipArchiveInputStream$CurrentEntry.access$100(this.current).setSize(zipLong.getValue());
            }
        }
    }

    public ArchiveEntry getNextEntry() {
        return this.getNextZipEntry();
    }

    public boolean canReadEntryData(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof ZipArchiveEntry) {
            ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)archiveEntry;
            return ZipUtil.canHandleEntryData(zipArchiveEntry) && this.supportsDataDescriptorFor(zipArchiveEntry);
        }
        return false;
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.current == null) {
            return -1;
        }
        if (n2 > byArray.length || n3 < 0 || n2 < 0 || byArray.length - n2 < n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ZipUtil.checkRequestedFeatures(ZipArchiveInputStream$CurrentEntry.access$100(this.current));
        if (!this.supportsDataDescriptorFor(ZipArchiveInputStream$CurrentEntry.access$100(this.current))) {
            throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException$Feature.DATA_DESCRIPTOR, ZipArchiveInputStream$CurrentEntry.access$100(this.current));
        }
        if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == 0) {
            n4 = this.readStored(byArray, n2, n3);
        } else if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == 8) {
            n4 = this.readDeflated(byArray, n2, n3);
        } else if (ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == ZipMethod.UNSHRINKING.getCode() || ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == ZipMethod.IMPLODING.getCode()) {
            n4 = ZipArchiveInputStream$CurrentEntry.access$300(this.current).read(byArray, n2, n3);
        } else {
            throw new UnsupportedZipFeatureException(ZipMethod.getMethodByCode(ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod()), ZipArchiveInputStream$CurrentEntry.access$100(this.current));
        }
        if (n4 >= 0) {
            ZipArchiveInputStream$CurrentEntry.access$500(this.current).update(byArray, n2, n4);
        }
        return n4;
    }

    private int readStored(byte[] byArray, int n2, int n3) {
        int n4;
        if (ZipArchiveInputStream$CurrentEntry.access$200(this.current)) {
            if (this.lastStoredEntry == null) {
                this.readStoredEntry();
            }
            return this.lastStoredEntry.read(byArray, n2, n3);
        }
        long l2 = ZipArchiveInputStream$CurrentEntry.access$100(this.current).getSize();
        if (ZipArchiveInputStream$CurrentEntry.access$600(this.current) >= l2) {
            return -1;
        }
        if (this.buf.position() >= this.buf.limit()) {
            this.buf.position(0);
            n4 = this.in.read(this.buf.array());
            if (n4 == -1) {
                return -1;
            }
            this.buf.limit(n4);
            this.count(n4);
            ZipArchiveInputStream$CurrentEntry.access$714(this.current, n4);
        }
        n4 = Math.min(this.buf.remaining(), n3);
        if (l2 - ZipArchiveInputStream$CurrentEntry.access$600(this.current) < (long)n4) {
            n4 = (int)(l2 - ZipArchiveInputStream$CurrentEntry.access$600(this.current));
        }
        this.buf.get(byArray, n2, n4);
        ZipArchiveInputStream$CurrentEntry.access$614(this.current, n4);
        return n4;
    }

    private int readDeflated(byte[] byArray, int n2, int n3) {
        int n4 = this.readFromInflater(byArray, n2, n3);
        if (n4 <= 0) {
            if (this.inf.finished()) {
                return -1;
            }
            if (this.inf.needsDictionary()) {
                throw new ZipException("This archive needs a preset dictionary which is not supported by Commons Compress.");
            }
            if (n4 == -1) {
                throw new IOException("Truncated ZIP file");
            }
        }
        return n4;
    }

    private int readFromInflater(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        do {
            if (this.inf.needsInput()) {
                int n5 = this.fill();
                if (n5 > 0) {
                    ZipArchiveInputStream$CurrentEntry.access$714(this.current, this.buf.limit());
                } else {
                    if (n5 != -1) break;
                    return -1;
                }
            }
            try {
                n4 = this.inf.inflate(byArray, n2, n3);
            }
            catch (DataFormatException dataFormatException) {
                throw (IOException)new ZipException(dataFormatException.getMessage()).initCause(dataFormatException);
            }
        } while (n4 == 0 && this.inf.needsInput());
        return n4;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
            this.inf.end();
        }
    }

    public long skip(long l2) {
        if (l2 >= 0L) {
            long l3;
            int n2;
            for (l3 = 0L; l3 < l2; l3 += (long)n2) {
                long l4 = l2 - l3;
                n2 = this.read(this.SKIP_BUF, 0, (int)((long)this.SKIP_BUF.length > l4 ? l4 : (long)this.SKIP_BUF.length));
                if (n2 != -1) continue;
                return l3;
            }
            return l3;
        }
        throw new IllegalArgumentException();
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < ZipArchiveOutputStream.LFH_SIG.length) {
            return false;
        }
        return ZipArchiveInputStream.checksig(byArray, ZipArchiveOutputStream.LFH_SIG) || ZipArchiveInputStream.checksig(byArray, ZipArchiveOutputStream.EOCD_SIG) || ZipArchiveInputStream.checksig(byArray, ZipArchiveOutputStream.DD_SIG) || ZipArchiveInputStream.checksig(byArray, ZipLong.SINGLE_SEGMENT_SPLIT_MARKER.getBytes());
    }

    private static boolean checksig(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < byArray2.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }

    private void closeEntry() {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.current == null) {
            return;
        }
        if (ZipArchiveInputStream$CurrentEntry.access$700(this.current) <= ZipArchiveInputStream$CurrentEntry.access$100(this.current).getCompressedSize() && !ZipArchiveInputStream$CurrentEntry.access$200(this.current)) {
            this.drainCurrentEntryData();
        } else {
            this.skip(Long.MAX_VALUE);
            long l2 = ZipArchiveInputStream$CurrentEntry.access$100(this.current).getMethod() == 8 ? this.getBytesInflated() : ZipArchiveInputStream$CurrentEntry.access$600(this.current);
            int n2 = (int)(ZipArchiveInputStream$CurrentEntry.access$700(this.current) - l2);
            if (n2 > 0) {
                this.pushback(this.buf.array(), this.buf.limit() - n2, n2);
            }
        }
        if (this.lastStoredEntry == null && ZipArchiveInputStream$CurrentEntry.access$200(this.current)) {
            this.readDataDescriptor();
        }
        this.inf.reset();
        this.buf.clear().flip();
        this.current = null;
        this.lastStoredEntry = null;
    }

    private void drainCurrentEntryData() {
        long l2;
        for (long i2 = ZipArchiveInputStream$CurrentEntry.access$100(this.current).getCompressedSize() - ZipArchiveInputStream$CurrentEntry.access$700(this.current); i2 > 0L; i2 -= l2) {
            l2 = this.in.read(this.buf.array(), 0, (int)Math.min((long)this.buf.capacity(), i2));
            if (l2 < 0L) {
                throw new EOFException("Truncated ZIP entry: " + ZipArchiveInputStream$CurrentEntry.access$100(this.current).getName());
            }
            this.count(l2);
        }
    }

    private long getBytesInflated() {
        long l2 = this.inf.getBytesRead();
        if (ZipArchiveInputStream$CurrentEntry.access$700(this.current) >= 0x100000000L) {
            while (l2 + 0x100000000L <= ZipArchiveInputStream$CurrentEntry.access$700(this.current)) {
                l2 += 0x100000000L;
            }
        }
        return l2;
    }

    private int fill() {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        int n2 = this.in.read(this.buf.array());
        if (n2 > 0) {
            this.buf.limit(n2);
            this.count(this.buf.limit());
            this.inf.setInput(this.buf.array(), 0, this.buf.limit());
        }
        return n2;
    }

    private void readFully(byte[] byArray) {
        int n2 = IOUtils.readFully(this.in, byArray);
        this.count(n2);
        if (n2 < byArray.length) {
            throw new EOFException();
        }
    }

    private void readDataDescriptor() {
        this.readFully(this.WORD_BUF);
        ZipLong zipLong = new ZipLong(this.WORD_BUF);
        if (ZipLong.DD_SIG.equals(zipLong)) {
            this.readFully(this.WORD_BUF);
            zipLong = new ZipLong(this.WORD_BUF);
        }
        ZipArchiveInputStream$CurrentEntry.access$100(this.current).setCrc(zipLong.getValue());
        this.readFully(this.TWO_DWORD_BUF);
        ZipLong zipLong2 = new ZipLong(this.TWO_DWORD_BUF, 8);
        if (zipLong2.equals(ZipLong.CFH_SIG) || zipLong2.equals(ZipLong.LFH_SIG)) {
            this.pushback(this.TWO_DWORD_BUF, 8, 8);
            ZipArchiveInputStream$CurrentEntry.access$100(this.current).setCompressedSize(ZipLong.getValue(this.TWO_DWORD_BUF));
            ZipArchiveInputStream$CurrentEntry.access$100(this.current).setSize(ZipLong.getValue(this.TWO_DWORD_BUF, 4));
        } else {
            ZipArchiveInputStream$CurrentEntry.access$100(this.current).setCompressedSize(ZipEightByteInteger.getLongValue(this.TWO_DWORD_BUF));
            ZipArchiveInputStream$CurrentEntry.access$100(this.current).setSize(ZipEightByteInteger.getLongValue(this.TWO_DWORD_BUF, 8));
        }
    }

    private boolean supportsDataDescriptorFor(ZipArchiveEntry zipArchiveEntry) {
        return !zipArchiveEntry.getGeneralPurposeBit().usesDataDescriptor() || this.allowStoredEntriesWithDataDescriptor && zipArchiveEntry.getMethod() == 0 || zipArchiveEntry.getMethod() == 8;
    }

    private void readStoredEntry() {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        boolean bl2 = false;
        int n4 = n2 = ZipArchiveInputStream$CurrentEntry.access$400(this.current) ? 20 : 12;
        while (!bl2) {
            int n5 = this.in.read(this.buf.array(), n3, 512 - n3);
            if (n5 <= 0) {
                throw new IOException("Truncated ZIP file");
            }
            if (n5 + n3 < 4) {
                n3 += n5;
                continue;
            }
            bl2 = this.bufferContainsSignature(byteArrayOutputStream, n3, n5, n2);
            if (bl2) continue;
            n3 = this.cacheBytesRead(byteArrayOutputStream, n3, n5, n2);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.lastStoredEntry = new ByteArrayInputStream(byArray);
    }

    private boolean bufferContainsSignature(ByteArrayOutputStream byteArrayOutputStream, int n2, int n3, int n4) {
        boolean bl2 = false;
        int n5 = 0;
        for (int i2 = 0; !bl2 && i2 < n3 - 4; ++i2) {
            if (this.buf.array()[i2] != LFH[0] || this.buf.array()[i2 + 1] != LFH[1]) continue;
            if (this.buf.array()[i2 + 2] == LFH[2] && this.buf.array()[i2 + 3] == LFH[3] || this.buf.array()[i2] == CFH[2] && this.buf.array()[i2 + 3] == CFH[3]) {
                n5 = n2 + n3 - i2 - n4;
                bl2 = true;
            } else if (this.buf.array()[i2 + 2] == DD[2] && this.buf.array()[i2 + 3] == DD[3]) {
                n5 = n2 + n3 - i2;
                bl2 = true;
            }
            if (!bl2) continue;
            this.pushback(this.buf.array(), n2 + n3 - n5, n5);
            byteArrayOutputStream.write(this.buf.array(), 0, i2);
            this.readDataDescriptor();
        }
        return bl2;
    }

    private int cacheBytesRead(ByteArrayOutputStream byteArrayOutputStream, int n2, int n3, int n4) {
        int n5 = n2 + n3 - n4 - 3;
        if (n5 > 0) {
            byteArrayOutputStream.write(this.buf.array(), 0, n5);
            System.arraycopy(this.buf.array(), n5, this.buf.array(), 0, n4 + 3);
            n2 = n4 + 3;
        } else {
            n2 += n3;
        }
        return n2;
    }

    private void pushback(byte[] byArray, int n2, int n3) {
        ((PushbackInputStream)this.in).unread(byArray, n2, n3);
        this.pushedBackBytes(n3);
    }

    private void skipRemainderOfArchive() {
        this.realSkip(this.entriesRead * 46 - 30);
        this.findEocdRecord();
        this.realSkip(16L);
        this.readFully(this.SHORT_BUF);
        this.realSkip(ZipShort.getValue(this.SHORT_BUF));
    }

    private void findEocdRecord() {
        int n2 = -1;
        boolean bl2 = false;
        while (bl2 || (n2 = this.readOneByte()) > -1) {
            bl2 = false;
            if (!this.isFirstByteOfEocdSig(n2)) continue;
            n2 = this.readOneByte();
            if (n2 != ZipArchiveOutputStream.EOCD_SIG[1]) {
                if (n2 == -1) break;
                bl2 = this.isFirstByteOfEocdSig(n2);
                continue;
            }
            n2 = this.readOneByte();
            if (n2 != ZipArchiveOutputStream.EOCD_SIG[2]) {
                if (n2 == -1) break;
                bl2 = this.isFirstByteOfEocdSig(n2);
                continue;
            }
            n2 = this.readOneByte();
            if (n2 == -1 || n2 == ZipArchiveOutputStream.EOCD_SIG[3]) break;
            bl2 = this.isFirstByteOfEocdSig(n2);
        }
    }

    private void realSkip(long l2) {
        if (l2 >= 0L) {
            int n2;
            for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
                long l3 = l2 - i2;
                n2 = this.in.read(this.SKIP_BUF, 0, (int)((long)this.SKIP_BUF.length > l3 ? l3 : (long)this.SKIP_BUF.length));
                if (n2 == -1) {
                    return;
                }
                this.count(n2);
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    private int readOneByte() {
        int n2 = this.in.read();
        if (n2 != -1) {
            this.count(1);
        }
        return n2;
    }

    private boolean isFirstByteOfEocdSig(int n2) {
        return n2 == ZipArchiveOutputStream.EOCD_SIG[0];
    }

    static /* synthetic */ void access$800(ZipArchiveInputStream zipArchiveInputStream, int n2) {
        zipArchiveInputStream.count(n2);
    }

    static /* synthetic */ ZipArchiveInputStream$CurrentEntry access$900(ZipArchiveInputStream zipArchiveInputStream) {
        return zipArchiveInputStream.current;
    }

    static /* synthetic */ void access$1000(ZipArchiveInputStream zipArchiveInputStream, int n2) {
        zipArchiveInputStream.count(n2);
    }
}

