/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.Serializable;
import java.math.BigInteger;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;

public class X7875_NewUnix
implements Serializable,
Cloneable,
ZipExtraField {
    private static final ZipShort HEADER_ID = new ZipShort(30837);
    private static final BigInteger ONE_THOUSAND = BigInteger.valueOf(1000L);
    private static final long serialVersionUID = 1L;
    private int version = 1;
    private BigInteger uid;
    private BigInteger gid;

    public X7875_NewUnix() {
        this.reset();
    }

    public ZipShort getHeaderId() {
        return HEADER_ID;
    }

    public long getUID() {
        return ZipUtil.bigToLong(this.uid);
    }

    public long getGID() {
        return ZipUtil.bigToLong(this.gid);
    }

    public void setUID(long l2) {
        this.uid = ZipUtil.longToBig(l2);
    }

    public void setGID(long l2) {
        this.gid = ZipUtil.longToBig(l2);
    }

    public ZipShort getLocalFileDataLength() {
        int n2 = X7875_NewUnix.trimLeadingZeroesForceMinLength(this.uid.toByteArray()).length;
        int n3 = X7875_NewUnix.trimLeadingZeroesForceMinLength(this.gid.toByteArray()).length;
        return new ZipShort(3 + n2 + n3);
    }

    public ZipShort getCentralDirectoryLength() {
        return this.getLocalFileDataLength();
    }

    public byte[] getLocalFileDataData() {
        byte[] byArray = this.uid.toByteArray();
        byte[] byArray2 = this.gid.toByteArray();
        byArray = X7875_NewUnix.trimLeadingZeroesForceMinLength(byArray);
        byArray2 = X7875_NewUnix.trimLeadingZeroesForceMinLength(byArray2);
        byte[] byArray3 = new byte[3 + byArray.length + byArray2.length];
        ZipUtil.reverse(byArray);
        ZipUtil.reverse(byArray2);
        int n2 = 0;
        byArray3[n2++] = ZipUtil.unsignedIntToSignedByte(this.version);
        byArray3[n2++] = ZipUtil.unsignedIntToSignedByte(byArray.length);
        System.arraycopy(byArray, 0, byArray3, n2, byArray.length);
        n2 += byArray.length;
        byArray3[n2++] = ZipUtil.unsignedIntToSignedByte(byArray2.length);
        System.arraycopy(byArray2, 0, byArray3, n2, byArray2.length);
        return byArray3;
    }

    public byte[] getCentralDirectoryData() {
        return this.getLocalFileDataData();
    }

    public void parseFromLocalFileData(byte[] byArray, int n2, int n3) {
        this.reset();
        this.version = ZipUtil.signedByteToUnsignedInt(byArray[n2++]);
        int n4 = ZipUtil.signedByteToUnsignedInt(byArray[n2++]);
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n2, byArray2, 0, n4);
        n2 += n4;
        this.uid = new BigInteger(1, ZipUtil.reverse(byArray2));
        int n5 = ZipUtil.signedByteToUnsignedInt(byArray[n2++]);
        byte[] byArray3 = new byte[n5];
        System.arraycopy(byArray, n2, byArray3, 0, n5);
        this.gid = new BigInteger(1, ZipUtil.reverse(byArray3));
    }

    public void parseFromCentralDirectoryData(byte[] byArray, int n2, int n3) {
        this.reset();
        this.parseFromLocalFileData(byArray, n2, n3);
    }

    private void reset() {
        this.uid = ONE_THOUSAND;
        this.gid = ONE_THOUSAND;
    }

    public String toString() {
        return "0x7875 Zip Extra Field: UID=" + this.uid + " GID=" + this.gid;
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object instanceof X7875_NewUnix) {
            X7875_NewUnix x7875_NewUnix = (X7875_NewUnix)object;
            return this.version == x7875_NewUnix.version && this.uid.equals(x7875_NewUnix.uid) && this.gid.equals(x7875_NewUnix.gid);
        }
        return false;
    }

    public int hashCode() {
        int n2 = -1234567 * this.version;
        n2 ^= Integer.rotateLeft(this.uid.hashCode(), 16);
        return n2 ^= this.gid.hashCode();
    }

    static byte[] trimLeadingZeroesForceMinLength(byte[] byArray) {
        if (byArray == null) {
            return byArray;
        }
        int n2 = 0;
        for (byte by2 : byArray) {
            if (by2 != 0) break;
            ++n2;
        }
        boolean bl2 = true;
        byte[] byArray2 = new byte[Math.max(1, byArray.length - n2)];
        int n3 = byArray2.length - (byArray.length - n2);
        System.arraycopy(byArray, n2, byArray2, n3, byArray2.length - n3);
        return byArray2;
    }
}

