/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.compress.archivers.zip.Simple8BitZipEncoding$Simple8BitChar;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;

class Simple8BitZipEncoding
implements ZipEncoding {
    private final char[] highChars;
    private final List<Simple8BitZipEncoding$Simple8BitChar> reverseMapping;

    public Simple8BitZipEncoding(char[] cArray) {
        this.highChars = (char[])cArray.clone();
        ArrayList<Simple8BitZipEncoding$Simple8BitChar> arrayList = new ArrayList<Simple8BitZipEncoding$Simple8BitChar>(this.highChars.length);
        byte by2 = 127;
        for (char c2 : this.highChars) {
            by2 = (byte)(by2 + 1);
            arrayList.add(new Simple8BitZipEncoding$Simple8BitChar(by2, c2));
        }
        Collections.sort(arrayList);
        this.reverseMapping = Collections.unmodifiableList(arrayList);
    }

    public char decodeByte(byte by2) {
        if (by2 >= 0) {
            return (char)by2;
        }
        return this.highChars[128 + by2];
    }

    public boolean canEncodeChar(char c2) {
        if (c2 >= '\u0000' && c2 < '\u0080') {
            return true;
        }
        Simple8BitZipEncoding$Simple8BitChar simple8BitZipEncoding$Simple8BitChar = this.encodeHighChar(c2);
        return simple8BitZipEncoding$Simple8BitChar != null;
    }

    public boolean pushEncodedChar(ByteBuffer byteBuffer, char c2) {
        if (c2 >= '\u0000' && c2 < '\u0080') {
            byteBuffer.put((byte)c2);
            return true;
        }
        Simple8BitZipEncoding$Simple8BitChar simple8BitZipEncoding$Simple8BitChar = this.encodeHighChar(c2);
        if (simple8BitZipEncoding$Simple8BitChar == null) {
            return false;
        }
        byteBuffer.put(simple8BitZipEncoding$Simple8BitChar.code);
        return true;
    }

    private Simple8BitZipEncoding$Simple8BitChar encodeHighChar(char c2) {
        int n2 = 0;
        int n3 = this.reverseMapping.size();
        while (n3 > n2) {
            int n4 = n2 + (n3 - n2) / 2;
            Simple8BitZipEncoding$Simple8BitChar simple8BitZipEncoding$Simple8BitChar = this.reverseMapping.get(n4);
            if (simple8BitZipEncoding$Simple8BitChar.unicode == c2) {
                return simple8BitZipEncoding$Simple8BitChar;
            }
            if (simple8BitZipEncoding$Simple8BitChar.unicode < c2) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4;
        }
        if (n2 >= this.reverseMapping.size()) {
            return null;
        }
        Simple8BitZipEncoding$Simple8BitChar simple8BitZipEncoding$Simple8BitChar = this.reverseMapping.get(n2);
        if (simple8BitZipEncoding$Simple8BitChar.unicode != c2) {
            return null;
        }
        return simple8BitZipEncoding$Simple8BitChar;
    }

    public boolean canEncode(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (this.canEncodeChar(c2)) continue;
            return false;
        }
        return true;
    }

    public ByteBuffer encode(String string) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(string.length() + 6 + (string.length() + 1) / 2);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (byteBuffer.remaining() < 6) {
                byteBuffer = ZipEncodingHelper.growBuffer(byteBuffer, byteBuffer.position() + 6);
            }
            if (this.pushEncodedChar(byteBuffer, c2)) continue;
            ZipEncodingHelper.appendSurrogate(byteBuffer, c2);
        }
        byteBuffer.limit(byteBuffer.position());
        byteBuffer.rewind();
        return byteBuffer;
    }

    public String decode(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            cArray[i2] = this.decodeByte(byArray[i2]);
        }
        return new String(cArray);
    }
}

