/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.InputStream;
import org.apache.commons.compress.archivers.zip.BinaryTree;
import org.apache.commons.compress.archivers.zip.BitStream;
import org.apache.commons.compress.archivers.zip.CircularBuffer;

class ExplodingInputStream
extends InputStream {
    private final InputStream in;
    private BitStream bits;
    private final int dictionarySize;
    private final int numberOfTrees;
    private final int minimumMatchLength;
    private BinaryTree literalTree;
    private BinaryTree lengthTree;
    private BinaryTree distanceTree;
    private final CircularBuffer buffer = new CircularBuffer(32768);

    public ExplodingInputStream(int n2, int n3, InputStream inputStream) {
        if (n2 != 4096 && n2 != 8192) {
            throw new IllegalArgumentException("The dictionary size must be 4096 or 8192");
        }
        if (n3 != 2 && n3 != 3) {
            throw new IllegalArgumentException("The number of trees must be 2 or 3");
        }
        this.dictionarySize = n2;
        this.numberOfTrees = n3;
        this.minimumMatchLength = n3;
        this.in = inputStream;
    }

    private void init() {
        if (this.bits == null) {
            if (this.numberOfTrees == 3) {
                this.literalTree = BinaryTree.decode(this.in, 256);
            }
            this.lengthTree = BinaryTree.decode(this.in, 64);
            this.distanceTree = BinaryTree.decode(this.in, 64);
            this.bits = new BitStream(this.in);
        }
    }

    public int read() {
        if (!this.buffer.available()) {
            this.fillBuffer();
        }
        return this.buffer.get();
    }

    private void fillBuffer() {
        this.init();
        int n2 = this.bits.nextBit();
        if (n2 == 1) {
            int n3 = this.literalTree != null ? this.literalTree.read(this.bits) : this.bits.nextBits(8);
            if (n3 == -1) {
                return;
            }
            this.buffer.put(n3);
        } else if (n2 == 0) {
            int n4 = this.dictionarySize == 4096 ? 6 : 7;
            int n5 = this.bits.nextBits(n4);
            int n6 = this.distanceTree.read(this.bits);
            if (n6 == -1 && n5 <= 0) {
                return;
            }
            int n7 = n6 << n4 | n5;
            int n8 = this.lengthTree.read(this.bits);
            if (n8 == 63) {
                n8 += this.bits.nextBits(8);
            }
            this.buffer.copy(n7 + 1, n8 += this.minimumMatchLength);
        }
    }
}

