/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

class CircularBuffer {
    private final int size;
    private final byte[] buffer;
    private int readIndex;
    private int writeIndex;

    CircularBuffer(int n2) {
        this.size = n2;
        this.buffer = new byte[n2];
    }

    public boolean available() {
        return this.readIndex != this.writeIndex;
    }

    public void put(int n2) {
        this.buffer[this.writeIndex] = (byte)n2;
        this.writeIndex = (this.writeIndex + 1) % this.size;
    }

    public int get() {
        if (this.available()) {
            byte by2 = this.buffer[this.readIndex];
            this.readIndex = (this.readIndex + 1) % this.size;
            return by2 & 0xFF;
        }
        return -1;
    }

    public void copy(int n2, int n3) {
        int n4 = this.writeIndex - n2;
        int n5 = n4 + n3;
        for (int i2 = n4; i2 < n5; ++i2) {
            this.buffer[this.writeIndex] = this.buffer[(i2 + this.size) % this.size];
            this.writeIndex = (this.writeIndex + 1) % this.size;
        }
    }
}

