/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.InputStream;

class BitStream {
    private final InputStream in;
    private long bitCache;
    private int bitCacheSize;
    private static final int[] MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};

    BitStream(InputStream inputStream) {
        this.in = inputStream;
    }

    private boolean fillCache() {
        long l2;
        boolean bl2 = false;
        while (this.bitCacheSize <= 56 && (l2 = (long)this.in.read()) != -1L) {
            bl2 = true;
            this.bitCache |= l2 << this.bitCacheSize;
            this.bitCacheSize += 8;
        }
        return bl2;
    }

    int nextBit() {
        if (this.bitCacheSize == 0 && !this.fillCache()) {
            return -1;
        }
        int n2 = (int)(this.bitCache & 1L);
        this.bitCache >>>= 1;
        --this.bitCacheSize;
        return n2;
    }

    int nextBits(int n2) {
        if (this.bitCacheSize < n2 && !this.fillCache()) {
            return -1;
        }
        int n3 = (int)(this.bitCache & (long)MASKS[n2]);
        this.bitCache >>>= n2;
        this.bitCacheSize -= n2;
        return n3;
    }

    int nextByte() {
        return this.nextBits(8);
    }
}

