/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.utils.CountingOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarArchiveOutputStream
extends ArchiveOutputStream {
    public static final int LONGFILE_ERROR = 0;
    public static final int LONGFILE_TRUNCATE = 1;
    public static final int LONGFILE_GNU = 2;
    public static final int LONGFILE_POSIX = 3;
    public static final int BIGNUMBER_ERROR = 0;
    public static final int BIGNUMBER_STAR = 1;
    public static final int BIGNUMBER_POSIX = 2;
    private long currSize;
    private String currName;
    private long currBytes;
    private final byte[] recordBuf;
    private int assemLen;
    private final byte[] assemBuf;
    private int longFileMode = 0;
    private int bigNumberMode = 0;
    private int recordsWritten;
    private final int recordsPerBlock;
    private final int recordSize;
    private boolean closed = false;
    private boolean haveUnclosedEntry = false;
    private boolean finished = false;
    private final OutputStream out;
    private final ZipEncoding encoding;
    private boolean addPaxHeadersForNonAsciiNames = false;
    private static final ZipEncoding ASCII = ZipEncodingHelper.getZipEncoding("ASCII");

    public TarArchiveOutputStream(OutputStream outputStream) {
        this(outputStream, 10240, 512);
    }

    public TarArchiveOutputStream(OutputStream outputStream, String string) {
        this(outputStream, 10240, 512, string);
    }

    public TarArchiveOutputStream(OutputStream outputStream, int n2) {
        this(outputStream, n2, 512);
    }

    public TarArchiveOutputStream(OutputStream outputStream, int n2, String string) {
        this(outputStream, n2, 512, string);
    }

    public TarArchiveOutputStream(OutputStream outputStream, int n2, int n3) {
        this(outputStream, n2, n3, null);
    }

    public TarArchiveOutputStream(OutputStream outputStream, int n2, int n3, String string) {
        this.out = new CountingOutputStream(outputStream);
        this.encoding = ZipEncodingHelper.getZipEncoding(string);
        this.assemLen = 0;
        this.assemBuf = new byte[n3];
        this.recordBuf = new byte[n3];
        this.recordSize = n3;
        this.recordsPerBlock = n2 / n3;
    }

    public void setLongFileMode(int n2) {
        this.longFileMode = n2;
    }

    public void setBigNumberMode(int n2) {
        this.bigNumberMode = n2;
    }

    public void setAddPaxHeadersForNonAsciiNames(boolean bl2) {
        this.addPaxHeadersForNonAsciiNames = bl2;
    }

    @Override
    @Deprecated
    public int getCount() {
        return (int)this.getBytesWritten();
    }

    @Override
    public long getBytesWritten() {
        return ((CountingOutputStream)this.out).getBytesWritten();
    }

    @Override
    public void finish() {
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        if (this.haveUnclosedEntry) {
            throw new IOException("This archives contains unclosed entries.");
        }
        this.writeEOFRecord();
        this.writeEOFRecord();
        this.padAsNeeded();
        this.out.flush();
        this.finished = true;
    }

    @Override
    public void close() {
        if (!this.finished) {
            this.finish();
        }
        if (!this.closed) {
            this.out.close();
            this.closed = true;
        }
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    @Override
    public void putArchiveEntry(ArchiveEntry archiveEntry) {
        boolean bl2;
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)archiveEntry;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = tarArchiveEntry.getName();
        boolean bl3 = this.handleLongName(string, hashMap, "path", (byte)76, "file name");
        String string2 = tarArchiveEntry.getLinkName();
        boolean bl4 = bl2 = string2 != null && string2.length() > 0 && this.handleLongName(string2, hashMap, "linkpath", (byte)75, "link name");
        if (this.bigNumberMode == 2) {
            this.addPaxHeadersForBigNumbers(hashMap, tarArchiveEntry);
        } else if (this.bigNumberMode != 1) {
            this.failForBigNumbers(tarArchiveEntry);
        }
        if (this.addPaxHeadersForNonAsciiNames && !bl3 && !ASCII.canEncode(string)) {
            hashMap.put("path", string);
        }
        if (this.addPaxHeadersForNonAsciiNames && !bl2 && (tarArchiveEntry.isLink() || tarArchiveEntry.isSymbolicLink()) && !ASCII.canEncode(string2)) {
            hashMap.put("linkpath", string2);
        }
        if (hashMap.size() > 0) {
            this.writePaxHeaders(string, hashMap);
        }
        tarArchiveEntry.writeEntryHeader(this.recordBuf, this.encoding, this.bigNumberMode == 1);
        this.writeRecord(this.recordBuf);
        this.currBytes = 0L;
        this.currSize = tarArchiveEntry.isDirectory() ? 0L : tarArchiveEntry.getSize();
        this.currName = string;
        this.haveUnclosedEntry = true;
    }

    @Override
    public void closeArchiveEntry() {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (!this.haveUnclosedEntry) {
            throw new IOException("No current entry to close");
        }
        if (this.assemLen > 0) {
            for (int i2 = this.assemLen; i2 < this.assemBuf.length; ++i2) {
                this.assemBuf[i2] = 0;
            }
            this.writeRecord(this.assemBuf);
            this.currBytes += (long)this.assemLen;
            this.assemLen = 0;
        }
        if (this.currBytes < this.currSize) {
            throw new IOException("entry '" + this.currName + "' closed at '" + this.currBytes + "' before the '" + this.currSize + "' bytes specified in the header were written");
        }
        this.haveUnclosedEntry = false;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        int n4;
        if (!this.haveUnclosedEntry) {
            throw new IllegalStateException("No current tar entry");
        }
        if (this.currBytes + (long)n3 > this.currSize) {
            throw new IOException("request to write '" + n3 + "' bytes exceeds size in header of '" + this.currSize + "' bytes for entry '" + this.currName + "'");
        }
        if (this.assemLen > 0) {
            if (this.assemLen + n3 >= this.recordBuf.length) {
                n4 = this.recordBuf.length - this.assemLen;
                System.arraycopy(this.assemBuf, 0, this.recordBuf, 0, this.assemLen);
                System.arraycopy(byArray, n2, this.recordBuf, this.assemLen, n4);
                this.writeRecord(this.recordBuf);
                this.currBytes += (long)this.recordBuf.length;
                n2 += n4;
                n3 -= n4;
                this.assemLen = 0;
            } else {
                System.arraycopy(byArray, n2, this.assemBuf, this.assemLen, n3);
                n2 += n3;
                this.assemLen += n3;
                n3 = 0;
            }
        }
        while (n3 > 0) {
            if (n3 < this.recordBuf.length) {
                System.arraycopy(byArray, n2, this.assemBuf, this.assemLen, n3);
                this.assemLen += n3;
                break;
            }
            this.writeRecord(byArray, n2);
            n4 = this.recordBuf.length;
            this.currBytes += (long)n4;
            n3 -= n4;
            n2 += n4;
        }
    }

    void writePaxHeaders(String string, Map<String, String> map) {
        String string2 = "./PaxHeaders.X/" + this.stripTo7Bits(string);
        if (string2.length() >= 100) {
            string2 = string2.substring(0, 99);
        }
        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(string2, 120);
        StringWriter stringWriter = new StringWriter();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string3 = entry.getKey();
            String string4 = entry.getValue();
            int n2 = string3.length() + string4.length() + 3 + 2;
            String string5 = n2 + " " + string3 + "=" + string4 + "\n";
            int n3 = string5.getBytes("UTF-8").length;
            while (n2 != n3) {
                n2 = n3;
                string5 = n2 + " " + string3 + "=" + string4 + "\n";
                n3 = string5.getBytes("UTF-8").length;
            }
            stringWriter.write(string5);
        }
        Object object = stringWriter.toString().getBytes("UTF-8");
        tarArchiveEntry.setSize(((Object)object).length);
        this.putArchiveEntry(tarArchiveEntry);
        this.write((byte[])object);
        this.closeArchiveEntry();
    }

    private String stripTo7Bits(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = (char)(string.charAt(i2) & 0x7F);
            if (this.shouldBeReplaced(c2)) {
                stringBuilder.append("_");
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private boolean shouldBeReplaced(char c2) {
        return c2 == '\u0000' || c2 == '/' || c2 == '\\';
    }

    private void writeEOFRecord() {
        Arrays.fill(this.recordBuf, (byte)0);
        this.writeRecord(this.recordBuf);
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public ArchiveEntry createArchiveEntry(File file, String string) {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        return new TarArchiveEntry(file, string);
    }

    private void writeRecord(byte[] byArray) {
        if (byArray.length != this.recordSize) {
            throw new IOException("record to write has length '" + byArray.length + "' which is not the record size of '" + this.recordSize + "'");
        }
        this.out.write(byArray);
        ++this.recordsWritten;
    }

    private void writeRecord(byte[] byArray, int n2) {
        if (n2 + this.recordSize > byArray.length) {
            throw new IOException("record has length '" + byArray.length + "' with offset '" + n2 + "' which is less than the record size of '" + this.recordSize + "'");
        }
        this.out.write(byArray, n2, this.recordSize);
        ++this.recordsWritten;
    }

    private void padAsNeeded() {
        int n2 = this.recordsWritten % this.recordsPerBlock;
        if (n2 != 0) {
            for (int i2 = n2; i2 < this.recordsPerBlock; ++i2) {
                this.writeEOFRecord();
            }
        }
    }

    private void addPaxHeadersForBigNumbers(Map<String, String> map, TarArchiveEntry tarArchiveEntry) {
        this.addPaxHeaderForBigNumber(map, "size", tarArchiveEntry.getSize(), 0x1FFFFFFFFL);
        this.addPaxHeaderForBigNumber(map, "gid", tarArchiveEntry.getGroupId(), 0x1FFFFFL);
        this.addPaxHeaderForBigNumber(map, "mtime", tarArchiveEntry.getModTime().getTime() / 1000L, 0x1FFFFFFFFL);
        this.addPaxHeaderForBigNumber(map, "uid", tarArchiveEntry.getUserId(), 0x1FFFFFL);
        this.addPaxHeaderForBigNumber(map, "SCHILY.devmajor", tarArchiveEntry.getDevMajor(), 0x1FFFFFL);
        this.addPaxHeaderForBigNumber(map, "SCHILY.devminor", tarArchiveEntry.getDevMinor(), 0x1FFFFFL);
        this.failForBigNumber("mode", tarArchiveEntry.getMode(), 0x1FFFFFL);
    }

    private void addPaxHeaderForBigNumber(Map<String, String> map, String string, long l2, long l3) {
        if (l2 < 0L || l2 > l3) {
            map.put(string, String.valueOf(l2));
        }
    }

    private void failForBigNumbers(TarArchiveEntry tarArchiveEntry) {
        this.failForBigNumber("entry size", tarArchiveEntry.getSize(), 0x1FFFFFFFFL);
        this.failForBigNumber("group id", tarArchiveEntry.getGroupId(), 0x1FFFFFL);
        this.failForBigNumber("last modification time", tarArchiveEntry.getModTime().getTime() / 1000L, 0x1FFFFFFFFL);
        this.failForBigNumber("user id", tarArchiveEntry.getUserId(), 0x1FFFFFL);
        this.failForBigNumber("mode", tarArchiveEntry.getMode(), 0x1FFFFFL);
        this.failForBigNumber("major device number", tarArchiveEntry.getDevMajor(), 0x1FFFFFL);
        this.failForBigNumber("minor device number", tarArchiveEntry.getDevMinor(), 0x1FFFFFL);
    }

    private void failForBigNumber(String string, long l2, long l3) {
        if (l2 < 0L || l2 > l3) {
            throw new RuntimeException(string + " '" + l2 + "' is too big ( > " + l3 + " )");
        }
    }

    private boolean handleLongName(String string, Map<String, String> map, String string2, byte by2, String string3) {
        ByteBuffer byteBuffer = this.encoding.encode(string);
        int n2 = byteBuffer.limit() - byteBuffer.position();
        if (n2 >= 100) {
            if (this.longFileMode == 3) {
                map.put(string2, string);
                return true;
            }
            if (this.longFileMode == 2) {
                TarArchiveEntry tarArchiveEntry = new TarArchiveEntry("././@LongLink", by2);
                tarArchiveEntry.setSize(n2 + 1);
                this.putArchiveEntry(tarArchiveEntry);
                this.write(byteBuffer.array(), byteBuffer.arrayOffset(), n2);
                this.write(0);
                this.closeArchiveEntry();
            } else if (this.longFileMode != 1) {
                throw new RuntimeException(string3 + " '" + string + "' is too long ( > " + 100 + " bytes)");
            }
        }
        return false;
    }
}

