/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.tar;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveSparseEntry;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.apache.commons.compress.utils.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarArchiveInputStream
extends ArchiveInputStream {
    private static final int SMALL_BUFFER_SIZE = 256;
    private final byte[] SMALL_BUF = new byte[256];
    private final int recordSize;
    private final int blockSize;
    private boolean hasHitEOF;
    private long entrySize;
    private long entryOffset;
    private final InputStream is;
    private TarArchiveEntry currEntry;
    private final ZipEncoding encoding;

    public TarArchiveInputStream(InputStream inputStream) {
        this(inputStream, 10240, 512);
    }

    public TarArchiveInputStream(InputStream inputStream, String string) {
        this(inputStream, 10240, 512, string);
    }

    public TarArchiveInputStream(InputStream inputStream, int n2) {
        this(inputStream, n2, 512);
    }

    public TarArchiveInputStream(InputStream inputStream, int n2, String string) {
        this(inputStream, n2, 512, string);
    }

    public TarArchiveInputStream(InputStream inputStream, int n2, int n3) {
        this(inputStream, n2, n3, null);
    }

    public TarArchiveInputStream(InputStream inputStream, int n2, int n3, String string) {
        this.is = inputStream;
        this.hasHitEOF = false;
        this.encoding = ZipEncodingHelper.getZipEncoding(string);
        this.recordSize = n3;
        this.blockSize = n2;
    }

    @Override
    public void close() {
        this.is.close();
    }

    public int getRecordSize() {
        return this.recordSize;
    }

    @Override
    public int available() {
        if (this.entrySize - this.entryOffset > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(this.entrySize - this.entryOffset);
    }

    @Override
    public long skip(long l2) {
        if (l2 <= 0L) {
            return 0L;
        }
        long l3 = this.entrySize - this.entryOffset;
        long l4 = this.is.skip(Math.min(l2, l3));
        this.count(l4);
        this.entryOffset += l4;
        return l4;
    }

    @Override
    public synchronized void reset() {
    }

    public TarArchiveEntry getNextTarEntry() {
        byte[] byArray;
        byte[] byArray2;
        if (this.hasHitEOF) {
            return null;
        }
        if (this.currEntry != null) {
            IOUtils.skip(this, Long.MAX_VALUE);
            this.skipRecordPadding();
        }
        if ((byArray2 = this.getRecord()) == null) {
            this.currEntry = null;
            return null;
        }
        try {
            this.currEntry = new TarArchiveEntry(byArray2, this.encoding);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IOException iOException = new IOException("Error detected parsing the header");
            iOException.initCause(illegalArgumentException);
            throw iOException;
        }
        this.entryOffset = 0L;
        this.entrySize = this.currEntry.getSize();
        if (this.currEntry.isGNULongLinkEntry()) {
            byArray = this.getLongNameData();
            if (byArray == null) {
                return null;
            }
            this.currEntry.setLinkName(this.encoding.decode(byArray));
        }
        if (this.currEntry.isGNULongNameEntry()) {
            byArray = this.getLongNameData();
            if (byArray == null) {
                return null;
            }
            this.currEntry.setName(this.encoding.decode(byArray));
        }
        if (this.currEntry.isPaxHeader()) {
            this.paxHeaders();
        }
        if (this.currEntry.isGNUSparse()) {
            this.readGNUSparse();
        }
        this.entrySize = this.currEntry.getSize();
        return this.currEntry;
    }

    private void skipRecordPadding() {
        if (this.entrySize > 0L && this.entrySize % (long)this.recordSize != 0L) {
            long l2 = this.entrySize / (long)this.recordSize + 1L;
            long l3 = l2 * (long)this.recordSize - this.entrySize;
            long l4 = IOUtils.skip(this.is, l3);
            this.count(l4);
        }
    }

    protected byte[] getLongNameData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while ((n2 = this.read(this.SMALL_BUF)) >= 0) {
            byteArrayOutputStream.write(this.SMALL_BUF, 0, n2);
        }
        this.getNextEntry();
        if (this.currEntry == null) {
            return null;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (n2 = byArray.length; n2 > 0 && byArray[n2 - 1] == 0; --n2) {
        }
        if (n2 != byArray.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
        return byArray;
    }

    private byte[] getRecord() {
        byte[] byArray = this.readRecord();
        this.hasHitEOF = this.isEOFRecord(byArray);
        if (this.hasHitEOF && byArray != null) {
            this.tryToConsumeSecondEOFRecord();
            this.consumeRemainderOfLastBlock();
            byArray = null;
        }
        return byArray;
    }

    protected boolean isEOFRecord(byte[] byArray) {
        return byArray == null || ArchiveUtils.isArrayZero(byArray, this.recordSize);
    }

    protected byte[] readRecord() {
        byte[] byArray = new byte[this.recordSize];
        int n2 = IOUtils.readFully(this.is, byArray);
        this.count(n2);
        if (n2 != this.recordSize) {
            return null;
        }
        return byArray;
    }

    private void paxHeaders() {
        Map<String, String> map = this.parsePaxHeaders(this);
        this.getNextEntry();
        this.applyPaxHeadersToCurrentEntry(map);
    }

    Map<String, String> parsePaxHeaders(InputStream inputStream) {
        int n2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        block0: do {
            int n3 = 0;
            int n4 = 0;
            while ((n2 = inputStream.read()) != -1) {
                ++n4;
                if (n2 == 32) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while ((n2 = inputStream.read()) != -1) {
                        ++n4;
                        if (n2 == 61) {
                            String string = byteArrayOutputStream.toString("UTF-8");
                            byte[] byArray = new byte[n3 - n4];
                            int n5 = IOUtils.readFully(inputStream, byArray);
                            if (n5 != n3 - n4) {
                                throw new IOException("Failed to read Paxheader. Expected " + (n3 - n4) + " bytes, read " + n5);
                            }
                            String string2 = new String(byArray, 0, n3 - n4 - 1, "UTF-8");
                            hashMap.put(string, string2);
                            continue block0;
                        }
                        byteArrayOutputStream.write((byte)n2);
                    }
                    continue block0;
                }
                n3 *= 10;
                n3 += n2 - 48;
            }
        } while (n2 != -1);
        return hashMap;
    }

    private void applyPaxHeadersToCurrentEntry(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if ("path".equals(string)) {
                this.currEntry.setName(string2);
                continue;
            }
            if ("linkpath".equals(string)) {
                this.currEntry.setLinkName(string2);
                continue;
            }
            if ("gid".equals(string)) {
                this.currEntry.setGroupId(Integer.parseInt(string2));
                continue;
            }
            if ("gname".equals(string)) {
                this.currEntry.setGroupName(string2);
                continue;
            }
            if ("uid".equals(string)) {
                this.currEntry.setUserId(Integer.parseInt(string2));
                continue;
            }
            if ("uname".equals(string)) {
                this.currEntry.setUserName(string2);
                continue;
            }
            if ("size".equals(string)) {
                this.currEntry.setSize(Long.parseLong(string2));
                continue;
            }
            if ("mtime".equals(string)) {
                this.currEntry.setModTime((long)(Double.parseDouble(string2) * 1000.0));
                continue;
            }
            if ("SCHILY.devminor".equals(string)) {
                this.currEntry.setDevMinor(Integer.parseInt(string2));
                continue;
            }
            if (!"SCHILY.devmajor".equals(string)) continue;
            this.currEntry.setDevMajor(Integer.parseInt(string2));
        }
    }

    private void readGNUSparse() {
        if (this.currEntry.isExtended()) {
            byte[] byArray;
            TarArchiveSparseEntry tarArchiveSparseEntry;
            do {
                if ((byArray = this.getRecord()) != null) continue;
                this.currEntry = null;
                break;
            } while ((tarArchiveSparseEntry = new TarArchiveSparseEntry(byArray)).isExtended());
        }
    }

    @Override
    public ArchiveEntry getNextEntry() {
        return this.getNextTarEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToConsumeSecondEOFRecord() {
        boolean bl2 = true;
        boolean bl3 = this.is.markSupported();
        if (bl3) {
            this.is.mark(this.recordSize);
        }
        try {
            bl2 = !this.isEOFRecord(this.readRecord());
        }
        finally {
            if (bl2 && bl3) {
                this.pushedBackBytes(this.recordSize);
                this.is.reset();
            }
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        if (this.hasHitEOF || this.entryOffset >= this.entrySize) {
            return -1;
        }
        if (this.currEntry == null) {
            throw new IllegalStateException("No current tar entry");
        }
        n4 = this.is.read(byArray, n2, n3 = Math.min(n3, this.available()));
        if (n4 == -1) {
            if (n3 > 0) {
                throw new IOException("Truncated TAR archive");
            }
            this.hasHitEOF = true;
        } else {
            this.count(n4);
            this.entryOffset += (long)n4;
        }
        return n4;
    }

    @Override
    public boolean canReadEntryData(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof TarArchiveEntry) {
            TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)archiveEntry;
            return !tarArchiveEntry.isGNUSparse();
        }
        return false;
    }

    public TarArchiveEntry getCurrentEntry() {
        return this.currEntry;
    }

    protected final void setCurrentEntry(TarArchiveEntry tarArchiveEntry) {
        this.currEntry = tarArchiveEntry;
    }

    protected final boolean isAtEOF() {
        return this.hasHitEOF;
    }

    protected final void setAtEOF(boolean bl2) {
        this.hasHitEOF = bl2;
    }

    private void consumeRemainderOfLastBlock() {
        long l2 = this.getBytesRead() % (long)this.blockSize;
        if (l2 > 0L) {
            long l3 = IOUtils.skip(this.is, (long)this.blockSize - l2);
            this.count(l3);
        }
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < 265) {
            return false;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar\u0000", byArray, 257, 6) && ArchiveUtils.matchAsciiBuffer("00", byArray, 263, 2)) {
            return true;
        }
        if (ArchiveUtils.matchAsciiBuffer("ustar ", byArray, 257, 6) && (ArchiveUtils.matchAsciiBuffer(" \u0000", byArray, 263, 2) || ArchiveUtils.matchAsciiBuffer("0\u0000", byArray, 263, 2))) {
            return true;
        }
        return ArchiveUtils.matchAsciiBuffer("ustar\u0000", byArray, 257, 6) && ArchiveUtils.matchAsciiBuffer("\u0000\u0000", byArray, 263, 2);
    }
}

