/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.sevenz.Archive;
import org.apache.commons.compress.archivers.sevenz.BindPair;
import org.apache.commons.compress.archivers.sevenz.BoundedRandomAccessFileInputStream;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.Coders;
import org.apache.commons.compress.archivers.sevenz.Folder;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.commons.compress.archivers.sevenz.StartHeader;
import org.apache.commons.compress.archivers.sevenz.StreamMap;
import org.apache.commons.compress.archivers.sevenz.SubStreamsInfo;
import org.apache.commons.compress.utils.BoundedInputStream;
import org.apache.commons.compress.utils.CRC32VerifyingInputStream;
import org.apache.commons.compress.utils.IOUtils;

public class SevenZFile
implements Closeable {
    static final int SIGNATURE_HEADER_SIZE = 32;
    private RandomAccessFile file;
    private final Archive archive;
    private int currentEntryIndex = -1;
    private int currentFolderIndex = -1;
    private InputStream currentFolderInputStream = null;
    private InputStream currentEntryInputStream = null;
    private byte[] password;
    static final byte[] sevenZSignature = new byte[]{55, 122, -68, -81, 39, 28};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SevenZFile(File file, byte[] byArray) {
        boolean bl2 = false;
        this.file = new RandomAccessFile(file, "r");
        try {
            this.archive = this.readHeaders(byArray);
            if (byArray != null) {
                this.password = new byte[byArray.length];
                System.arraycopy(byArray, 0, this.password, 0, byArray.length);
            } else {
                this.password = null;
            }
            bl2 = true;
        }
        finally {
            if (!bl2) {
                this.file.close();
            }
        }
    }

    public SevenZFile(File file) {
        this(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.file != null) {
            try {
                this.file.close();
            }
            finally {
                this.file = null;
                if (this.password != null) {
                    Arrays.fill(this.password, (byte)0);
                }
                this.password = null;
            }
        }
    }

    public SevenZArchiveEntry getNextEntry() {
        if (this.currentEntryIndex >= this.archive.files.length - 1) {
            return null;
        }
        ++this.currentEntryIndex;
        SevenZArchiveEntry sevenZArchiveEntry = this.archive.files[this.currentEntryIndex];
        this.buildDecodingStream();
        return sevenZArchiveEntry;
    }

    private Archive readHeaders(byte[] byArray) {
        byte[] byArray2 = new byte[6];
        this.file.readFully(byArray2);
        if (!Arrays.equals(byArray2, sevenZSignature)) {
            throw new IOException("Bad 7z signature");
        }
        byte by2 = this.file.readByte();
        byte by3 = this.file.readByte();
        if (by2 != 0) {
            throw new IOException(String.format("Unsupported 7z version (%d,%d)", by2, by3));
        }
        long l2 = 0xFFFFFFFFL & (long)Integer.reverseBytes(this.file.readInt());
        StartHeader startHeader = this.readStartHeader(l2);
        int n2 = (int)startHeader.nextHeaderSize;
        if ((long)n2 != startHeader.nextHeaderSize) {
            throw new IOException("cannot handle nextHeaderSize " + startHeader.nextHeaderSize);
        }
        this.file.seek(32L + startHeader.nextHeaderOffset);
        byte[] byArray3 = new byte[n2];
        this.file.readFully(byArray3);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray3);
        if (startHeader.nextHeaderCrc != cRC32.getValue()) {
            throw new IOException("NextHeader CRC mismatch");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        Archive archive = new Archive();
        int n3 = dataInputStream.readUnsignedByte();
        if (n3 == 23) {
            dataInputStream = this.readEncodedHeader(dataInputStream, archive, byArray);
            archive = new Archive();
            n3 = dataInputStream.readUnsignedByte();
        }
        if (n3 != 1) {
            throw new IOException("Broken or unsupported archive: no Header");
        }
        this.readHeader(dataInputStream, archive);
        dataInputStream.close();
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StartHeader readStartHeader(long l2) {
        StartHeader startHeader = new StartHeader();
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new CRC32VerifyingInputStream((InputStream)new BoundedRandomAccessFileInputStream(this.file, 20L), 20L, l2));
            startHeader.nextHeaderOffset = Long.reverseBytes(((DataInputStream)filterInputStream).readLong());
            startHeader.nextHeaderSize = Long.reverseBytes(((DataInputStream)filterInputStream).readLong());
            startHeader.nextHeaderCrc = 0xFFFFFFFFL & (long)Integer.reverseBytes(((DataInputStream)filterInputStream).readInt());
            StartHeader startHeader2 = startHeader;
            return startHeader2;
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    private void readHeader(DataInput dataInput, Archive archive) {
        int n2 = dataInput.readUnsignedByte();
        if (n2 == 2) {
            this.readArchiveProperties(dataInput);
            n2 = dataInput.readUnsignedByte();
        }
        if (n2 == 3) {
            throw new IOException("Additional streams unsupported");
        }
        if (n2 == 4) {
            this.readStreamsInfo(dataInput, archive);
            n2 = dataInput.readUnsignedByte();
        }
        if (n2 == 5) {
            this.readFilesInfo(dataInput, archive);
            n2 = dataInput.readUnsignedByte();
        }
        if (n2 != 0) {
            throw new IOException("Badly terminated header");
        }
    }

    private void readArchiveProperties(DataInput dataInput) {
        int n2 = dataInput.readUnsignedByte();
        while (n2 != 0) {
            long l2 = SevenZFile.readUint64(dataInput);
            byte[] byArray = new byte[(int)l2];
            dataInput.readFully(byArray);
            n2 = dataInput.readUnsignedByte();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataInputStream readEncodedHeader(DataInputStream dataInputStream, Archive archive, byte[] byArray) {
        this.readStreamsInfo(dataInputStream, archive);
        Folder folder = archive.folders[0];
        boolean bl2 = false;
        long l2 = 32L + archive.packPos + 0L;
        this.file.seek(l2);
        InputStream inputStream = new BoundedRandomAccessFileInputStream(this.file, archive.packSizes[0]);
        for (Coder object2 : folder.getOrderedCoders()) {
            if (object2.numInStreams != 1L || object2.numOutStreams != 1L) {
                throw new IOException("Multi input/output stream coders are not yet supported");
            }
            inputStream = Coders.addDecoder(inputStream, object2, byArray);
        }
        if (folder.hasCrc) {
            inputStream = new CRC32VerifyingInputStream(inputStream, folder.getUnpackSize(), folder.crc);
        }
        Object object3 = new byte[(int)folder.getUnpackSize()];
        DataInputStream dataInputStream2 = new DataInputStream(inputStream);
        try {
            dataInputStream2.readFully((byte[])object3);
        }
        finally {
            dataInputStream2.close();
        }
        return new DataInputStream(new ByteArrayInputStream((byte[])object3));
    }

    private void readStreamsInfo(DataInput dataInput, Archive archive) {
        int n2 = dataInput.readUnsignedByte();
        if (n2 == 6) {
            this.readPackInfo(dataInput, archive);
            n2 = dataInput.readUnsignedByte();
        }
        if (n2 == 7) {
            this.readUnpackInfo(dataInput, archive);
            n2 = dataInput.readUnsignedByte();
        } else {
            archive.folders = new Folder[0];
        }
        if (n2 == 8) {
            this.readSubStreamsInfo(dataInput, archive);
            n2 = dataInput.readUnsignedByte();
        }
        if (n2 != 0) {
            throw new IOException("Badly terminated StreamsInfo");
        }
    }

    private void readPackInfo(DataInput dataInput, Archive archive) {
        int n2;
        archive.packPos = SevenZFile.readUint64(dataInput);
        long l2 = SevenZFile.readUint64(dataInput);
        int n3 = dataInput.readUnsignedByte();
        if (n3 == 9) {
            archive.packSizes = new long[(int)l2];
            for (n2 = 0; n2 < archive.packSizes.length; ++n2) {
                archive.packSizes[n2] = SevenZFile.readUint64(dataInput);
            }
            n3 = dataInput.readUnsignedByte();
        }
        if (n3 == 10) {
            archive.packCrcsDefined = this.readAllOrBits(dataInput, (int)l2);
            archive.packCrcs = new long[(int)l2];
            for (n2 = 0; n2 < (int)l2; ++n2) {
                if (!archive.packCrcsDefined.get(n2)) continue;
                archive.packCrcs[n2] = 0xFFFFFFFFL & (long)Integer.reverseBytes(dataInput.readInt());
            }
            n3 = dataInput.readUnsignedByte();
        }
        if (n3 != 0) {
            throw new IOException("Badly terminated PackInfo (" + n3 + ")");
        }
    }

    private void readUnpackInfo(DataInput dataInput, Archive archive) {
        int n2 = dataInput.readUnsignedByte();
        if (n2 != 11) {
            throw new IOException("Expected kFolder, got " + n2);
        }
        long l2 = SevenZFile.readUint64(dataInput);
        Folder[] folderArray = new Folder[(int)l2];
        archive.folders = folderArray;
        int n3 = dataInput.readUnsignedByte();
        if (n3 != 0) {
            throw new IOException("External unsupported");
        }
        for (int i2 = 0; i2 < (int)l2; ++i2) {
            folderArray[i2] = this.readFolder(dataInput);
        }
        n2 = dataInput.readUnsignedByte();
        if (n2 != 12) {
            throw new IOException("Expected kCodersUnpackSize, got " + n2);
        }
        for (Folder folder : folderArray) {
            folder.unpackSizes = new long[(int)folder.totalOutputStreams];
            int n4 = 0;
            while ((long)n4 < folder.totalOutputStreams) {
                folder.unpackSizes[n4] = SevenZFile.readUint64(dataInput);
                ++n4;
            }
        }
        n2 = dataInput.readUnsignedByte();
        if (n2 == 10) {
            BitSet bitSet = this.readAllOrBits(dataInput, (int)l2);
            for (int i3 = 0; i3 < (int)l2; ++i3) {
                if (bitSet.get(i3)) {
                    folderArray[i3].hasCrc = true;
                    folderArray[i3].crc = 0xFFFFFFFFL & (long)Integer.reverseBytes(dataInput.readInt());
                    continue;
                }
                folderArray[i3].hasCrc = false;
            }
            n2 = dataInput.readUnsignedByte();
        }
        if (n2 != 0) {
            throw new IOException("Badly terminated UnpackInfo");
        }
    }

    private void readSubStreamsInfo(DataInput dataInput, Archive archive) {
        for (Folder folder : archive.folders) {
            folder.numUnpackSubStreams = 1;
        }
        int n2 = archive.folders.length;
        int n3 = dataInput.readUnsignedByte();
        if (n3 == 13) {
            n2 = 0;
            for (Folder folder : archive.folders) {
                long l2 = SevenZFile.readUint64(dataInput);
                folder.numUnpackSubStreams = (int)l2;
                n2 = (int)((long)n2 + l2);
            }
            n3 = dataInput.readUnsignedByte();
        }
        SubStreamsInfo subStreamsInfo = new SubStreamsInfo();
        subStreamsInfo.unpackSizes = new long[n2];
        subStreamsInfo.hasCrc = new BitSet(n2);
        subStreamsInfo.crcs = new long[n2];
        int n4 = 0;
        for (Folder folder : archive.folders) {
            if (folder.numUnpackSubStreams == 0) continue;
            long l3 = 0L;
            if (n3 == 9) {
                for (int i2 = 0; i2 < folder.numUnpackSubStreams - 1; ++i2) {
                    long l4 = SevenZFile.readUint64(dataInput);
                    subStreamsInfo.unpackSizes[n4++] = l4;
                    l3 += l4;
                }
            }
            subStreamsInfo.unpackSizes[n4++] = folder.getUnpackSize() - l3;
        }
        if (n3 == 9) {
            n3 = dataInput.readUnsignedByte();
        }
        int n5 = 0;
        for (Folder folder : archive.folders) {
            if (folder.numUnpackSubStreams == 1 && folder.hasCrc) continue;
            n5 += folder.numUnpackSubStreams;
        }
        if (n3 == 10) {
            int n6;
            BitSet bitSet = this.readAllOrBits(dataInput, n5);
            long[] lArray = new long[n5];
            for (n6 = 0; n6 < n5; ++n6) {
                if (!bitSet.get(n6)) continue;
                lArray[n6] = 0xFFFFFFFFL & (long)Integer.reverseBytes(dataInput.readInt());
            }
            n6 = 0;
            int n7 = 0;
            for (Folder folder : archive.folders) {
                if (folder.numUnpackSubStreams == 1 && folder.hasCrc) {
                    subStreamsInfo.hasCrc.set(n6, true);
                    subStreamsInfo.crcs[n6] = folder.crc;
                    ++n6;
                    continue;
                }
                for (int i3 = 0; i3 < folder.numUnpackSubStreams; ++i3) {
                    subStreamsInfo.hasCrc.set(n6, bitSet.get(n7));
                    subStreamsInfo.crcs[n6] = lArray[n7];
                    ++n6;
                    ++n7;
                }
            }
            n3 = dataInput.readUnsignedByte();
        }
        if (n3 != 0) {
            throw new IOException("Badly terminated SubStreamsInfo");
        }
        archive.subStreamsInfo = subStreamsInfo;
    }

    private Folder readFolder(DataInput dataInput) {
        int n2;
        Folder folder = new Folder();
        long l2 = SevenZFile.readUint64(dataInput);
        Coder[] coderArray = new Coder[(int)l2];
        long l3 = 0L;
        long l4 = 0L;
        for (int i2 = 0; i2 < coderArray.length; ++i2) {
            coderArray[i2] = new Coder();
            int n3 = dataInput.readUnsignedByte();
            int n4 = n3 & 0xF;
            n2 = (n3 & 0x10) == 0 ? 1 : 0;
            boolean bl2 = (n3 & 0x20) != 0;
            boolean bl3 = (n3 & 0x80) != 0;
            coderArray[i2].decompressionMethodId = new byte[n4];
            dataInput.readFully(coderArray[i2].decompressionMethodId);
            if (n2 != 0) {
                coderArray[i2].numInStreams = 1L;
                coderArray[i2].numOutStreams = 1L;
            } else {
                coderArray[i2].numInStreams = SevenZFile.readUint64(dataInput);
                coderArray[i2].numOutStreams = SevenZFile.readUint64(dataInput);
            }
            l3 += coderArray[i2].numInStreams;
            l4 += coderArray[i2].numOutStreams;
            if (bl2) {
                long l5 = SevenZFile.readUint64(dataInput);
                coderArray[i2].properties = new byte[(int)l5];
                dataInput.readFully(coderArray[i2].properties);
            }
            if (!bl3) continue;
            throw new IOException("Alternative methods are unsupported, please report. The reference implementation doesn't support them either.");
        }
        folder.coders = coderArray;
        folder.totalInputStreams = l3;
        folder.totalOutputStreams = l4;
        if (l4 == 0L) {
            throw new IOException("Total output streams can't be 0");
        }
        long l6 = l4 - 1L;
        BindPair[] bindPairArray = new BindPair[(int)l6];
        for (n2 = 0; n2 < bindPairArray.length; ++n2) {
            bindPairArray[n2] = new BindPair();
            bindPairArray[n2].inIndex = SevenZFile.readUint64(dataInput);
            bindPairArray[n2].outIndex = SevenZFile.readUint64(dataInput);
        }
        folder.bindPairs = bindPairArray;
        if (l3 < l6) {
            throw new IOException("Total input streams can't be less than the number of bind pairs");
        }
        long l7 = l3 - l6;
        long[] lArray = new long[(int)l7];
        if (l7 == 1L) {
            int n5;
            for (n5 = 0; n5 < (int)l3 && folder.findBindPairForInStream(n5) >= 0; ++n5) {
            }
            if (n5 == (int)l3) {
                throw new IOException("Couldn't find stream's bind pair index");
            }
            lArray[0] = n5;
        } else {
            for (int i3 = 0; i3 < (int)l7; ++i3) {
                lArray[i3] = SevenZFile.readUint64(dataInput);
            }
        }
        folder.packedStreams = lArray;
        return folder;
    }

    private BitSet readAllOrBits(DataInput dataInput, int n2) {
        BitSet bitSet;
        int n3 = dataInput.readUnsignedByte();
        if (n3 != 0) {
            bitSet = new BitSet(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                bitSet.set(i2, true);
            }
        } else {
            bitSet = this.readBits(dataInput, n2);
        }
        return bitSet;
    }

    private BitSet readBits(DataInput dataInput, int n2) {
        BitSet bitSet = new BitSet(n2);
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (n3 == 0) {
                n3 = 128;
                n4 = dataInput.readUnsignedByte();
            }
            bitSet.set(i2, (n4 & n3) != 0);
            n3 >>>= 1;
        }
        return bitSet;
    }

    private void readFilesInfo(DataInput dataInput, Archive archive) {
        int n2;
        long l2 = SevenZFile.readUint64(dataInput);
        SevenZArchiveEntry[] sevenZArchiveEntryArray = new SevenZArchiveEntry[(int)l2];
        for (int i2 = 0; i2 < sevenZArchiveEntryArray.length; ++i2) {
            sevenZArchiveEntryArray[i2] = new SevenZArchiveEntry();
        }
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        BitSet bitSet3 = null;
        block13: while ((n2 = dataInput.readUnsignedByte()) != 0) {
            long l3 = SevenZFile.readUint64(dataInput);
            switch (n2) {
                case 14: {
                    bitSet = this.readBits(dataInput, sevenZArchiveEntryArray.length);
                    break;
                }
                case 15: {
                    if (bitSet == null) {
                        throw new IOException("Header format error: kEmptyStream must appear before kEmptyFile");
                    }
                    bitSet2 = this.readBits(dataInput, bitSet.cardinality());
                    break;
                }
                case 16: {
                    if (bitSet == null) {
                        throw new IOException("Header format error: kEmptyStream must appear before kAnti");
                    }
                    bitSet3 = this.readBits(dataInput, bitSet.cardinality());
                    break;
                }
                case 17: {
                    int n3 = dataInput.readUnsignedByte();
                    if (n3 != 0) {
                        throw new IOException("Not implemented");
                    }
                    if ((l3 - 1L & 1L) != 0L) {
                        throw new IOException("File names length invalid");
                    }
                    byte[] byArray = new byte[(int)(l3 - 1L)];
                    dataInput.readFully(byArray);
                    int n4 = 0;
                    int n5 = 0;
                    for (int i3 = 0; i3 < byArray.length; i3 += 2) {
                        if (byArray[i3] != 0 || byArray[i3 + 1] != 0) continue;
                        sevenZArchiveEntryArray[n4++].setName(new String(byArray, n5, i3 - n5, "UTF-16LE"));
                        n5 = i3 + 2;
                    }
                    if (n5 == byArray.length && n4 == sevenZArchiveEntryArray.length) continue block13;
                    throw new IOException("Error parsing file names");
                }
                case 18: {
                    int n4;
                    BitSet bitSet4 = this.readAllOrBits(dataInput, sevenZArchiveEntryArray.length);
                    int n6 = dataInput.readUnsignedByte();
                    if (n6 != 0) {
                        throw new IOException("Unimplemented");
                    }
                    for (n4 = 0; n4 < sevenZArchiveEntryArray.length; ++n4) {
                        sevenZArchiveEntryArray[n4].setHasCreationDate(bitSet4.get(n4));
                        if (!sevenZArchiveEntryArray[n4].getHasCreationDate()) continue;
                        sevenZArchiveEntryArray[n4].setCreationDate(Long.reverseBytes(dataInput.readLong()));
                    }
                    continue block13;
                }
                case 19: {
                    int n4;
                    BitSet bitSet5 = this.readAllOrBits(dataInput, sevenZArchiveEntryArray.length);
                    int n7 = dataInput.readUnsignedByte();
                    if (n7 != 0) {
                        throw new IOException("Unimplemented");
                    }
                    for (n4 = 0; n4 < sevenZArchiveEntryArray.length; ++n4) {
                        sevenZArchiveEntryArray[n4].setHasAccessDate(bitSet5.get(n4));
                        if (!sevenZArchiveEntryArray[n4].getHasAccessDate()) continue;
                        sevenZArchiveEntryArray[n4].setAccessDate(Long.reverseBytes(dataInput.readLong()));
                    }
                    continue block13;
                }
                case 20: {
                    int n4;
                    BitSet bitSet6 = this.readAllOrBits(dataInput, sevenZArchiveEntryArray.length);
                    int n8 = dataInput.readUnsignedByte();
                    if (n8 != 0) {
                        throw new IOException("Unimplemented");
                    }
                    for (n4 = 0; n4 < sevenZArchiveEntryArray.length; ++n4) {
                        sevenZArchiveEntryArray[n4].setHasLastModifiedDate(bitSet6.get(n4));
                        if (!sevenZArchiveEntryArray[n4].getHasLastModifiedDate()) continue;
                        sevenZArchiveEntryArray[n4].setLastModifiedDate(Long.reverseBytes(dataInput.readLong()));
                    }
                    continue block13;
                }
                case 21: {
                    int n4;
                    BitSet bitSet7 = this.readAllOrBits(dataInput, sevenZArchiveEntryArray.length);
                    int n9 = dataInput.readUnsignedByte();
                    if (n9 != 0) {
                        throw new IOException("Unimplemented");
                    }
                    for (n4 = 0; n4 < sevenZArchiveEntryArray.length; ++n4) {
                        sevenZArchiveEntryArray[n4].setHasWindowsAttributes(bitSet7.get(n4));
                        if (!sevenZArchiveEntryArray[n4].getHasWindowsAttributes()) continue;
                        sevenZArchiveEntryArray[n4].setWindowsAttributes(Integer.reverseBytes(dataInput.readInt()));
                    }
                    continue block13;
                }
                case 24: {
                    throw new IOException("kStartPos is unsupported, please report");
                }
                case 25: {
                    throw new IOException("kDummy is unsupported, please report");
                }
                default: {
                    throw new IOException("Unknown property " + n2);
                }
            }
        }
        n2 = 0;
        int n10 = 0;
        for (int i4 = 0; i4 < sevenZArchiveEntryArray.length; ++i4) {
            sevenZArchiveEntryArray[i4].setHasStream(bitSet == null ? true : !bitSet.get(i4));
            if (sevenZArchiveEntryArray[i4].hasStream()) {
                sevenZArchiveEntryArray[i4].setDirectory(false);
                sevenZArchiveEntryArray[i4].setAntiItem(false);
                sevenZArchiveEntryArray[i4].setHasCrc(archive.subStreamsInfo.hasCrc.get(n2));
                sevenZArchiveEntryArray[i4].setCrcValue(archive.subStreamsInfo.crcs[n2]);
                sevenZArchiveEntryArray[i4].setSize(archive.subStreamsInfo.unpackSizes[n2]);
                ++n2;
                continue;
            }
            sevenZArchiveEntryArray[i4].setDirectory(bitSet2 == null ? true : !bitSet2.get(n10));
            sevenZArchiveEntryArray[i4].setAntiItem(bitSet3 == null ? false : bitSet3.get(n10));
            sevenZArchiveEntryArray[i4].setHasCrc(false);
            sevenZArchiveEntryArray[i4].setSize(0L);
            ++n10;
        }
        archive.files = sevenZArchiveEntryArray;
        this.calculateStreamMap(archive);
    }

    private void calculateStreamMap(Archive archive) {
        int n2;
        StreamMap streamMap = new StreamMap();
        int n3 = 0;
        int n4 = archive.folders != null ? archive.folders.length : 0;
        streamMap.folderFirstPackStreamIndex = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            streamMap.folderFirstPackStreamIndex[i2] = n3;
            n3 += archive.folders[i2].packedStreams.length;
        }
        long l2 = 0L;
        int n5 = archive.packSizes != null ? archive.packSizes.length : 0;
        streamMap.packStreamOffsets = new long[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            streamMap.packStreamOffsets[n2] = l2;
            l2 += archive.packSizes[n2];
        }
        streamMap.folderFirstFileIndex = new int[n4];
        streamMap.fileFolderIndex = new int[archive.files.length];
        n2 = 0;
        int n6 = 0;
        for (int i3 = 0; i3 < archive.files.length; ++i3) {
            if (!archive.files[i3].hasStream() && n6 == 0) {
                streamMap.fileFolderIndex[i3] = -1;
                continue;
            }
            if (n6 == 0) {
                while (n2 < archive.folders.length) {
                    streamMap.folderFirstFileIndex[n2] = i3;
                    if (archive.folders[n2].numUnpackSubStreams > 0) break;
                    ++n2;
                }
                if (n2 >= archive.folders.length) {
                    throw new IOException("Too few folders in archive");
                }
            }
            streamMap.fileFolderIndex[i3] = n2;
            if (!archive.files[i3].hasStream() || ++n6 < archive.folders[n2].numUnpackSubStreams) continue;
            ++n2;
            n6 = 0;
        }
        archive.streamMap = streamMap;
    }

    private void buildDecodingStream() {
        Object object;
        int n2 = this.archive.streamMap.fileFolderIndex[this.currentEntryIndex];
        if (n2 < 0) {
            this.currentEntryInputStream = new BoundedInputStream(new ByteArrayInputStream(new byte[0]), 0L);
            return;
        }
        SevenZArchiveEntry sevenZArchiveEntry = this.archive.files[this.currentEntryIndex];
        if (this.currentFolderIndex == n2) {
            this.drainPreviousEntry();
            sevenZArchiveEntry.setContentMethods(this.archive.files[this.currentEntryIndex - 1].getContentMethods());
        } else {
            this.currentFolderIndex = n2;
            if (this.currentFolderInputStream != null) {
                this.currentFolderInputStream.close();
                this.currentFolderInputStream = null;
            }
            object = this.archive.folders[n2];
            int n3 = this.archive.streamMap.folderFirstPackStreamIndex[n2];
            long l2 = 32L + this.archive.packPos + this.archive.streamMap.packStreamOffsets[n3];
            this.currentFolderInputStream = this.buildDecoderStack((Folder)object, l2, n3, sevenZArchiveEntry);
        }
        object = new BoundedInputStream(this.currentFolderInputStream, sevenZArchiveEntry.getSize());
        this.currentEntryInputStream = sevenZArchiveEntry.getHasCrc() ? new CRC32VerifyingInputStream((InputStream)object, sevenZArchiveEntry.getSize(), sevenZArchiveEntry.getCrcValue()) : object;
    }

    private void drainPreviousEntry() {
        if (this.currentEntryInputStream != null) {
            IOUtils.skip(this.currentEntryInputStream, Long.MAX_VALUE);
            this.currentEntryInputStream.close();
            this.currentEntryInputStream = null;
        }
    }

    private InputStream buildDecoderStack(Folder folder, long l2, int n2, SevenZArchiveEntry sevenZArchiveEntry) {
        this.file.seek(l2);
        InputStream inputStream = new BoundedRandomAccessFileInputStream(this.file, this.archive.packSizes[n2]);
        LinkedList<SevenZMethodConfiguration> linkedList = new LinkedList<SevenZMethodConfiguration>();
        for (Coder coder : folder.getOrderedCoders()) {
            if (coder.numInStreams != 1L || coder.numOutStreams != 1L) {
                throw new IOException("Multi input/output stream coders are not yet supported");
            }
            SevenZMethod sevenZMethod = SevenZMethod.byId(coder.decompressionMethodId);
            inputStream = Coders.addDecoder(inputStream, coder, this.password);
            linkedList.addFirst(new SevenZMethodConfiguration(sevenZMethod, Coders.findByMethod(sevenZMethod).getOptionsFromCoder(coder, inputStream)));
        }
        sevenZArchiveEntry.setContentMethods(linkedList);
        if (folder.hasCrc) {
            return new CRC32VerifyingInputStream(inputStream, folder.getUnpackSize(), folder.crc);
        }
        return inputStream;
    }

    public int read() {
        if (this.currentEntryInputStream == null) {
            throw new IllegalStateException("No current 7z entry");
        }
        return this.currentEntryInputStream.read();
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n2, int n3) {
        if (this.currentEntryInputStream == null) {
            throw new IllegalStateException("No current 7z entry");
        }
        return this.currentEntryInputStream.read(byArray, n2, n3);
    }

    private static long readUint64(DataInput dataInput) {
        long l2 = dataInput.readUnsignedByte();
        int n2 = 128;
        long l3 = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            if ((l2 & (long)n2) == 0L) {
                return l3 | (l2 & (long)(n2 - 1)) << 8 * i2;
            }
            long l4 = dataInput.readUnsignedByte();
            l3 |= l4 << 8 * i2;
            n2 >>>= 1;
        }
        return l3;
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < sevenZSignature.length) {
            return false;
        }
        for (int i2 = 0; i2 < sevenZSignature.length; ++i2) {
            if (byArray[i2] == sevenZSignature[i2]) continue;
            return false;
        }
        return true;
    }
}

