/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.CoderBase;
import org.tukaani.xz.FinishableOutputStream;
import org.tukaani.xz.FinishableWrapperOutputStream;
import org.tukaani.xz.LZMA2InputStream;
import org.tukaani.xz.LZMA2Options;

class LZMA2Decoder
extends CoderBase {
    LZMA2Decoder() {
        super(LZMA2Options.class, Number.class);
    }

    InputStream decode(InputStream inputStream, Coder coder, byte[] byArray) {
        try {
            int n2 = this.getDictionarySize(coder);
            return new LZMA2InputStream(inputStream, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage());
        }
    }

    OutputStream encode(OutputStream outputStream, Object object) {
        LZMA2Options lZMA2Options = this.getOptions(object);
        FinishableWrapperOutputStream finishableWrapperOutputStream = new FinishableWrapperOutputStream(outputStream);
        return lZMA2Options.getOutputStream((FinishableOutputStream)finishableWrapperOutputStream);
    }

    byte[] getOptionsAsProperties(Object object) {
        int n2 = this.getDictSize(object);
        int n3 = Integer.numberOfLeadingZeros(n2);
        int n4 = (n2 >>> 30 - n3) - 2;
        return new byte[]{(byte)((19 - n3) * 2 + n4)};
    }

    Object getOptionsFromCoder(Coder coder, InputStream inputStream) {
        return this.getDictionarySize(coder);
    }

    private int getDictSize(Object object) {
        if (object instanceof LZMA2Options) {
            return ((LZMA2Options)object).getDictSize();
        }
        return this.numberOptionOrDefault(object);
    }

    private int getDictionarySize(Coder coder) {
        int n2 = 0xFF & coder.properties[0];
        if ((n2 & 0xFFFFFFC0) != 0) {
            throw new IllegalArgumentException("Unsupported LZMA2 property bits");
        }
        if (n2 > 40) {
            throw new IllegalArgumentException("Dictionary larger than 4GiB maximum size");
        }
        if (n2 == 40) {
            return -1;
        }
        return (2 | n2 & 1) << n2 / 2 + 11;
    }

    private LZMA2Options getOptions(Object object) {
        if (object instanceof LZMA2Options) {
            return (LZMA2Options)object;
        }
        LZMA2Options lZMA2Options = new LZMA2Options();
        lZMA2Options.setDictSize(this.numberOptionOrDefault(object));
        return lZMA2Options;
    }

    private int numberOptionOrDefault(Object object) {
        return LZMA2Decoder.numberOptionOrDefault(object, 0x800000);
    }
}

