/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.dump;

import org.apache.commons.compress.archivers.zip.ZipEncoding;

class DumpArchiveUtil {
    private DumpArchiveUtil() {
    }

    public static int calculateChecksum(byte[] byArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            n2 += DumpArchiveUtil.convert32(byArray, 4 * i2);
        }
        return 84446 - (n2 - DumpArchiveUtil.convert32(byArray, 28));
    }

    public static final boolean verify(byte[] byArray) {
        int n2 = DumpArchiveUtil.convert32(byArray, 24);
        if (n2 != 60012) {
            return false;
        }
        int n3 = DumpArchiveUtil.convert32(byArray, 28);
        return n3 == DumpArchiveUtil.calculateChecksum(byArray);
    }

    public static final int getIno(byte[] byArray) {
        return DumpArchiveUtil.convert32(byArray, 20);
    }

    public static final long convert64(byte[] byArray, int n2) {
        long l2 = 0L;
        l2 += (long)byArray[n2 + 7] << 56;
        l2 += (long)byArray[n2 + 6] << 48 & 0xFF000000000000L;
        l2 += (long)byArray[n2 + 5] << 40 & 0xFF0000000000L;
        l2 += (long)byArray[n2 + 4] << 32 & 0xFF00000000L;
        l2 += (long)byArray[n2 + 3] << 24 & 0xFF000000L;
        l2 += (long)byArray[n2 + 2] << 16 & 0xFF0000L;
        l2 += (long)byArray[n2 + 1] << 8 & 0xFF00L;
        return l2 += (long)byArray[n2] & 0xFFL;
    }

    public static final int convert32(byte[] byArray, int n2) {
        int n3 = 0;
        n3 = byArray[n2 + 3] << 24;
        n3 += byArray[n2 + 2] << 16 & 0xFF0000;
        n3 += byArray[n2 + 1] << 8 & 0xFF00;
        return n3 += byArray[n2] & 0xFF;
    }

    public static final int convert16(byte[] byArray, int n2) {
        int n3 = 0;
        n3 += byArray[n2 + 1] << 8 & 0xFF00;
        return n3 += byArray[n2] & 0xFF;
    }

    static String decode(ZipEncoding zipEncoding, byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return zipEncoding.decode(byArray2);
    }
}

