/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.dump;

import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.dump.DumpArchiveConstants$SEGMENT_TYPE;
import org.apache.commons.compress.archivers.dump.DumpArchiveEntry$PERMISSION;
import org.apache.commons.compress.archivers.dump.DumpArchiveEntry$TYPE;
import org.apache.commons.compress.archivers.dump.DumpArchiveEntry$TapeSegmentHeader;
import org.apache.commons.compress.archivers.dump.DumpArchiveSummary;
import org.apache.commons.compress.archivers.dump.DumpArchiveUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumpArchiveEntry
implements ArchiveEntry {
    private String name;
    private DumpArchiveEntry$TYPE type = DumpArchiveEntry$TYPE.UNKNOWN;
    private int mode;
    private Set<DumpArchiveEntry$PERMISSION> permissions = Collections.emptySet();
    private long size;
    private long atime;
    private long mtime;
    private int uid;
    private int gid;
    private final DumpArchiveSummary summary = null;
    private final DumpArchiveEntry$TapeSegmentHeader header = new DumpArchiveEntry$TapeSegmentHeader();
    private String simpleName;
    private String originalName;
    private int volume;
    private long offset;
    private int ino;
    private int nlink;
    private long ctime;
    private int generation;
    private boolean isDeleted;

    public DumpArchiveEntry() {
    }

    public DumpArchiveEntry(String string, String string2) {
        this.setName(string);
        this.simpleName = string2;
    }

    protected DumpArchiveEntry(String string, String string2, int n2, DumpArchiveEntry$TYPE dumpArchiveEntry$TYPE) {
        this.setType(dumpArchiveEntry$TYPE);
        this.setName(string);
        this.simpleName = string2;
        this.ino = n2;
        this.offset = 0L;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    protected void setSimpleName(String string) {
        this.simpleName = string;
    }

    public int getIno() {
        return this.header.getIno();
    }

    public int getNlink() {
        return this.nlink;
    }

    public void setNlink(int n2) {
        this.nlink = n2;
    }

    public Date getCreationTime() {
        return new Date(this.ctime);
    }

    public void setCreationTime(Date date) {
        this.ctime = date.getTime();
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int n2) {
        this.generation = n2;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean bl2) {
        this.isDeleted = bl2;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long l2) {
        this.offset = l2;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int n2) {
        this.volume = n2;
    }

    public DumpArchiveConstants$SEGMENT_TYPE getHeaderType() {
        return this.header.getType();
    }

    public int getHeaderCount() {
        return this.header.getCount();
    }

    public int getHeaderHoles() {
        return this.header.getHoles();
    }

    public boolean isSparseRecord(int n2) {
        return (this.header.getCdata(n2) & 1) == 0;
    }

    public int hashCode() {
        return this.ino;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        DumpArchiveEntry dumpArchiveEntry = (DumpArchiveEntry)object;
        if (this.header == null || dumpArchiveEntry.header == null) {
            return false;
        }
        if (this.ino != dumpArchiveEntry.ino) {
            return false;
        }
        return (this.summary != null || dumpArchiveEntry.summary == null) && (this.summary == null || this.summary.equals(dumpArchiveEntry.summary));
    }

    public String toString() {
        return this.getName();
    }

    static DumpArchiveEntry parse(byte[] byArray) {
        DumpArchiveEntry dumpArchiveEntry = new DumpArchiveEntry();
        DumpArchiveEntry$TapeSegmentHeader dumpArchiveEntry$TapeSegmentHeader = dumpArchiveEntry.header;
        DumpArchiveEntry$TapeSegmentHeader.access$002(dumpArchiveEntry$TapeSegmentHeader, DumpArchiveConstants$SEGMENT_TYPE.find(DumpArchiveUtil.convert32(byArray, 0)));
        DumpArchiveEntry$TapeSegmentHeader.access$102(dumpArchiveEntry$TapeSegmentHeader, DumpArchiveUtil.convert32(byArray, 12));
        dumpArchiveEntry.ino = DumpArchiveEntry$TapeSegmentHeader.access$202(dumpArchiveEntry$TapeSegmentHeader, DumpArchiveUtil.convert32(byArray, 20));
        int n2 = DumpArchiveUtil.convert16(byArray, 32);
        dumpArchiveEntry.setType(DumpArchiveEntry$TYPE.find(n2 >> 12 & 0xF));
        dumpArchiveEntry.setMode(n2);
        dumpArchiveEntry.nlink = DumpArchiveUtil.convert16(byArray, 34);
        dumpArchiveEntry.setSize(DumpArchiveUtil.convert64(byArray, 40));
        long l2 = 1000L * (long)DumpArchiveUtil.convert32(byArray, 48) + (long)(DumpArchiveUtil.convert32(byArray, 52) / 1000);
        dumpArchiveEntry.setAccessTime(new Date(l2));
        l2 = 1000L * (long)DumpArchiveUtil.convert32(byArray, 56) + (long)(DumpArchiveUtil.convert32(byArray, 60) / 1000);
        dumpArchiveEntry.setLastModifiedDate(new Date(l2));
        dumpArchiveEntry.ctime = l2 = 1000L * (long)DumpArchiveUtil.convert32(byArray, 64) + (long)(DumpArchiveUtil.convert32(byArray, 68) / 1000);
        dumpArchiveEntry.generation = DumpArchiveUtil.convert32(byArray, 140);
        dumpArchiveEntry.setUserId(DumpArchiveUtil.convert32(byArray, 144));
        dumpArchiveEntry.setGroupId(DumpArchiveUtil.convert32(byArray, 148));
        DumpArchiveEntry$TapeSegmentHeader.access$302(dumpArchiveEntry$TapeSegmentHeader, DumpArchiveUtil.convert32(byArray, 160));
        DumpArchiveEntry$TapeSegmentHeader.access$402(dumpArchiveEntry$TapeSegmentHeader, 0);
        for (int i2 = 0; i2 < 512 && i2 < DumpArchiveEntry$TapeSegmentHeader.access$300(dumpArchiveEntry$TapeSegmentHeader); ++i2) {
            if (byArray[164 + i2] != 0) continue;
            DumpArchiveEntry$TapeSegmentHeader.access$408(dumpArchiveEntry$TapeSegmentHeader);
        }
        System.arraycopy(byArray, 164, DumpArchiveEntry$TapeSegmentHeader.access$500(dumpArchiveEntry$TapeSegmentHeader), 0, 512);
        dumpArchiveEntry.volume = dumpArchiveEntry$TapeSegmentHeader.getVolume();
        return dumpArchiveEntry;
    }

    void update(byte[] byArray) {
        DumpArchiveEntry$TapeSegmentHeader.access$102(this.header, DumpArchiveUtil.convert32(byArray, 16));
        DumpArchiveEntry$TapeSegmentHeader.access$302(this.header, DumpArchiveUtil.convert32(byArray, 160));
        DumpArchiveEntry$TapeSegmentHeader.access$402(this.header, 0);
        for (int i2 = 0; i2 < 512 && i2 < DumpArchiveEntry$TapeSegmentHeader.access$300(this.header); ++i2) {
            if (byArray[164 + i2] != 0) continue;
            DumpArchiveEntry$TapeSegmentHeader.access$408(this.header);
        }
        System.arraycopy(byArray, 164, DumpArchiveEntry$TapeSegmentHeader.access$500(this.header), 0, 512);
    }

    @Override
    public String getName() {
        return this.name;
    }

    String getOriginalName() {
        return this.originalName;
    }

    public final void setName(String string) {
        this.originalName = string;
        if (string != null) {
            if (this.isDirectory() && !string.endsWith("/")) {
                string = string + "/";
            }
            if (string.startsWith("./")) {
                string = string.substring(2);
            }
        }
        this.name = string;
    }

    @Override
    public Date getLastModifiedDate() {
        return new Date(this.mtime);
    }

    @Override
    public boolean isDirectory() {
        return this.type == DumpArchiveEntry$TYPE.DIRECTORY;
    }

    public boolean isFile() {
        return this.type == DumpArchiveEntry$TYPE.FILE;
    }

    public boolean isSocket() {
        return this.type == DumpArchiveEntry$TYPE.SOCKET;
    }

    public boolean isChrDev() {
        return this.type == DumpArchiveEntry$TYPE.CHRDEV;
    }

    public boolean isBlkDev() {
        return this.type == DumpArchiveEntry$TYPE.BLKDEV;
    }

    public boolean isFifo() {
        return this.type == DumpArchiveEntry$TYPE.FIFO;
    }

    public DumpArchiveEntry$TYPE getType() {
        return this.type;
    }

    public void setType(DumpArchiveEntry$TYPE dumpArchiveEntry$TYPE) {
        this.type = dumpArchiveEntry$TYPE;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n2) {
        this.mode = n2 & 0xFFF;
        this.permissions = DumpArchiveEntry$PERMISSION.find(n2);
    }

    public Set<DumpArchiveEntry$PERMISSION> getPermissions() {
        return this.permissions;
    }

    @Override
    public long getSize() {
        return this.isDirectory() ? -1L : this.size;
    }

    long getEntrySize() {
        return this.size;
    }

    public void setSize(long l2) {
        this.size = l2;
    }

    public void setLastModifiedDate(Date date) {
        this.mtime = date.getTime();
    }

    public Date getAccessTime() {
        return new Date(this.atime);
    }

    public void setAccessTime(Date date) {
        this.atime = date.getTime();
    }

    public int getUserId() {
        return this.uid;
    }

    public void setUserId(int n2) {
        this.uid = n2;
    }

    public int getGroupId() {
        return this.gid;
    }

    public void setGroupId(int n2) {
        this.gid = n2;
    }
}

