/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.cpio;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioConstants;
import org.apache.commons.compress.archivers.cpio.CpioUtil;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.utils.ArchiveUtils;

public class CpioArchiveOutputStream
extends ArchiveOutputStream
implements CpioConstants {
    private CpioArchiveEntry entry;
    private boolean closed = false;
    private boolean finished;
    private final short entryFormat;
    private final HashMap<String, CpioArchiveEntry> names = new HashMap();
    private long crc = 0L;
    private long written;
    private final OutputStream out;
    private final int blockSize;
    private long nextArtificalDeviceAndInode = 1L;
    private final ZipEncoding encoding;

    public CpioArchiveOutputStream(OutputStream outputStream, short s2) {
        this(outputStream, s2, 512, "US-ASCII");
    }

    public CpioArchiveOutputStream(OutputStream outputStream, short s2, int n2) {
        this(outputStream, s2, n2, "US-ASCII");
    }

    public CpioArchiveOutputStream(OutputStream outputStream, short s2, int n2, String string) {
        this.out = outputStream;
        switch (s2) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format: " + s2);
            }
        }
        this.entryFormat = s2;
        this.blockSize = n2;
        this.encoding = ZipEncodingHelper.getZipEncoding(string);
    }

    public CpioArchiveOutputStream(OutputStream outputStream) {
        this(outputStream, 1);
    }

    public CpioArchiveOutputStream(OutputStream outputStream, String string) {
        this(outputStream, 1, 512, string);
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public void putArchiveEntry(ArchiveEntry archiveEntry) {
        short s2;
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        CpioArchiveEntry cpioArchiveEntry = (CpioArchiveEntry)archiveEntry;
        this.ensureOpen();
        if (this.entry != null) {
            this.closeArchiveEntry();
        }
        if (cpioArchiveEntry.getTime() == -1L) {
            cpioArchiveEntry.setTime(System.currentTimeMillis() / 1000L);
        }
        if ((s2 = cpioArchiveEntry.getFormat()) != this.entryFormat) {
            throw new IOException("Header format: " + s2 + " does not match existing format: " + this.entryFormat);
        }
        if (this.names.put(cpioArchiveEntry.getName(), cpioArchiveEntry) != null) {
            throw new IOException("duplicate entry: " + cpioArchiveEntry.getName());
        }
        this.writeHeader(cpioArchiveEntry);
        this.entry = cpioArchiveEntry;
        this.written = 0L;
    }

    private void writeHeader(CpioArchiveEntry cpioArchiveEntry) {
        switch (cpioArchiveEntry.getFormat()) {
            case 1: {
                this.out.write(ArchiveUtils.toAsciiBytes("070701"));
                this.count(6);
                this.writeNewEntry(cpioArchiveEntry);
                break;
            }
            case 2: {
                this.out.write(ArchiveUtils.toAsciiBytes("070702"));
                this.count(6);
                this.writeNewEntry(cpioArchiveEntry);
                break;
            }
            case 4: {
                this.out.write(ArchiveUtils.toAsciiBytes("070707"));
                this.count(6);
                this.writeOldAsciiEntry(cpioArchiveEntry);
                break;
            }
            case 8: {
                boolean bl2 = true;
                this.writeBinaryLong(29127L, 2, bl2);
                this.writeOldBinaryEntry(cpioArchiveEntry, bl2);
                break;
            }
            default: {
                throw new IOException("unknown format " + cpioArchiveEntry.getFormat());
            }
        }
    }

    private void writeNewEntry(CpioArchiveEntry cpioArchiveEntry) {
        long l2 = cpioArchiveEntry.getInode();
        long l3 = cpioArchiveEntry.getDeviceMin();
        if ("TRAILER!!!".equals(cpioArchiveEntry.getName())) {
            l3 = 0L;
            l2 = 0L;
        } else if (l2 == 0L && l3 == 0L) {
            l2 = this.nextArtificalDeviceAndInode & 0xFFFFFFFFFFFFFFFFL;
            l3 = this.nextArtificalDeviceAndInode++ >> 32 & 0xFFFFFFFFFFFFFFFFL;
        } else {
            this.nextArtificalDeviceAndInode = Math.max(this.nextArtificalDeviceAndInode, l2 + 0x100000000L * l3) + 1L;
        }
        this.writeAsciiLong(l2, 8, 16);
        this.writeAsciiLong(cpioArchiveEntry.getMode(), 8, 16);
        this.writeAsciiLong(cpioArchiveEntry.getUID(), 8, 16);
        this.writeAsciiLong(cpioArchiveEntry.getGID(), 8, 16);
        this.writeAsciiLong(cpioArchiveEntry.getNumberOfLinks(), 8, 16);
        this.writeAsciiLong(cpioArchiveEntry.getTime(), 8, 16);
        this.writeAsciiLong(cpioArchiveEntry.getSize(), 8, 16);
        this.writeAsciiLong(cpioArchiveEntry.getDeviceMaj(), 8, 16);
        this.writeAsciiLong(l3, 8, 16);
        this.writeAsciiLong(cpioArchiveEntry.getRemoteDeviceMaj(), 8, 16);
        this.writeAsciiLong(cpioArchiveEntry.getRemoteDeviceMin(), 8, 16);
        this.writeAsciiLong(cpioArchiveEntry.getName().length() + 1, 8, 16);
        this.writeAsciiLong(cpioArchiveEntry.getChksum(), 8, 16);
        this.writeCString(cpioArchiveEntry.getName());
        this.pad(cpioArchiveEntry.getHeaderPadCount());
    }

    private void writeOldAsciiEntry(CpioArchiveEntry cpioArchiveEntry) {
        long l2 = cpioArchiveEntry.getInode();
        long l3 = cpioArchiveEntry.getDevice();
        if ("TRAILER!!!".equals(cpioArchiveEntry.getName())) {
            l3 = 0L;
            l2 = 0L;
        } else if (l2 == 0L && l3 == 0L) {
            l2 = this.nextArtificalDeviceAndInode & 0x3FFFFL;
            l3 = this.nextArtificalDeviceAndInode++ >> 18 & 0x3FFFFL;
        } else {
            this.nextArtificalDeviceAndInode = Math.max(this.nextArtificalDeviceAndInode, l2 + 262144L * l3) + 1L;
        }
        this.writeAsciiLong(l3, 6, 8);
        this.writeAsciiLong(l2, 6, 8);
        this.writeAsciiLong(cpioArchiveEntry.getMode(), 6, 8);
        this.writeAsciiLong(cpioArchiveEntry.getUID(), 6, 8);
        this.writeAsciiLong(cpioArchiveEntry.getGID(), 6, 8);
        this.writeAsciiLong(cpioArchiveEntry.getNumberOfLinks(), 6, 8);
        this.writeAsciiLong(cpioArchiveEntry.getRemoteDevice(), 6, 8);
        this.writeAsciiLong(cpioArchiveEntry.getTime(), 11, 8);
        this.writeAsciiLong(cpioArchiveEntry.getName().length() + 1, 6, 8);
        this.writeAsciiLong(cpioArchiveEntry.getSize(), 11, 8);
        this.writeCString(cpioArchiveEntry.getName());
    }

    private void writeOldBinaryEntry(CpioArchiveEntry cpioArchiveEntry, boolean bl2) {
        long l2 = cpioArchiveEntry.getInode();
        long l3 = cpioArchiveEntry.getDevice();
        if ("TRAILER!!!".equals(cpioArchiveEntry.getName())) {
            l3 = 0L;
            l2 = 0L;
        } else if (l2 == 0L && l3 == 0L) {
            l2 = this.nextArtificalDeviceAndInode & 0xFFFFL;
            l3 = this.nextArtificalDeviceAndInode++ >> 16 & 0xFFFFL;
        } else {
            this.nextArtificalDeviceAndInode = Math.max(this.nextArtificalDeviceAndInode, l2 + 65536L * l3) + 1L;
        }
        this.writeBinaryLong(l3, 2, bl2);
        this.writeBinaryLong(l2, 2, bl2);
        this.writeBinaryLong(cpioArchiveEntry.getMode(), 2, bl2);
        this.writeBinaryLong(cpioArchiveEntry.getUID(), 2, bl2);
        this.writeBinaryLong(cpioArchiveEntry.getGID(), 2, bl2);
        this.writeBinaryLong(cpioArchiveEntry.getNumberOfLinks(), 2, bl2);
        this.writeBinaryLong(cpioArchiveEntry.getRemoteDevice(), 2, bl2);
        this.writeBinaryLong(cpioArchiveEntry.getTime(), 4, bl2);
        this.writeBinaryLong(cpioArchiveEntry.getName().length() + 1, 2, bl2);
        this.writeBinaryLong(cpioArchiveEntry.getSize(), 4, bl2);
        this.writeCString(cpioArchiveEntry.getName());
        this.pad(cpioArchiveEntry.getHeaderPadCount());
    }

    public void closeArchiveEntry() {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        this.ensureOpen();
        if (this.entry == null) {
            throw new IOException("Trying to close non-existent entry");
        }
        if (this.entry.getSize() != this.written) {
            throw new IOException("invalid entry size (expected " + this.entry.getSize() + " but got " + this.written + " bytes)");
        }
        this.pad(this.entry.getDataPadCount());
        if (this.entry.getFormat() == 2 && this.crc != this.entry.getChksum()) {
            throw new IOException("CRC Error");
        }
        this.entry = null;
        this.crc = 0L;
        this.written = 0L;
    }

    public void write(byte[] byArray, int n2, int n3) {
        this.ensureOpen();
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        if (this.entry == null) {
            throw new IOException("no current CPIO entry");
        }
        if (this.written + (long)n3 > this.entry.getSize()) {
            throw new IOException("attempt to write past end of STORED entry");
        }
        this.out.write(byArray, n2, n3);
        this.written += (long)n3;
        if (this.entry.getFormat() == 2) {
            for (int i2 = 0; i2 < n3; ++i2) {
                this.crc += (long)(byArray[i2] & 0xFF);
            }
        }
        this.count(n3);
    }

    public void finish() {
        this.ensureOpen();
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        if (this.entry != null) {
            throw new IOException("This archive contains unclosed entries.");
        }
        this.entry = new CpioArchiveEntry(this.entryFormat);
        this.entry.setName("TRAILER!!!");
        this.entry.setNumberOfLinks(1L);
        this.writeHeader(this.entry);
        this.closeArchiveEntry();
        int n2 = (int)(this.getBytesWritten() % (long)this.blockSize);
        if (n2 != 0) {
            this.pad(this.blockSize - n2);
        }
        this.finished = true;
    }

    public void close() {
        if (!this.finished) {
            this.finish();
        }
        if (!this.closed) {
            this.out.close();
            this.closed = true;
        }
    }

    private void pad(int n2) {
        if (n2 > 0) {
            byte[] byArray = new byte[n2];
            this.out.write(byArray);
            this.count(n2);
        }
    }

    private void writeBinaryLong(long l2, int n2, boolean bl2) {
        byte[] byArray = CpioUtil.long2byteArray(l2, n2, bl2);
        this.out.write(byArray);
        this.count(byArray.length);
    }

    private void writeAsciiLong(long l2, int n2, int n3) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        if (n3 == 16) {
            stringBuilder.append(Long.toHexString(l2));
        } else if (n3 == 8) {
            stringBuilder.append(Long.toOctalString(l2));
        } else {
            stringBuilder.append(Long.toString(l2));
        }
        if (stringBuilder.length() <= n2) {
            long l3 = n2 - stringBuilder.length();
            int n4 = 0;
            while ((long)n4 < l3) {
                stringBuilder.insert(0, "0");
                ++n4;
            }
            string = stringBuilder.toString();
        } else {
            string = stringBuilder.substring(stringBuilder.length() - n2);
        }
        byte[] byArray = ArchiveUtils.toAsciiBytes(string);
        this.out.write(byArray);
        this.count(byArray.length);
    }

    private void writeCString(String string) {
        ByteBuffer byteBuffer = this.encoding.encode(string);
        int n2 = byteBuffer.limit() - byteBuffer.position();
        this.out.write(byteBuffer.array(), byteBuffer.arrayOffset(), n2);
        this.out.write(0);
        this.count(n2 + 1);
    }

    public ArchiveEntry createArchiveEntry(File file, String string) {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        return new CpioArchiveEntry(file, string);
    }
}

