/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.utils.ArchiveUtils;
import org.apache.commons.compress.utils.IOUtils;

public class ArArchiveInputStream
extends ArchiveInputStream {
    private final InputStream input;
    private long offset = 0L;
    private boolean closed;
    private ArArchiveEntry currentEntry = null;
    private byte[] namebuffer = null;
    private long entryOffset = -1L;
    private final byte[] NAME_BUF = new byte[16];
    private final byte[] LAST_MODIFIED_BUF = new byte[12];
    private final byte[] ID_BUF = new byte[6];
    private final byte[] FILE_MODE_BUF = new byte[8];
    private final byte[] LENGTH_BUF = new byte[10];
    static final String BSD_LONGNAME_PREFIX = "#1/";
    private static final int BSD_LONGNAME_PREFIX_LEN = "#1/".length();
    private static final String BSD_LONGNAME_PATTERN = "^#1/\\d+";
    private static final String GNU_STRING_TABLE_NAME = "//";
    private static final String GNU_LONGNAME_PATTERN = "^/\\d+";

    public ArArchiveInputStream(InputStream inputStream) {
        this.input = inputStream;
        this.closed = false;
    }

    public ArArchiveEntry getNextArEntry() {
        int n2;
        int n3;
        Object object;
        if (this.currentEntry != null) {
            long l2 = this.entryOffset + this.currentEntry.getLength();
            IOUtils.skip(this, l2 - this.offset);
            this.currentEntry = null;
        }
        if (this.offset == 0L) {
            byte[] byArray = ArchiveUtils.toAsciiBytes("!<arch>\n");
            object = new byte[byArray.length];
            int n4 = IOUtils.readFully(this, object);
            if (n4 != byArray.length) {
                throw new IOException("failed to read header. Occured at byte: " + this.getBytesRead());
            }
            for (n3 = 0; n3 < byArray.length; ++n3) {
                if (byArray[n3] == object[n3]) continue;
                throw new IOException("invalid header " + ArchiveUtils.toAsciiString(object));
            }
        }
        if (this.offset % 2L != 0L && this.read() < 0) {
            return null;
        }
        if (this.input.available() == 0) {
            return null;
        }
        IOUtils.readFully(this, this.NAME_BUF);
        IOUtils.readFully(this, this.LAST_MODIFIED_BUF);
        IOUtils.readFully(this, this.ID_BUF);
        int n5 = this.asInt(this.ID_BUF, true);
        IOUtils.readFully(this, this.ID_BUF);
        IOUtils.readFully(this, this.FILE_MODE_BUF);
        IOUtils.readFully(this, this.LENGTH_BUF);
        object = ArchiveUtils.toAsciiBytes("`\n");
        byte[] byArray = new byte[((byte[])object).length];
        n3 = IOUtils.readFully(this, byArray);
        if (n3 != ((byte[])object).length) {
            throw new IOException("failed to read entry trailer. Occured at byte: " + this.getBytesRead());
        }
        for (n2 = 0; n2 < ((byte[])object).length; ++n2) {
            if (object[n2] == byArray[n2]) continue;
            throw new IOException("invalid entry trailer. not read the content? Occured at byte: " + this.getBytesRead());
        }
        this.entryOffset = this.offset;
        object = ArchiveUtils.toAsciiString(this.NAME_BUF).trim();
        if (ArArchiveInputStream.isGNUStringTable((String)object)) {
            this.currentEntry = this.readGNUStringTable(this.LENGTH_BUF);
            return this.getNextArEntry();
        }
        long l3 = this.asLong(this.LENGTH_BUF);
        if (object.endsWith("/")) {
            object = object.substring(0, object.length() - 1);
        } else if (this.isGNULongName((String)object)) {
            n2 = Integer.parseInt(object.substring(1));
            object = this.getExtendedName(n2);
        } else if (ArArchiveInputStream.isBSDLongName((String)object)) {
            object = this.getBSDLongName((String)object);
            n2 = object.length();
            l3 -= (long)n2;
            this.entryOffset += (long)n2;
        }
        this.currentEntry = new ArArchiveEntry((String)object, l3, n5, this.asInt(this.ID_BUF, true), this.asInt(this.FILE_MODE_BUF, 8), this.asLong(this.LAST_MODIFIED_BUF));
        return this.currentEntry;
    }

    private String getExtendedName(int n2) {
        if (this.namebuffer == null) {
            throw new IOException("Cannot process GNU long filename as no // record was found");
        }
        for (int i2 = n2; i2 < this.namebuffer.length; ++i2) {
            if (this.namebuffer[i2] != 10) continue;
            if (this.namebuffer[i2 - 1] == 47) {
                --i2;
            }
            return ArchiveUtils.toAsciiString(this.namebuffer, n2, i2 - n2);
        }
        throw new IOException("Failed to read entry: " + n2);
    }

    private long asLong(byte[] byArray) {
        return Long.parseLong(ArchiveUtils.toAsciiString(byArray).trim());
    }

    private int asInt(byte[] byArray) {
        return this.asInt(byArray, 10, false);
    }

    private int asInt(byte[] byArray, boolean bl2) {
        return this.asInt(byArray, 10, bl2);
    }

    private int asInt(byte[] byArray, int n2) {
        return this.asInt(byArray, n2, false);
    }

    private int asInt(byte[] byArray, int n2, boolean bl2) {
        String string = ArchiveUtils.toAsciiString(byArray).trim();
        if (string.length() == 0 && bl2) {
            return 0;
        }
        return Integer.parseInt(string, n2);
    }

    public ArchiveEntry getNextEntry() {
        return this.getNextArEntry();
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.input.close();
        }
        this.currentEntry = null;
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4 = n3;
        if (this.currentEntry != null) {
            long l2 = this.entryOffset + this.currentEntry.getLength();
            if (n3 > 0 && l2 > this.offset) {
                n4 = (int)Math.min((long)n3, l2 - this.offset);
            } else {
                return -1;
            }
        }
        int n5 = this.input.read(byArray, n2, n4);
        this.count(n5);
        this.offset += n5 > 0 ? (long)n5 : 0L;
        return n5;
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < 8) {
            return false;
        }
        if (byArray[0] != 33) {
            return false;
        }
        if (byArray[1] != 60) {
            return false;
        }
        if (byArray[2] != 97) {
            return false;
        }
        if (byArray[3] != 114) {
            return false;
        }
        if (byArray[4] != 99) {
            return false;
        }
        if (byArray[5] != 104) {
            return false;
        }
        if (byArray[6] != 62) {
            return false;
        }
        return byArray[7] == 10;
    }

    private static boolean isBSDLongName(String string) {
        return string != null && string.matches(BSD_LONGNAME_PATTERN);
    }

    private String getBSDLongName(String string) {
        int n2 = Integer.parseInt(string.substring(BSD_LONGNAME_PREFIX_LEN));
        byte[] byArray = new byte[n2];
        int n3 = IOUtils.readFully(this.input, byArray);
        this.count(n3);
        if (n3 != n2) {
            throw new EOFException();
        }
        return ArchiveUtils.toAsciiString(byArray);
    }

    private static boolean isGNUStringTable(String string) {
        return GNU_STRING_TABLE_NAME.equals(string);
    }

    private ArArchiveEntry readGNUStringTable(byte[] byArray) {
        int n2 = this.asInt(byArray);
        this.namebuffer = new byte[n2];
        int n3 = IOUtils.readFully(this, this.namebuffer, 0, n2);
        if (n3 != n2) {
            throw new IOException("Failed to read complete // record: expected=" + n2 + " read=" + n3);
        }
        return new ArArchiveEntry(GNU_STRING_TABLE_NAME, n2);
    }

    private boolean isGNULongName(String string) {
        return string != null && string.matches(GNU_LONGNAME_PATTERN);
    }
}

